

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2GetContainerListNewSecurity.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  DM2GetContainerListNewSecurity()
--  | Description:  Gets list of Containers
--  +========================================================================+
-- dataServer_h_rcsid[]="$ $Id: DM2GetContainerListNewSecurity.sp,v 1.3.32.1 2018/03/27 08:58:56 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DM2GetContainerListNewSecurity <<<'

IF EXISTS (select * from sysobjects where name='DM2GetContainerListNewSecurity')
	drop procedure DM2GetContainerListNewSecurity
IF EXISTS (select * from GxQscripts where name='DM2GetContainerListNewSecurity')
	delete from GxQscripts where name = 'DM2GetContainerListNewSecurity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetContainerListNewSecurity')
	delete from GXDBVersions where aliasname = 'DM2GetContainerListNewSecurity'
GO
print '... Creating Procedure: DM2GetContainerListNewSecurity'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DM2GetContainerListNewSecurity
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_userId INT=0,
  @i_localeId integer=-1,
  @i_xmlText XML
AS
  DECLARE @o_containerId integer;
  DECLARE @o_containerName varchar(1024);
  DECLARE @o_containerGUID varchar(36);
  DECLARE @o_userName nvarchar(512);
  DECLARE @o_userList nvarchar(MAX);
SET NOCOUNT ON
BEGIN
DECLARE @i_entityType		INT
DECLARE @i_userGUID			VARCHAR(36)
DECLARE @o_errorCode INT = 0
DECLARE @o_errorString NVARCHAR(MAX)
SET	@i_userGUID = ISNULL (( SELECT ref.value('@userGuid', 'VARCHAR(36)')
					FROM  @i_xmlText.nodes ('DM2ContentIndexing_GetContainersReq') R(ref)), '')
SET @i_entityType = ISNULL (( SELECT ref.value('@entityType', 'INT')
					FROM  @i_xmlText.nodes ('DM2ContentIndexing_GetContainersReq') R(ref)), 0)
IF ( len(@i_userGUID) > 0 )
BEGIN
	SET @i_userId = ( SELECT id FROM UMUsers WHERE userGuid = @i_userGUID and enabled = 1)
END
IF ( @i_userId = 0 )
BEGIN
	SET @o_errorCode = 2
	SET @o_errorString = 'User not found for GUID ' + @i_userGUID
	GOTO EXIT_ERROR
END
IF object_id('tempdb.dbo.#tmpReviewSets') IS NOT null DROP TABLE #tmpReviewSets
create table  #tmpReviewSets (t_containerId INT, t_containerGUID varchar(36), t_containerName varchar(1024),  t_containerType INT, t_attribute INT, t_comment varchar(512), t_containerOwnerType INT, t_capabilities BIGINT, t_userName varchar(512), t_userGUID varchar(36), t_aliasName varchar(512), t_userList NVARCHAR(MAX))
IF ( @i_entityType = 9501 )
begin
	insert into #tmpReviewSets (t_containerId , t_containerGUID , t_containerName ,  t_containerType , t_attribute , t_comment , t_containerOwnerType , t_capabilities , t_userName , t_userGUID , t_aliasName)
	EXEC DM2GetReviewSetList
		@i_userId = @i_userId,
		@i_localeId = @i_localeId,
		@i_xmlText = @i_xmlText
	declare @reviewSetId INT
	declare @xmlOut XML=''
	declare @tmpSharedUsersReviewSets table (t_containerId INT, t_userName nvarchar(512))
	DECLARE reviewSetList CURSOR FOR SELECT DISTINCT t_containerId from #tmpReviewSets
	OPEN reviewSetList
	FETCH NEXT FROM reviewSetList INTO @reviewSetId
	WHILE @@FETCH_STATUS = 0
	BEGIN
			exec sec_getSecurityForEntity 1, @xmlOut output , 9501, @reviewSetId
			INSERT INTO @tmpSharedUsersReviewSets	 ( t_userName)
			 (select ref.value('@userName', 'nvarchar(512)') FROM  @xmlOut.nodes ('associations/userOrGroup') R(ref))
			INSERT INTO @tmpSharedUsersReviewSets	 ( t_userName)
			 (select ref.value('@userGroupName', 'nvarchar(512)') FROM  @xmlOut.nodes ('associations/userOrGroup') R(ref))
			update #tmpReviewSets
			set t_userList  = ISNULL((SELECT  distinct STUFF((SELECT ', ' + CAST(t_userName AS VARCHAR(10)) [text()]
							 FROM @tmpSharedUsersReviewSets
							FOR XML PATH(''), TYPE)
							.value('.','NVARCHAR(MAX)'),1,2,' ') List_Output
							FROM @tmpSharedUsersReviewSets t),'')
			where t_containerId = @reviewSetId
		delete from  @tmpSharedUsersReviewSets
		FETCH NEXT FROM reviewSetList INTO @reviewSetId
	END
	CLOSE reviewSetList
	DEALLOCATE reviewSetList
END
EXIT_ERROR:
select t_containerId, t_containerName, t_containerGUID, t_aliasName, t_userList
from #tmpReviewSets
DROP table #tmpReviewSets
END
GO

IF EXISTS (select * from GxQscripts where name = 'DM2GetContainerListNewSecurity')
	delete from GxQscripts where name = 'DM2GetContainerListNewSecurity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetContainerListNewSecurity')
	delete from GXDBVersions where aliasname = 'DM2GetContainerListNewSecurity'
GO

insert into GXDBVersions values(2, 'DM2GetContainerListNewSecurity',  '00010003003200010000', 'DM2GetContainerListNewSecurity', '00010003003200010000')
GO

