

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2GetContainerList.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  DM2GetContainerList()
--  | Description:  Gets list of Containers
--  +========================================================================+
-- dataServer_h_rcsid[]="$ $Id: DM2GetContainerList.sp,v 1.8.274.2 2018/03/27 08:45:57 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DM2GetContainerList <<<'

IF EXISTS (select * from sysobjects where name='DM2GetContainerList')
	drop procedure DM2GetContainerList
IF EXISTS (select * from GxQscripts where name='DM2GetContainerList')
	delete from GxQscripts where name = 'DM2GetContainerList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetContainerList')
	delete from GXDBVersions where aliasname = 'DM2GetContainerList'
GO
print '... Creating Procedure: DM2GetContainerList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DM2GetContainerList
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_userId INT=0,
  @i_localeId integer=-1,
  @i_xmlText XML
AS
SET NOCOUNT ON
BEGIN
DECLARE @i_entityType		INT
DECLARE @i_isTableOut		INT
DECLARE @i_userGUID			VARCHAR(36)
DECLARE @o_errorCode INT = 0
DECLARE @o_errorString NVARCHAR(MAX)
SET	@i_userGUID = ISNULL (( SELECT ref.value('@userGuid', 'VARCHAR(36)')
					FROM  @i_xmlText.nodes ('DM2ContentIndexing_GetContainersReq') R(ref)), '')
SET @i_isTableOut = ISNULL (( SELECT ref.value('@isTableOutput', 'INT')
					FROM  @i_xmlText.nodes ('DM2ContentIndexing_GetContainersReq') R(ref)), 0)
SET @i_entityType = ISNULL (( SELECT ref.value('@entityType', 'INT')
					FROM  @i_xmlText.nodes ('DM2ContentIndexing_GetContainersReq') R(ref)), 0)
IF ( len(@i_userGUID) > 0 )
BEGIN
	SET @i_userId = ( SELECT id FROM UMUsers WHERE userGuid = @i_userGUID and enabled = 1)
END
IF ( @i_userId = 0 )
BEGIN
	SET @o_errorCode = 2
	SET @o_errorString = 'User not found for GUID ' + @i_userGUID
	GOTO EXIT_ERROR
END
IF ( @i_entityType = 9501 )
	EXEC DM2GetReviewSetList
		@i_userId = @i_userId,
		@i_localeId = @i_localeId,
		@i_xmlText = @i_xmlText
ELSE IF ( @i_entityType = 9502 )
	EXEC DM2GetQuerySetList
		@i_userId = @i_userId,
		@i_localeId = @i_localeId,
		@i_xmlText = @i_xmlText
ELSE IF ( @i_entityType = 9503 )
	EXEC DM2GetDownloadSetList
		@i_userId = @i_userId,
		@i_localeId = @i_localeId,
		@i_xmlText = @i_xmlText
ELSE IF ( @i_entityType = 9504 )
	EXEC DM2GetTagSetList
		@i_userId = @i_userId,
		@i_localeId = @i_localeId,
		@i_xmlText = @i_xmlText
ELSE
 -- error
	BEGIN
		SET @o_errorCode = 1
		SET @o_errorString = 'Unrecognized option'
	END
EXIT_ERROR:
	IF (@o_errorCode <> 0)
	BEGIN
		SELECT	@o_errorCode			as 'errList/@errorCode',
		@o_errorString			as 'errList/@errLogMessage'
		FOR XML PATH(''), ROOT('DM2ContentIndexing_GenericResp')
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'DM2GetContainerList')
	delete from GxQscripts where name = 'DM2GetContainerList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetContainerList')
	delete from GXDBVersions where aliasname = 'DM2GetContainerList'
GO

insert into GXDBVersions values(2, 'DM2GetContainerList',  '00010008027400020000', 'DM2GetContainerList', '00010008027400020000')
GO

