

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2GetContainerInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DM2GetContainerInfo.sp,v $ $Id: DM2GetContainerInfo.sp,v 1.1.2.2 2018/11/29 23:53:07 sgolla Exp $";
--
--  +========================================================================+
--  |   Procedure:  DM2GetContainerInfo()
--  |
--  | Description:
--  |
--  |       Input:
--	|
--  |      Output:
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--	|
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='DM2GetContainerInfo')
BEGIN
	print '>>> Drop Stored Procedure: DM2GetContainerInfo <<<'
	drop procedure DM2GetContainerInfo
END
IF EXISTS (select * from GxQscripts where name='DM2GetContainerInfo')
	delete from GxQscripts where name = 'DM2GetContainerInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetContainerInfo')
	delete from GXDBVersions where aliasname = 'DM2GetContainerInfo'
GO
print '... Creating Procedure: DM2GetContainerInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure DM2GetContainerInfo
  @i_userId INT = 0,
  @i_userGUID varchar(512) = '',
  @i_containerType integer = '',
  @i_containerId integer = 0,
  @i_containerName varchar(512) = ''
AS
SET NOCOUNT ON
BEGIN
    IF OBJECT_ID('tempdb.dbo.#containerList_temp') IS NOT NULL DROP TABLE #containerList_temp
    CREATE TABLE #containerList_temp(containerId int)
	--
	IF @i_userId IS NULL SET @i_userId = 0
	IF @i_containerId IS NULL SET @i_containerId = 0
	IF @i_userGUID IS NULL SET @i_userGUID = ''
	--
    IF @i_userId = 0 AND @i_userGUID <> ''
    BEGIN
        SELECT @i_userId = id from UMUsers WHERE userGuid = @i_userGUID
    END
    ELSE IF @i_userGUID = '' AND @i_userId <> 0
    BEGIN
        SELECT @i_userGUID = userGuid from UMUsers WHERE id = @i_userId
    END
    -- we need container information for a single container for the given userId
    IF @i_containerId <> 0 OR @i_containerName <> ''
    BEGIN
        IF @i_containerId = 0
            SELECT @i_containerId = containerId from DM2Container WHERE containerName = @i_containerName AND containerType = @i_containerType
        IF @i_containerType = ''
            SELECT @i_containerType = containerType from DM2Container WHERE containerId = @i_containerId
        -- check if user is the owner for the container
        IF @i_userId <> 0
        BEGIN
            DECLARE @isOwner int
            SELECT @isOwner = dbo.IsUserCreator(@i_userId, @i_containerType, @i_containerId)
            IF @isOwner = 1
            BEGIN
                INSERT INTO #containerList_temp VALUES(@i_containerId)
            END
        END
        ELSE
        BEGIN
            --If userid not supplied, there is no security context, so we will return the information for requested container
            INSERT INTO #containerList_temp VALUES(@i_containerId)
        END
    END
	--
	-- when containerid is 0, we will get all containers for specified user..
	--
    IF @i_containerId = 0 AND @i_userId <> 0
    BEGIN
        IF OBJECT_ID('tempdb.dbo.#UserHasPermissionOnEntity_temp') IS NOT NULL DROP TABLE #UserHasPermissionOnEntity_temp
	    CREATE TABLE #UserHasPermissionOnEntity_temp(entityId int)
        EXEC dbo.sec_getNonIdaObjectsForThisUser @i_userId, @i_containerType, 0, '#UserHasPermissionOnEntity_temp'
        INSERT INTO #containerList_temp
        SELECT entityId FROM #UserHasPermissionOnEntity_temp
    END
    SELECT DC.containerName, DC.cloudId, DC.containerGuid, @i_userGUID AS UserGuid, DC.containerType, @i_userId AS userId, DC.containerId
    FROM #containerList_temp CT INNER JOIN DM2Container DC ON DC.containerId = CT.containerId
    -- drop temp tables
    IF OBJECT_ID('tempdb.dbo.#UserHasPermissionOnEntity_temp') IS NOT NULL DROP TABLE #UserHasPermissionOnEntity_temp
    IF OBJECT_ID('tempdb.dbo.#containerList_temp') IS NOT NULL DROP TABLE #containerList_temp
END
  SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'DM2GetContainerInfo')
	delete from GxQscripts where name = 'DM2GetContainerInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetContainerInfo')
	delete from GXDBVersions where aliasname = 'DM2GetContainerInfo'
GO

insert into GXDBVersions values(2, 'DM2GetContainerInfo',  '00010001000200020000', 'DM2GetContainerInfo', '00010001000200020000')
GO

