

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2GetComplianceUserList.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  DM2GetComplianceUserList()
--  | Description:  Gets list of Compliance Users
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DM2GetComplianceUserList.sp,v $ $Id: DM2GetComplianceUserList.sp,v 1.4.48.2 2018/03/27 08:42:47 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DM2GetComplianceUserList <<<'

IF EXISTS (select * from sysobjects where name='DM2GetComplianceUserList')
	drop procedure DM2GetComplianceUserList
IF EXISTS (select * from GxQscripts where name='DM2GetComplianceUserList')
	delete from GxQscripts where name = 'DM2GetComplianceUserList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetComplianceUserList')
	delete from GXDBVersions where aliasname = 'DM2GetComplianceUserList'
GO
print '... Creating Procedure: DM2GetComplianceUserList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DM2GetComplianceUserList
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_userId INT,
  @i_localeId INT=-1,
  @i_xmlText XML
AS
  DECLARE @o_xmlText XML
SET NOCOUNT ON
BEGIN
	DECLARE @i_capability		BIGINT
	DECLARE @o_errorCode		INT
	DECLARE @o_errorString		NVARCHAR(MAX)
	SET @o_errorCode = 0
	SET @o_errorString = ''
	--GET USER NAME FOR INPUT FROM JAVA GUI
SET @i_capability = CONVERT(bigint, POWER(2.0, 25 - 1))
	DECLARE @t_caps TABLE (id integer, userGuid varchar(36), cap bigint)
	DECLARE @userIdTemp INT = 0
	DECLARE userCursor CURSOR STATIC FOR
		SELECT id
		FROM UMUsers
	OPEN userCursor
	FETCH NEXT FROM userCursor INTO @userIDTemp
	WHILE @@FETCH_STATUS = 0
	BEGIN
		DECLARE @capList TABLE (permissionId BIGINT)
		DELETE FROM @capList
		INSERT INTO @capList
			exec sec_checkUserHasCapWithoutAssoc @userIdTEmp
		INSERT INTO @t_caps
			SELECT @userIdTEmp, '', permissionId
			FROM @capList
			WHERE permissionId <> 0
		FETCH NEXT FROM userCursor INTO @userIDTemp
	END
	CLOSE userCursor
	DEALLOCATE userCursor
	SELECT U.id '@userId', name '@userName', login '@userLogin', U.userGuid '@userGUID', T.cap '@capabilities'
	FROM UMUsers U INNER JOIN @t_caps T
	ON T.id = U.id
WHERE T.cap & @i_capability > 0 AND (U.flags & 0x004 = 0)
	FOR XML PATH('users'), ROOT('DM2ContentIndexing_GetComplianceUsersResp')
EXIT_ERROR:
END
GO

IF EXISTS (select * from GxQscripts where name = 'DM2GetComplianceUserList')
	delete from GxQscripts where name = 'DM2GetComplianceUserList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetComplianceUserList')
	delete from GXDBVersions where aliasname = 'DM2GetComplianceUserList'
GO

insert into GXDBVersions values(2, 'DM2GetComplianceUserList',  '00010004004800020000', 'DM2GetComplianceUserList', '00010004004800020000')
GO

