

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2GetClientsForCaseSearch.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  DM2GetClientsForCaseSearch()
--  | Description:  Get clients for given case list.
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DM2GetClientsForCaseSearch.sp,v $ $Id: DM2GetClientsForCaseSearch.sp,v 1.3.66.2 2018/03/27 08:46:00 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DM2GetClientsForCaseSearch <<<'

IF EXISTS (select * from sysobjects where name='DM2GetClientsForCaseSearch')
	drop procedure DM2GetClientsForCaseSearch
IF EXISTS (select * from GxQscripts where name='DM2GetClientsForCaseSearch')
	delete from GxQscripts where name = 'DM2GetClientsForCaseSearch'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetClientsForCaseSearch')
	delete from GXDBVersions where aliasname = 'DM2GetClientsForCaseSearch'
GO
print '... Creating Procedure: DM2GetClientsForCaseSearch'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DM2GetClientsForCaseSearch
  @i_xmlText XML
AS
BEGIN
DECLARE @caseId INT
DECLARE @caseXML XML
IF object_id('tempdb.dbo.#userClientIdTbl') IS NOT NULL
DROP TABLE #userClientIdTbl
CREATE TABLE #userClientIdTbl ( id integer, appId integer, holdType integer)
DECLARE caseIdCursor CURSOR FOR
SELECT T.ref.value('@caseId', 'int') FROM  @i_xmlText.nodes('/DM2ContentIndexing_CvAdvancedSearchGroup/caseList') T(ref)
OPEN caseIdCursor;
FETCH NEXT FROM caseIdCursor INTO @caseId
While @@FETCH_STATUS = 0
BEGIN
	PRINT 'Processing case # ' + CONVERT(VARCHAR(10), @caseId)
	exec dbo.DM2GetAllCaseClients NULL, @caseId
	FETCH NEXT FROM caseIdCursor INTO @caseId
END
CLOSE caseIdCursor
DEALLOCATE caseIdCursor
SELECT DISTINCT id FROM #userClientIdTbl
END

IF EXISTS (select * from GxQscripts where name = 'DM2GetClientsForCaseSearch')
	delete from GxQscripts where name = 'DM2GetClientsForCaseSearch'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetClientsForCaseSearch')
	delete from GXDBVersions where aliasname = 'DM2GetClientsForCaseSearch'
GO

insert into GXDBVersions values(2, 'DM2GetClientsForCaseSearch',  '00010003006600020000', 'DM2GetClientsForCaseSearch', '00010003006600020000')
GO

