

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2GetClientsByServerType.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DM2GetClientsByServerType.sp,v $ $Id: DM2GetClientsByServerType.sp,v 1.1.4.7 2020/09/28 21:29:41 pankajkumar Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='DM2GetClientsByServerType')
BEGIN
	print '>>> Drop Stored Procedure: DM2GetClientsByServerType <<<'
	drop procedure DM2GetClientsByServerType
END
IF EXISTS (select * from GxQscripts where name='DM2GetClientsByServerType')
	delete from GxQscripts where name = 'DM2GetClientsByServerType'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetClientsByServerType')
	delete from GXDBVersions where aliasname = 'DM2GetClientsByServerType'
GO
print '... Creating Procedure: DM2GetClientsByServerType'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure DM2GetClientsByServerType
  @i_userId INT =0,
  @i_serverType INT =0,
  @i_includeConfigured INT =0
AS
SET NOCOUNT ON
  DECLARE @o_xmlOut XML
IF object_id('tempdb.dbo.#packageIdTbl') IS NOT null DROP TABLE #packageIdTbl
	CREATE TABLE #packageIdTbl (packageId INT)
 --index server cloud type
DECLARE @APP_CLOUDSERVERTYPE_ANALYTICSENGINE INT = 1
DECLARE @APP_CLOUDSERVERTYPE_CONTENTANALYZER INT = 2
DECLARE @APP_CLOUDSERVERTYPE_SOLRCLUSTERCLOUD INT = 5
DECLARE @APP_CLOUDSERVERTYPE_INDEXSERVERPOOL INT = 9
--currently only supported for index store & content analyzer package
IF @i_serverType IN (@APP_CLOUDSERVERTYPE_ANALYTICSENGINE, @APP_CLOUDSERVERTYPE_CONTENTANALYZER , @APP_CLOUDSERVERTYPE_SOLRCLUSTERCLOUD) AND @i_userId > 0
BEGIN
	--legacy index server, cluster index server
	IF @i_serverType IN (@APP_CLOUDSERVERTYPE_ANALYTICSENGINE, @APP_CLOUDSERVERTYPE_SOLRCLUSTERCLOUD)
		INSERT INTO #packageIdTbl (packageId) VALUES
(55),(1306)
	ELSE
		INSERT INTO #packageIdTbl (packageId) VALUES
(729),(1108)
	-- Get all clients associated to user
	IF object_id('tempdb.dbo.#tblSecObj_Client') is not null DROP TABLE #tblSecObj_Client
	CREATE TABLE #tblSecObj_Client
	(
		clientId INT, appTypeId INT, instanceId INT, backupsetId INT, subclientId INT
	)
	EXEC sec_getIdaObjectsForUser @i_userId, 3 /*CLIENT_ENTITY */ , 0 /*View*/, 0, '#tblSecObj_Client'
	--
	-- get all clients with given packageid
	IF OBJECT_ID('tempdb.dbo.#getCloudClients') IS NOT NULL     DROP TABLE #getCloudClients
	CREATE TABLE #getCloudClients
	(
		clientId INT,
		clientName NVARCHAR(256),
		hostName NVARCHAR(256),
		osId INT,
		osType NVARCHAR(64),
		instance NVARCHAR(64)
	)
	--get all clients with content analyzer / anlaytics package installed
	INSERT INTO #getCloudClients (clientId, clientName, hostName, osId, osType, instance)
	SELECT C.id, C.name, C.net_hostname, c.simOperatingSystemId, OS.Type, CP.attrVal
	FROM APP_Client C (NOLOCK)
	JOIN #tblSecObj_Client SC ON SC.clientId = C.id
	JOIN simOperatingSystem OS (NOLOCK) ON C.simOperatingSystemId =OS.id
	JOIN simInstalledPackages S (NOLOCK) ON C.id = S.ClientId
	JOIN APP_ClientProp CP (NOLOCK) ON CP.componentNameId = C.id AND CP.attrName = 'Galaxy Instance name'
	WHERE S.simPackageID IN( SELECT packageId from #packageIdTbl )
	--by default delete client which are part of index server / content analyzer
	IF @i_includeConfigured = 0
	BEGIN
		IF @i_serverType IN (@APP_CLOUDSERVERTYPE_ANALYTICSENGINE, @APP_CLOUDSERVERTYPE_SOLRCLUSTERCLOUD)
		BEGIN
			DELETE T
			FROM #getCloudClients T
			JOIN DM2SearchServerCoreInfo S (NOLOCK) ON S.clientId = T.clientId
			JOIN DM2Cloud C (NOLOCK) ON C.cloudId = S.cloudId
			WHERE S.cloudType IN (@APP_CLOUDSERVERTYPE_ANALYTICSENGINE, @APP_CLOUDSERVERTYPE_SOLRCLUSTERCLOUD, @APP_CLOUDSERVERTYPE_INDEXSERVERPOOL)
		END
		ELSE IF @i_serverType = @APP_CLOUDSERVERTYPE_CONTENTANALYZER
		BEGIN
			DELETE T
			FROM #getCloudClients T
			JOIN DM2SearchServerCoreInfo S (NOLOCK) ON S.clientId = T.clientId
			JOIN DM2Cloud C (NOLOCK) ON C.cloudId = S.cloudId
			WHERE S.cloudType = @APP_CLOUDSERVERTYPE_CONTENTANALYZER
		END
	END
	SET @o_xmlOut = ISNULL((SELECT
							(SELECT
								(SELECT
									(SELECT
                                        clientId AS '@clientId',
                                        clientName AS '@clientName',
                                        hostName AS '@hostName'
                                        FOR XML PATH('clientEntity'), TYPE
									),
									(SELECT
                                        osId AS '@osId',
                                        osType AS '@Type'
                                        FOR XML PATH('osInfo'), TYPE
									)
									FOR XML PATH('client'), TYPE )
									,
									(SELECT
                                        instance AS '@simpanaInstance'
                                        FOR XML PATH('clientProps'), TYPE
									)
						FROM #getCloudClients
						ORDER BY clientName
						FOR XML PATH('clientProperties'), TYPE)
					 FOR XML PATH('AppMsg_GetClientPropertiesResponse')
                     ),'<AppMsg_GetClientPropertiesResponse/>')
	--output
	SELECT @o_xmlOut
	IF object_id('tempdb.dbo.#tblSecObj_Client') is not null DROP TABLE #tblSecObj_Client
	IF OBJECT_ID('tempdb.dbo.#getCloudClients') IS NOT NULL     DROP TABLE #getCloudClients
	IF object_id('tempdb.dbo.#packageIdTbl') is not null DROP TABLE #packageIdTbl
END
GO

IF EXISTS (select * from GxQscripts where name = 'DM2GetClientsByServerType')
	delete from GxQscripts where name = 'DM2GetClientsByServerType'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetClientsByServerType')
	delete from GXDBVersions where aliasname = 'DM2GetClientsByServerType'
GO

insert into GXDBVersions values(2, 'DM2GetClientsByServerType',  '00010001000400070000', 'DM2GetClientsByServerType', '00010001000400070000')
GO

