

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2GetCaseList.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  DM2GetCaseList()
--  | Description:  Get list of cases for given user.
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DM2GetCaseList.sp,v $ $Id: DM2GetCaseList.sp,v 1.9.12.6 2019/09/19 14:31:06 csingh Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='DM2GetCaseList')
BEGIN
	print '>>> Drop Stored Procedure: DM2GetCaseList <<<'
	drop procedure DM2GetCaseList
END
IF EXISTS (select * from GxQscripts where name='DM2GetCaseList')
	delete from GxQscripts where name = 'DM2GetCaseList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetCaseList')
	delete from GXDBVersions where aliasname = 'DM2GetCaseList'
GO
print '... Creating Procedure: DM2GetCaseList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DM2GetCaseList
  @ForUser INT = 0,
  @CaseId INT = 0,
  @ADGroupList nvarchar(MAX) = N'',
  @SortColumn varchar(255) = 'CreateTime',
  @SortOrder varchar(10) = 'desc',
  @StartIndex integer = 0,
  @PageSize integer = 25, 
  @FetchFullInfo integer = 0,
  @CaseIdList varchar(max) = '',
  @Debug integer = 0
AS
BEGIN
	declare	 @TotalCount integer = 0
	declare  @error int
	declare  @errorMsg varchar(max)
	declare	 @SortColumnType  varchar(255)
	declare  @endIndex int
	declare  @CaseIdRequested table (CaseId INT)
	IF ISNULL(@CaseIdList, '') <> ''
	BEGIN
		INSERT INTO @CaseIdRequested
		SELECT _ID FROM dbo.SplitIDString(@CaseIdList)
		WHERE ISNUMERIC(_ID) = 1
	END
	IF ISNULL(@PageSize, 0) = 0
		SET @PageSize = 25
	SET @endIndex = @StartIndex + @PageSize - 1
	IF ISNULL(@StartIndex, 0) < 0
		SET @StartIndex = 0
	IF @SortColumn IS NULL
		SET @SortColumn = 'CaseCreateTime'
	if @SortColumn NOT IN ('CaseName', 'StoragePolicyName', 'CaseCreatedByName', 'CaseStatus', 'CaseCreateTime', 'ModifiedTime')
	BEGIN
		 SET @SortColumn = 'CaseCreateTime'
	END
	IF @SortColumn  IN ('CaseCreateTime', 'ModifiedTime')
	BEGIN
		SET @SortColumnType = 'TimeValue'
	END
	ELSE IF @SortColumn IN ('CaseStatus')
	BEGIN
		SET @SortColumnType = 'IntegerValue'
	END
	ELSE
	BEGIN
		 SET @SortColumnType = 'StringValue'
	END
	IF ISNULL(@SortOrder, '') IN ( 'ASCENDING' , 'ASC' )
		SET @SortOrder = 'asc'
	ELSE
		SET @SortOrder = 'desc'
	IF object_id('tempdb.dbo.#GroupsForUser') IS NOT NULL
	BEGIN
		drop table #GroupsForUser
	END
	CREATE TABLE #GroupsForUser (
	id integer,
	groupFlags integer,
	allCapabilities integer,
	allAssociations integer,
	selfAssociation integer,
name nvarchar(255),
description nvarchar(3072)
	)
	DECLARE @ADGroupTable TABLE (
ADGroupName nvarchar(255) NOT NULL,
		GroupGuid   varchar(128) NOT NULL,
		GroupId int
	)
	DECLARE @ADGroupListXML XML
	IF LEN(ISNULL(@ADGroupList ,'')) > 0
		SET @ADGroupListXML = CAST(@ADGroupList AS XML)
	;WITH CTEGroupInfo
	AS
	(
		SELECT T.ref.value('@groupName', 'nvarchar(255)') as GroupName,
		T.ref.value('@groupGuid', 'varchar(128)') as GroupGuid
		FROM @ADGroupListXML.nodes('/GroupsMap/EachGroup') T(ref)
	)
	INSERT INTO @ADGroupTable (ADGroupName, GroupGuid)
	SELECT GroupName, GroupGuid	FROM CTEGroupInfo
	DECLARE @UMDSProviderId INT
	DECLARE @UserGuid NVARCHAR(255)
	SELECT @UMDSProviderId = UMDSProviderId, @UserGuid = userGuid FROM UMUSERS WHERE Id = @ForUser
	IF EXISTS (select top 1 ADGroupName from @ADGroupTable)
	BEGIN
		UPDATE T
		SET T.GroupId = EG.id
		FROM @ADGroupTable T
		JOIN UMDSgroups EG ON T.ADGroupName = EG.name AND EG.umdsProviderId = @UMDSProviderId
	END
	UPDATE @ADGroupTable
	SET GroupId = 0
	WHERE GroupId IS NULL
	IF @ForUser > 0
	BEGIN
		exec getGroupsForUser @ForUser;
		set @error = @@ERROR
		if @error > 0
		BEGIN
			SET @errorMsg = 'Error determining user groups'
			goto errLine
		END
	END;
	IF OBJECT_ID('tempdbo.dbo.#CaseList') IS NOT NULL
		DROP TABLE #CaseList
	CREATE TABLE #CaseList(CaseId INT, IsOwner BIT, Capabilities BIGINT)
	--if user is master, then we assume that we are fetching all cases and not just for a given user, so that we return all data.
	IF EXISTS (SELECT TOP 1 * FROM #GroupsForUser WHERE ID = dbo.GetMasterGroupID())
	BEGIN
		SET @ForUser = 0
	END;
	IF @ForUser = 0
	BEGIN
		INSERT INTO #CaseList
		SELECT CaseId, 0 as IsOwner, 0 as Capabilities FROM DM2CaseInfo
	END
	ELSE
	BEGIN
		INSERT INTO #CaseList
		SELECT CaseId, 1 as IsOwner, 0 as Capabilities FROM DM2CaseInfo C
		WHERE C.CreatedBy = @ForUser
		SET @error = @@ERROR
		IF @error > 0
		BEGIN
			SET @errorMsg = 'Error determining owned case list'
			GOTO errLine
		END
		--Find case list where requested user is present on partaker users
		;WITH CTePartakerUsers
		AS
		(
			SELECT CaseId,
			ISNULL(Z.ref.value('@userId', 'int'), 0) PartakerUserId,
			0 as IsGroup,
			ISNULL(Z.ref.value('@capabilities', 'bigint'), 0) capabilities,
			ISNULL(Z.ref.value('@userGUID', 'nvarchar(255)'), '') PartakerUserGuid
			FROM DM2CaseInfo CU
			CROSS APPLY CU.CaseXML.nodes('/DM2ContentIndexing_CaseInfo/casePartakers/user') Z(ref)
			WHERE CU.CaseId NOT IN (SELECT CaseId FROM #CaseList) --Ignoring rows where caseid was already shortlisted
		)
		INSERT INTO #CaseList
		SELECT CaseId, 0 as IsOwner, capabilities FROM CTePartakerUsers
		WHERE PartakerUserId = @ForUser OR PartakerUserGuid = @UserGuid
		SET @error = @@ERROR
		IF @error > 0
		BEGIN
			SET @errorMsg = 'Error determining case list where user is a direct partaker'
			GOTO errLine
		END
		--Find case list where requested user is part of any comm-cell user group assigned as partaker
		;WITH CTEPartakerUserGroups
		AS
		(
			SELECT CaseId,
			ISNULL(T.ref.value('@userGroupId', 'int'), 0) PartakerUserGroupId,
			ISNULL(T.ref.value('@capabilities', 'bigint'), 0) capabilities
			FROM DM2CaseInfo C
			CROSS APPLY C.CaseXML.nodes('/DM2ContentIndexing_CaseInfo/casePartakers/group[@_type_="15"]') T(ref)
			WHERE C.CaseId NOT IN (SELECT CaseId FROM #CaseList) --Again we are ignoring rows where caseid was already shortlisted
		)
		INSERT INTO #CaseList
		SELECT CaseId, 0 as IsOwner, capabilities FROM CTEPartakerUserGroups
		WHERE PartakerUserGroupId in (SELECT id FROM #GroupsForUser)
		SET @error = @@ERROR
		IF @error > 0
		BEGIN
			SET @errorMsg = 'Error determining case list where user is part of partaker comm-cell group(s).'
			GOTO errLine
		END
		--Find case list where requested user is part of any AD group assigned as partaker
		;WITH CTEPartakerADGroups
		AS
		(
			SELECT CaseId,
			ISNULL(T.ref.value('@userGroupId', 'int'), 0) PartakerADGroupId,
			ISNULL(T.ref.value('@capabilities', 'bigint'), 0) capabilities,
			ISNULL(T.ref.value('@GUID', 'varchar(128)'), '') PartakerGroupGuid
			FROM DM2CaseInfo C
			CROSS APPLY C.CaseXML.nodes('/DM2ContentIndexing_CaseInfo/casePartakers/group[@_type_="62"]') T(ref)
			WHERE C.CaseId NOT IN (SELECT CaseId FROM #CaseList) --Again we are ignoring rows where caseid was already shortlisted
		)
		INSERT INTO #CaseList
		SELECT CaseId, 0 as IsOwner, capabilities FROM CTEPartakerADGroups X
		WHERE EXISTS (SELECT T.ADGroupName FROM @ADGroupTable T WHERE X.PartakerADGroupId = T.GroupId OR X.PartakerGroupGuid = T.GroupGuid)
	END
	-- delete duplicate case by CaseId
	;WITH CTECases
	AS
	(
        SELECT ROW_NUMBER() OVER (PARTITION BY CaseId ORDER BY IsOwner DESC) PT
        FROM #CaseList
    )
    DELETE FROM CTECases
    WHERE PT > 1
	DECLARE @caseListSql nvarchar(max)
	IF OBJECT_ID ('tempdb.dbo.#SortedCaseList') is not null
		DROP TABLE #SortedCaseList
	CREATE TABLE #SortedCaseList (
		RowId integer not null identity(0,1),
		StringValue nvarchar(1024) null,
		TimeValue datetime null,
		IntegerValue integer null,
		CaseId integer not null
	)
	-- If caller is interested in all or specified list of cases then they supply @CaseId = 0 and @CaseIdRequested table derived from @CaseIdList will not have any rows
	-- in such case only we will kick in paging logic..
	IF ISNULL(@CaseId, 0) <= 0 AND NOT EXISTS (SELECT TOP 1 * FROM @CaseIdRequested)
	BEGIN
		DECLARE @newLineChar CHAR(1) = CHAR(13)
		DECLARE @ParmDefinition nvarchar(max)
		SET @caseListSql =  ';WITH SortableCTE ' + @newLineChar
		SET @caseListSql += ' AS (' + @newLineChar
		SET @caseListSql += ' SELECT C.CaseId, C.CaseName, C.CreateTime CaseCreateTime, ag.name StoragePolicyName, u.login as CaseCreatedByName,' + @newLineChar
		SET @caseListSql += ' C.Status as CaseStatus, C.ModifiedTime '
		SET @caseListSql += ' FROM DM2CaseInfo C ' + @newLineChar
		SET @caseListSql += ' JOIN #CaseList O ON C.CaseId = O.CaseId ' + @newLineChar
		SET @caseListSql += ' LEFT JOIN ArchGroup AG on c.ArchGroupId = ag.id ' + @newLineChar
		SET @caseListSql += ' JOIN UMUsers U ON c.CreatedBy = u.id ' + @newLineChar
		SET @caseListSql += ' )' + @newLineChar
		SET @caseListSql += ' INSERT INTO #SortedCaseList ( CaseId, ' + @SortColumnType + ' ) ' + @newLineChar
		SET @caseListSql += ' SELECT CaseId, ' + @SortColumn + ' FROM SortableCTE ' + @newLineChar
		SET @caseListSql += ' ORDER BY ' + @SortColumn + ' ' + @SortOrder
		IF @Debug = 1
			PRINT @caseListSql
		exec sp_executesql @caseListSql
		--Need to return total count for paging to work
		SELECT @TotalCount = COUNT(*) FROM #SortedCaseList
		--debug output
		IF @Debug = 1
			SELECT *, 'BeforeDelete' BeforePagedResultShortList FROM #SortedCaseList
		--delete records outside of the requested page
		IF @PageSize > 0
		BEGIN
			DELETE FROM #SortedCaseList
			WHERE RowId < @StartIndex OR RowId > @endIndex
		END
	END
	ELSE IF EXISTS (SELECT TOP 1 * FROM @CaseIdRequested)
	BEGIN
		--allowed cases intersection with specified input list of cases..
		INSERT INTO #SortedCaseList(CaseId)
		SELECT b.CaseId from @CaseIdRequested a join #CaseList b on a.CaseId = b.CaseId
	END
	ELSE
	BEGIN
		IF @ForUser = 0 OR EXISTS (SELECT CaseId FROM #CaseList WHERE CaseId = @CaseId)
		BEGIN
			SET @TotalCount = 1
			INSERT INTO #SortedCaseList(CaseId)
			SELECT @CaseId
		END
	END
	IF @Debug = 1
		SELECT *, 'PagedSortedList' PagedSortedList FROM #SortedCaseList
	;WITH CaseList (CaseId, CaseName, createTime, storagePolicyName, storagePolicyId, caseCreatedById, CaseNotes, CaseNumber, RetainUntil, RefCopyClientId, CaseStatus, ModifiedTime, RowId, IsDataCopyEnabled, CaseXMLDump)
	AS
	(
		SELECT C.CaseId, C.CaseName, dbo.GetUnixTime(C.CreateTime) createTime,
		ag.name StoragePolicyName, ag.id as StoragePolicyId,
		C.CreatedBy as CaseCreatedById, C.CaseNotes, C.CaseNumber,
		dbo.GetUnixTime(C.RetentionDateTime) as RetainUntil, C.RefCopyClientId,
		C.status as CaseStatus, dbo.GetUnixTime(C.ModifiedTime) ModifiedTime, S.RowId RowId,
		C.CaseXML.value('(/DM2ContentIndexing_CaseInfo)[1]/@enableDataCopy', 'int') IsDataCopyEnabled,
		C.CaseXML CaseXMLDump
		FROM DM2CaseInfo C
		LEFT JOIN ArchGroup AG on c.ArchGroupId = ag.id
		JOIN UMUsers U ON c.CreatedBy = u.id
		JOIN #SortedCaseList S ON C.CaseId = S.CaseId
	)
	SELECT @TotalCount '@totalResults', @StartIndex '@resultOffset',
	(
		SELECT CM.IsDataCopyEnabled '@enableDataCopy', (CASE WHEN @FetchFullInfo = 1 then CONVERT(NVARCHAR(MAX), CM.CaseXMLDump) else '' end) '@auditComment',
		(
			SELECT CaseId '@caseId', CaseName '@caseName', CI.CreateTime '@createTime', CI.ModifiedTime '@modifiedTime',
			CaseNotes '@caseNotes', CaseNumber '@caseNumber', RetainUntil '@retainUtil', CI.CaseStatus '@status',
			(
				SELECT name '@storagePolicyName', id '@storagePolicyId'
				FROM ArchGroup AG WHERE AG.Id = CI.storagePolicyId
				FOR XML PATH('storagePolicy'), TYPE
			),
			(
				SELECT UserGuid '@userGUID', id '@userId', login '@userName'
				FROM UMUsers U
				WHERE U.ID = CI.caseCreatedById
				FOR XML PATH('caseCreatedBy'), TYPE
			),
			(
				SELECT ID '@clientId', AC.name '@clientName' FROM APP_Client AC
				WHERE AC.id = CI.RefCopyClientId
				FOR XML PATH('refCopyClient'), TYPE
			),
			(
				SELECT F.name '@copyName', E.retentionDays '@retentionDays', E.fullCycles '@cycles', e.copyId '@copyId'
				FROM archGroup D WITH(NOLOCK)
				LEFT JOIN archAgingRule E WITH(NOLOCK) ON D.defaultCopy = E.copyId
				LEFT JOIN archGroupCopy F WITH(NOLOCK) ON F.id = e.copyId
				WHERE CI.storagePolicyId = D.id
				FOR XML PATH('defaultCopyRetention'), TYPE
			)
			FROM CaseList CI WHERE CI.CaseId = CM.CaseId
			FOR XML PATH('basicCaseInfo'), TYPE
		)
		FROM CaseList as CM
		ORDER BY CM.RowId
		FOR XML PATH('caseList'), TYPE
	)
	FOR XML PATH('DM2ContentIndexing_CaseOperation')
	errLine:
	IF object_id('tempdb.dbo.#GroupsForUser') IS NOT NULL
	BEGIN
		drop table #GroupsForUser
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'DM2GetCaseList')
	delete from GxQscripts where name = 'DM2GetCaseList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetCaseList')
	delete from GXDBVersions where aliasname = 'DM2GetCaseList'
GO

insert into GXDBVersions values(2, 'DM2GetCaseList',  '00010009001200060000', 'DM2GetCaseList', '00010009001200060000')
GO

