

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2GetCaseHoldStatusDetails.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  DM2GetCaseHoldStatusDetails()
--  | Description:  With respect to each hold in a given case, fetch number of items backed-up, caught up time of reference copy and recent sucessful content index time.
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DM2GetCaseHoldStatusDetails.sp,v $ $Id: DM2GetCaseHoldStatusDetails.sp,v 1.2.48.1 2018/03/27 08:53:06 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DM2GetCaseHoldStatusDetails <<<'

IF EXISTS (select * from sysobjects where name='DM2GetCaseHoldStatusDetails')
	drop procedure DM2GetCaseHoldStatusDetails
IF EXISTS (select * from GxQscripts where name='DM2GetCaseHoldStatusDetails')
	delete from GxQscripts where name = 'DM2GetCaseHoldStatusDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetCaseHoldStatusDetails')
	delete from GXDBVersions where aliasname = 'DM2GetCaseHoldStatusDetails'
GO
print '... Creating Procedure: DM2GetCaseHoldStatusDetails'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DM2GetCaseHoldStatusDetails
  @i_CaseId int
AS
BEGIN
;WITH CHold
AS
(
SELECT CaseId, RefCopyClientId,
T.ref.value('@holdType', 'int') holdType
FROM DM2CaseInfo C
CROSS APPLY C.CaseXML.nodes('/DM2ContentIndexing_CaseInfo/caseCriteria') T(ref)
)
SELECT C.holdType '@holdType',
dbo.getItemCountInLatestCycleOfHold(RefCopyClientId, C.holdType) '@totalNumberOfItems',
dbo.getLowestRefTimeOfHold(RefCopyClientId, C.holdType) '@caughtupUntil',
dbo.getRecentSuccessCITimeOfHold(RefCopyClientId, C.holdType) '@contentIndexingUntil'
FROM CHold C
WHERE C.holdType <> 7 AND C.CaseId = @i_CaseId
FOR XML PATH('holdStatusDetails'), TYPE, ROOT('DM2ContentIndexing_CaseInfo')
END
GO

IF EXISTS (select * from GxQscripts where name = 'DM2GetCaseHoldStatusDetails')
	delete from GxQscripts where name = 'DM2GetCaseHoldStatusDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetCaseHoldStatusDetails')
	delete from GXDBVersions where aliasname = 'DM2GetCaseHoldStatusDetails'
GO

insert into GXDBVersions values(2, 'DM2GetCaseHoldStatusDetails',  '00010002004800010000', 'DM2GetCaseHoldStatusDetails', '00010002004800010000')
GO

