

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2GetCaseDetailsToSubmitJob.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  DM2GetCaseDetailsToSubmitJob()
--  | Description:  Return backup set, application type, and client information of given case for requested data types.
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DM2GetCaseDetailsToSubmitJob.sp,v $ $Id: DM2GetCaseDetailsToSubmitJob.sp,v 1.4.46.1 2018/03/27 09:07:13 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DM2GetCaseDetailsToSubmitJob <<<'

IF EXISTS (select * from sysobjects where name='DM2GetCaseDetailsToSubmitJob')
	drop procedure DM2GetCaseDetailsToSubmitJob
IF EXISTS (select * from GxQscripts where name='DM2GetCaseDetailsToSubmitJob')
	delete from GxQscripts where name = 'DM2GetCaseDetailsToSubmitJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetCaseDetailsToSubmitJob')
	delete from GXDBVersions where aliasname = 'DM2GetCaseDetailsToSubmitJob'
GO
print '... Creating Procedure: DM2GetCaseDetailsToSubmitJob'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DM2GetCaseDetailsToSubmitJob
  @caseId INT, 
  @appTypes VARCHAR(MAX), 
  @JournalInstanceId INT OUTPUT
AS
BEGIN
	DECLARE @RefCopyClientId INT
	DECLARE @clientName NVARCHAR(255)
	DECLARE @caseName NVARCHAR(255)
	--initialize..
	SELECT @RefCopyClientId = C.RefCopyClientId, @clientName = A.Name, @caseName = C.CaseName
	FROM DM2CaseInfo C WITH(NOLOCK)
	INNER JOIN APP_CLIENT A WITH(NOLOCK) ON C.RefCopyClientId = A.id
	WHERE C.caseid = @caseId
	--return necessary data..
	SELECT 4 as _type_, IT.name as appName, it.type as applicationId, @clientName as clientName, @RefCopyClientId as clientId,
	(
	SELECT TOP 1 b.ID FROM APP_BackupSetName b WITH (NOLOCK)
	JOIN APP_Application AA WITH (NOLOCK) ON AA.clientId = @RefCopyClientId and aa.appTypeId = T._ID and b.id = aa.backupSet
	WHERE b.name = N'defaultBackupSet'
	) as backupSetId,
	(
		SELECT TOP 1 JobId FROM JMBkpJobInfo WITH (NOLOCK)
		WHERE applicationId IN (SELECT id FROM APP_Application JA WITH (NOLOCK) WHERE JA.appTypeId = IT.type and JA.clientId = @RefCopyClientId)
	) as jobId,
	@caseName as CaseName
	FROM APP_iDAType IT WITH (NOLOCK)
	JOIN dbo.SplitIDs(@appTypes) T ON T._ID = IT.type
	--return target reference copy client journal instance id as different data table
	SELECT TOP 1 @JournalInstanceId = instance FROM APP_Application WITH (NOLOCK) WHERE CLIENTID = @RefCopyClientId and appTypeId = 67
END
GO

IF EXISTS (select * from GxQscripts where name = 'DM2GetCaseDetailsToSubmitJob')
	delete from GxQscripts where name = 'DM2GetCaseDetailsToSubmitJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetCaseDetailsToSubmitJob')
	delete from GXDBVersions where aliasname = 'DM2GetCaseDetailsToSubmitJob'
GO

insert into GXDBVersions values(2, 'DM2GetCaseDetailsToSubmitJob',  '00010004004600010000', 'DM2GetCaseDetailsToSubmitJob', '00010004004600010000')
GO

