

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2GetCVBrowseClients.sp] ---------- 

--  +========================================================================+
--  | Name:  DM2GetCVBrowseClients()
--  | Description: Gives the client Id and subclient details having EXMB OR WindFs IDAs installed and has the permissions of
--  | Browse,Browse Out of place for a given User.
--	| Usage Details:
--	| 	Parameters:
--	|		i_FromTime, i_ToTime -
--	|			0, 0 - Latest data in result set
--	|			0, timestamp - Data till specified timestamp from since big bang
--	|			timestamp, 0 - Data since specified timestamp uptill now
--	|			timestamp1, timestamp2 - Data between two timestamps
--	|
--	|		i_clientId = 0 (Results will not be filtered), != 0 (Will filter results using this clientId)
--	|		i_Mode - 0 (Compliance user login), 1 (End User Login)
--	|		i_Service Type -  1 (galaxy user login), 2 (Exhcance MailBox login), 3 (Lotus notes login)
--	|		i_mailBoxOrNFS -  If it has length more than 0, mailBoxes in result set will be filtered using GUID in this parameter
--	|						Other resultset will not be filtered
-- 	|					For i_Mode = 1 (EndUser) this parameter can not be empty, if it is empty no rows for exchange mailbox will be returned
--  +========================================================================+
-- dataServer_h_rcsid[]="$ $Id: DM2GetCVBrowseClients.sp,v 1.29.34.2 2018/03/27 09:04:05 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DM2GetCVBrowseClients <<<'

IF EXISTS (select * from sysobjects where name='DM2GetCVBrowseClients')
	drop procedure DM2GetCVBrowseClients
IF EXISTS (select * from GxQscripts where name='DM2GetCVBrowseClients')
	delete from GxQscripts where name = 'DM2GetCVBrowseClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetCVBrowseClients')
	delete from GXDBVersions where aliasname = 'DM2GetCVBrowseClients'
GO
print '... Creating Procedure: DM2GetCVBrowseClients'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DM2GetCVBrowseClients
  @i_UserGuid VARCHAR(36),
  @i_FromTime int,
  @i_ToTime int,
  @i_ClientId int = 0,
  @i_Mode int = 0,
  @i_ServiceType int = 0,
  @i_mailBoxOrNFS NVARCHAR(MAX) = ''
AS
  DECLARE @o_errorCode int
  DECLARE @o_errorText NVARCHAR(100)
DECLARE @UserId				int
DECLARE @CapMask1 			bigint
DECLARE @CapMask2 			bigint
DECLARE @isPrimary 			int
DECLARE @isSecondary		int
DECLARE @curTime			int
DECLARE @seper				nchar(1)
set  @seper = char(18)
SET @curTime = dbo.GetUnixTime(GETUTCDATE())
SET @o_errorCode = 0
SET @o_errorText = 'Success'
SET @UserId = ISNULL((SELECT  id as UserId FROM UMUsers WHERE userGuid=@i_UserGuid), 0)
IF @UserId = 0
BEGIN
	SET @o_errorCode = 1
	SET @o_errorText = 'Invalid userGuid passed.'
	GOTO EXIT_ERROR
END
DECLARE @enableBackupSetOwnership int = 0
SELECT @enableBackupSetOwnership=value FROM GXGlobalParam WHERE name='enableBackupSetOwnership' AND modified=0
SET @CapMask1=POWER(2.0,13-1)
SET @CapMask2=POWER(2.0,22-1)
DECLARE @CapMask3 bigint = POWER(2.0,24-1)
DECLARE @CapMask4 bigint = POWER(2.0,25-1)
IF( OBJECT_ID('tempdb.dbo.#tUserObjects') is not null )
	DROP TABLE #tUserObjects
IF( OBJECT_ID('tempdb.dbo.#tClient') is not null )
	DROP TABLE #tClient
IF( OBJECT_ID('tempdb.dbo.#tOutputTable') is not null )
	DROP TABLE #tOutputTable
CREATE TABLE #tClient(	id integer,
			clientId		integer,
			appTypeId		integer,
			instance		integer,
			backupset		integer)
CREATE TABLE #tOutputTable(	clientId		integer,
			clientName		nvarchar(MAX),
			clientHostName	nvarchar(MAX),
			appTypeId		integer,
			instanceId		integer,
			backupsetId		integer,
			subClientId		integer,
			contents		nvarchar(MAX),
			created			integer,
			modified		integer,
			MB_NFS_Guid		varchar(MAX)
		)
EXECUTE sec_updateUserCredentials @UserId
CREATE TABLE #tUserObjects(	commCellId	integer,
	clientId	integer,
	appTypeId	integer,
	instanceId	integer,
	backupsetId	integer,
	subClientId	integer )
IF object_id('tempdb.dbo.#DM2GetCVBrowseClients_UserObjects') is not null DROP TABLE #DM2GetCVBrowseClients_UserObjects
create table  #DM2GetCVBrowseClients_UserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
EXEC sec_getUserObjects @userId, 2013, 0, '#DM2GetCVBrowseClients_UserObjects'
INSERT INTO #tUserObjects
SELECT DISTINCT commCellId, clientId, appTypeId, instanceId, backupsetId, subClientId
FROM	#DM2GetCVBrowseClients_UserObjects
WHERE 	((capabilities&@CapMask1)>1 OR (capabilities&@CapMask2)>1 OR (capabilities&@CapMask3)>1 OR (capabilities&@CapMask4)>1)
IF (@i_Mode = 1 AND @i_ServiceType = 3)
BEGIN
	SET @i_mailBoxOrNFS = '%' + @i_mailBoxOrNFS + '%'
	INSERT INTO #tOutputTable
	SELECT	DISTINCT clientId = A.clientId,
				clientName  = '',
				clientHostName  = '',
				appTypeId	= A.appTypeId,
				instanceId = A.instance,
				backupSetId = A.backupSet,
				subclientId	= A.id,
				contents = REPLACE(REPLACE(SF.fileName, CHAR(0x15), 'CV0X15'), CHAR(0x12), 'CV0X12'),
				created = SF.created,
				modified = SF.modified,
				null
	 FROM App_Application A INNER JOIN App_ScFilterFile SF ON
			SF.componentNameId = A.id
WHERE A.appTypeId = 90 AND
				(@i_ClientId = 0 OR @i_ClientId = A.clientId) AND
				( SF.fileName like REPLACE(@i_mailBoxOrNFS, CHAR(0x5C),CHAR(0x2F)) OR SF.fileName like REPLACE(@i_mailBoxOrNFS, CHAR(0x2F),CHAR(0x5C)) )
	INSERT INTO #tClient
	SELECT id, clientId, appTypeId, instance, backupSet FROM App_Application
	WHERE appTypeId IN (
11,
33,
34,
42,
43,
107,
12,
17,
18,
19,
20,
21,
29,
36,
38,
63,
86,
58,
66,
83,
106
		)
END
ELSE IF (@i_Mode = 1 AND @i_ServiceType = 2)
BEGIN
	INSERT INTO #tOutputTable
	SELECT	DISTINCT clientId	= A.clientId,
				clientName  = '',
				clientHostName  = '',
				appTypeId	= A.appTypeId,
				instanceId = A.instance,
				backupSetId = A.backupSet,
				subclientId	= A.id,
				contents = REPLACE(REPLACE(SP.attrName, CHAR(0x15), 'CV0X15'), CHAR(0x12), 'CV0X12'),
				created = SP.created,
				modified = SP.modified,
				CP.stringVal
	 FROM App_Application A INNER JOIN App_SubClientProp SP ON
			SP.componentNameId = A.id INNER JOIN App_ComponentProp CP ON
CP.componentId = SP.id AND componentType = 7 AND propertyTypeId = 1103
WHERE A.appTypeId in (54, 56) AND
				(@i_ClientId = 0 OR @i_ClientId = A.clientId) AND CP.stringVal = @i_mailBoxOrNFS
	INSERT INTO #tClient
	SELECT id, clientId, appTypeId, instance, backupSet FROM App_Application
	WHERE appTypeId IN (
11,
33,
34,
42,
43,
107,
12,
17,
18,
19,
20,
21,
29,
36,
38,
63,
86,
58,
66,
83,
106
		)
END
ELSE IF (@i_Mode = 0 AND (@i_ServiceType = 2 OR @i_ServiceType = 1))
BEGIN
	INSERT INTO #tClient
	SELECT id, clientId, appTypeId, instance, backupSet FROM App_Application
	WHERE appTypeId IN (
54,
56
		)
	INSERT INTO #tOutputTable
	SELECT	DISTINCT clientId	= A.clientId,
				clientName  = '',
				clientHostName  = '',
				appTypeId	= A.appTypeId,
				instanceId = A.instance,
				backupSetId = A.backupSet,
				subclientId	= (CASE WHEN T.instanceId = 0 OR T.backupsetId = 0 OR T.subClientId = 0 THEN A.id ELSE T.subClientId END),
				contents = REPLACE(REPLACE(SP.attrName, CHAR(0x15), 'CV0X15'), CHAR(0x12), 'CV0X12'),
				created = SP.created,
				modified = SP.modified,
				CP.stringVal
	 FROM	#tUserObjects T INNER JOIN #tClient A
				ON (T.clientId = 0 OR T.clientId = A.clientId) AND
				(T.appTypeId = 0 OR T.appTypeId = A.appTypeId) AND
				(T.instanceId = 0 OR T.instanceId = A.instance) AND
				(T.backupsetId = 0 OR T.backupsetId = A.backupset) AND
				(T.subClientId = 0 OR T.subClientId = A.id)	AND
				(@i_ClientId = 0 OR @i_ClientId = A.clientId)
			INNER JOIN App_SubClientProp SP ON
				SP.componentNameId = A.id INNER JOIN App_ComponentProp CP ON
CP.componentId = SP.id AND componentType = 7 AND propertyTypeId = 1103
				AND (CP.stringVal = @i_mailBoxOrNFS OR @i_mailBoxOrNFS = '')
	DELETE #tClient
	INSERT INTO #tClient
	SELECT id, clientId, appTypeId, instance, backupSet FROM App_Application
	WHERE appTypeId IN (
11,
33,
34,
42,
43,
107,
90,
12,
17,
18,
19,
20,
21,
29,
36,
38,
63,
86,
58,
66,
83,
106
		)
END
ELSE IF @i_ServiceType <> 4
BEGIN
	SET @o_errorCode = 2
	SET @o_errorText = 'Invalid Mode and Service Type combination passed.'
	GOTO EXIT_ERROR
END
IF @i_ServiceType = 4
BEGIN
	DECLARE @restoreObj	TABLE(	clientId	integer,
				clientName 	char(255),
				appTypeId	integer,
				instance integer,
				instanceName varchar(max) )
	DECLARE @fsAppTypeId INT = ISNULL((SELECT TOP 1 appTypeId
								FROM APP_Application
								WHERE clientId = @i_ClientId AND appTypeId IN (SELECT appTypeId FROM dbo.GetAppTypesForAppGroup(35,0))),0)
	IF (@fsAppTypeId <> 0)
	BEGIN
		INSERT INTO @restoreObj
		EXEC getCompatAppClient @UserId, @fsAppTypeId, @i_clientId, '', 0, 1
			-- FROM @restoreObj
		SELECT DISTINCT O.id as clientId, O.name as clientName, O.net_hostname as clientHostName, @fsAppTypeId as appTypeId, 1 as instanceId, 1 as backupSetId, 1 as subclientId, 'C:\ubuntu' as contents
		FROM APP_Client O INNER JOIN @restoreObj R ON O.id = R.clientId
	END
END
ELSE
BEGIN
INSERT INTO #tOutputTable
SELECT	DISTINCT clientId	= A.clientId,
			clientName  = '',
			clientHostName  = '',
			appTypeId	= A.appTypeId,
			instanceId = A.instance,
			backupSetId = A.backupSet,
			subclientId	= (CASE WHEN T.instanceId = 0 OR T.backupsetId = 0 OR T.subClientId = 0 THEN A.id ELSE T.subClientId END),
			contents = REPLACE(REPLACE(SF.fileName, CHAR(0x15), 'CV0X15'), CHAR(0x12), 'CV0X12'),
			created = ISNULL(SF.created, 0),
			modified = ISNULL(SF.modified, 0),
			null
FROM #tUserObjects T INNER JOIN #tClient A
			ON (T.clientId = 0 OR T.clientId = A.clientId) AND
			(T.appTypeId = 0 OR T.appTypeId = A.appTypeId) AND
			(T.instanceId = 0 OR T.instanceId = A.instance) AND
			(T.backupsetId = 0 OR T.backupsetId = A.backupset) AND
			(T.subClientId = 0 OR T.subClientId = A.id)	AND
			(@i_ClientId = 0 OR @i_ClientId = A.clientId)
		LEFT OUTER JOIN App_ScFilterFile SF ON
			A.id = SF.componentNameId
		WHERE A.id NOT in (
			SELECT componentNameId FROM App_SubClientProp
				WHERE modified = 0 AND attrName = 'Associated subclient Policy'
		)
INSERT INTO #tOutputTable
SELECT	DISTINCT clientId	= A.clientId,
			clientName  = '',
			clientHostName  = '',
			appTypeId	= A.appTypeId,
			instanceId = A.instance,
			backupSetId = A.backupSet,
			subclientId	= (CASE WHEN T.instanceId = 0 OR T.backupsetId = 0 OR T.subClientId = 0 THEN A.id ELSE T.subClientId END),
			contents = REPLACE(REPLACE(SF.fileName, CHAR(0x15), 'CV0X15'), CHAR(0x12), 'CV0X12'),
			created = ISNULL(SF.created, 0),
			modified = ISNULL(SF.modified, 0),
			null
FROM #tUserObjects T INNER JOIN #tClient A
			ON (T.clientId = 0 OR T.clientId = A.clientId) AND
			(T.appTypeId = 0 OR T.appTypeId = A.appTypeId) AND
			(T.instanceId = 0 OR T.instanceId = A.instance) AND
			(T.backupsetId = 0 OR T.backupsetId = A.backupset) AND
			(T.subClientId = 0 OR T.subClientId = A.id)	AND
			(@i_ClientId = 0 OR @i_ClientId = A.clientId)
		INNER JOIN App_SubClientProp SP ON
			A.id = SP.componentNameId AND SP.modified = 0 AND attrName = 'Associated subclient Policy'
		LEFT OUTER JOIN App_ScFilterFile SF ON
			CAST(SP.attrVal AS integer) = SF.componentNameId
UPDATE #tOutputTable
SET clientName = C.name, clientHostName = C.net_hostname
FROM App_Client C INNER JOIN #tOutputTable T ON
	T.clientId = C.id
IF @i_ToTime = 0 AND @i_FromTime = 0
BEGIN
	IF @enableBackupSetOwnership = 0
		SELECT DISTINCT O.clientId, O.clientName, O.clientHostName, O.appTypeId, O.instanceId, O.backupSetId, O.subclientId, O.contents, O.MB_NFS_Guid
		FROM #tOutputTable O INNER JOIN App_BackupSetName B ON B.id = O.backupSetId
WHERE O.modified = 0 AND (B.status & 0x00008) > 0
		ORDER BY O.clientName
	ELSE
		SELECT DISTINCT O.clientId, O.clientName, O.clientHostName, O.appTypeId, O.instanceId, O.backupSetId, O.subclientId, O.contents, O.MB_NFS_Guid
		FROM #tOutputTable O INNER JOIN App_BackupSetName B ON B.id = O.backupSetId
		WHERE O.modified = 0
		ORDER BY O.clientName
END
ELSE
BEGIN
	UPDATE #tOutputTable
	SET modified = @curTime
	FROM #tOutputTable WHERE modified = 0
	IF @i_ToTime = 0
		SET @i_ToTime = @curTime
	IF @enableBackupSetOwnership = 0
		SELECT DISTINCT O.clientId, O.clientName, O.clientHostName, O.appTypeId, O.instanceId, O.backupSetId, O.subclientId, O.contents, O.MB_NFS_Guid
		FROM #tOutputTable O INNER JOIN App_BackupSetName B ON B.id = O.backupSetId
WHERE O.modified >= @i_FromTime AND O.created <= @i_ToTime AND (B.status & 0x00008) > 0
		ORDER BY O.clientName
	ELSE
		SELECT DISTINCT O.clientId, O.clientName, O.clientHostName, O.appTypeId, O.instanceId, O.backupSetId, O.subclientId, O.contents, O.MB_NFS_Guid
		FROM #tOutputTable O INNER JOIN App_BackupSetName B ON B.id = O.backupSetId
		WHERE O.modified >= @i_FromTime AND O.created <= @i_ToTime
		ORDER BY O.clientName
END
END
EXIT_ERROR:
IF( OBJECT_ID('tempdb.dbo.#tOutputTable') is not null )
	DROP TABLE #tOutputTable
IF( OBJECT_ID('tempdb.dbo.#tClient') is not null )
	DROP TABLE #tClient
IF( OBJECT_ID('tempdb.dbo.#tUserObjects') is not null )
	DROP TABLE #tUserObjects
RETURN @o_errorCode
GO

IF EXISTS (select * from GxQscripts where name = 'DM2GetCVBrowseClients')
	delete from GxQscripts where name = 'DM2GetCVBrowseClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetCVBrowseClients')
	delete from GXDBVersions where aliasname = 'DM2GetCVBrowseClients'
GO

insert into GXDBVersions values(2, 'DM2GetCVBrowseClients',  '00010029003400020000', 'DM2GetCVBrowseClients', '00010029003400020000')
GO

