

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2GetCMRefCopyAssociations.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  DM2GetCMRefCopyAssociations()
--  | Description:  Get clients for given case.
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DM2GetCMRefCopyAssociations.sp,v $ $Id: DM2GetCMRefCopyAssociations.sp,v 1.8.2.6 2020/08/24 15:17:33 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='DM2GetCMRefCopyAssociations')
BEGIN
	print '>>> Drop Stored Procedure: DM2GetCMRefCopyAssociations <<<'
	drop procedure DM2GetCMRefCopyAssociations
END
IF EXISTS (select * from GxQscripts where name='DM2GetCMRefCopyAssociations')
	delete from GxQscripts where name = 'DM2GetCMRefCopyAssociations'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetCMRefCopyAssociations')
	delete from GXDBVersions where aliasname = 'DM2GetCMRefCopyAssociations'
GO
print '... Creating Procedure: DM2GetCMRefCopyAssociations'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DM2GetCMRefCopyAssociations
  @inputxml XML,
  @CaseId INT
AS
BEGIN
	SET NOCOUNT ON
	DECLARE @allAssociations	INT
	DECLARE @capability			INT
	DECLARE @capability2		INT = 0
	DECLARE @caseManagerId		INT
	DECLARE @protectDesktopsLaptops int = 0
	--
	-- This table allows us to collect all groups to which case manager has view permissions.
	-- sec_GetClientGroupsForUser SP does this job for us
	--
	IF OBJECT_ID('tempdb.dbo.#sec_CMClientGroups') IS NOT NULL
	BEGIN
		DROP TABLE #sec_CMClientGroups
	END
	CREATE TABLE #sec_CMClientGroups ( entityId INT)
	--
	-- It is assumed that PopulateCaseManagerAssociations SP (or any other SP that) calls into this one creates this table and if
	-- any caller does not create it, then we will have it created here for sake of definition inside this SP.
	-- Simply to say this is one of the output information returned from this SP.
	--
	IF object_id('tempdb.dbo.#userClientGroupsTbl') IS NULL
	BEGIN
		CREATE TABLE #userClientGroupsTbl ( entityId INT)
	END
	--DECLARE @caseMgrType		INT = 0
	IF object_id('tempdb.dbo.#clientIdTable') IS NOT NULL
		DROP TABLE #clientIdTable
	CREATE TABLE #clientIdTable ( id integer, appId integer, holdType integer)
	IF object_id('tempdb.dbo.#supportedAgentTypes') IS NOT NULL
		DROP TABLE #supportedAgentTypes
	CREATE TABLE #supportedAgentTypes(appTypeId int)
	insert into #supportedAgentTypes
	select T.ref.value('@applicationId','int') from @inputxml.nodes('/DM2ContentIndexing_CaseInfo/supportedAgents') T(ref)
	--Select @caseMgrType = ISNULL(i.Col.value('@holdType', 'int'),0) From  @inputxml.nodes('/DM2ContentIndexing_CaseInfo') as i(col)
    Select @caseManagerId = ISNULL(i.Col.value('@userId', 'int'),0) From  @inputxml.nodes('/DM2ContentIndexing_CaseInfo/basicCaseInfo/modifiedBy') as i(col)
	--
	IF ISNULL(@caseManagerId, 0) = 0
	BEGIN
		SELECT @caseManagerId = ISNULL(i.Col.value('@userId', 'int'),0) From @inputxml.nodes('/DM2ContentIndexing_CaseInfo/basicCaseInfo/caseCreatedBy') as i(col)
	END
	--
	Select @protectDesktopsLaptops = ISNULL(i.Col.value('@protectDesktopsLaptops', 'int'),0) From @inputxml.nodes('/DM2ContentIndexing_CaseInfo') as i(col)
	--
	-- Insert based on the holdType. We can also check from the filters and based on the oldType we can figure it out.
	--IF Exists(select *From #supportedAgentTypes where appTypeId = 67/*Exchange Archiver*/)
	IF @inputXml.exist('/DM2ContentIndexing_CaseInfo/caseCriteria[@holdType = ''4'']') = 1  -- 4- Files
	BEGIN
		if @protectDesktopsLaptops > 0
		begin
		exec DM2GetAllCaseClients @GetUserClientRelationPerCase = 0, @CaseId = @CaseId, @i_xmlText = @inputxml, @debug = 0
		end
		;WITH CTESelectedFSClients
		AS
		(
			SELECT isnull(i.col.value('@clientId', 'int'), 0) as ClientIdSelected, isnull(i.col.value('@_type_', 'int'), 0) as _type
			FROM @inputXml.nodes('/DM2ContentIndexing_CaseInfo/caseCriteria[@holdType=4]/clientOrClientGroupEntities') i(col)
		)
		INSERT INTO #clientIdTable(id , appId , holdType)
		SELECT distinct ClientIdSelected, 0, 4 FROM CTESelectedFSClients A, APP_CLIENT B WITH(NOLOCK)
WHERE _type = 3
		AND A.ClientIdSelected > 0
		AND A.ClientIdSelected = B.id
		AND ClientIdSelected NOT IN (SELECT id FROM #clientIdTable)
		--
		-- first capture all allowed client groups for case manager
		exec sec_GetClientGroupsForUser @i_CaseManagerId = @caseManagerId, @i_sortOrder = '', @i_offset = 0, @i_PageSize = -1, @i_searchText = '', @i_HonorSortingAndPaging = 0, @o_TotalCount = 0
		--
		-- we are now capturing allowed and selected client groups in the case for protecting by reference copy client
		--
		;WITH CTESelectedFSClients
		AS
		(
			SELECT isnull(i.col.value('@clientGroupId', 'int'), 0) as ClientGroupSelected, isnull(i.col.value('@_type_', 'int'), 0) as _type
			FROM @inputXml.nodes('/DM2ContentIndexing_CaseInfo/caseCriteria[@holdType=4]/clientOrClientGroupEntities') i(col)
		)
		INSERT INTO #userClientGroupsTbl
		SELECT distinct ClientGroupSelected FROM CTESelectedFSClients A, #sec_CMClientGroups B
WHERE _type = 28
		AND ClientGroupSelected > 0
		AND A.ClientGroupSelected = B.entityId
	END
	IF @inputXml.exist('/DM2ContentIndexing_CaseInfo/caseCriteria[@holdType = ''6'']') = 1  -- 6- Journal
	BEGIN
		-- Compliance Archiver clients excluding the ReferenceCopy/CaseManager clients.
		INSERT INTO #clientIdTable
		SELECT DISTINCT clientID, 0/*AppId*/, 6/*CaseHoldType.Journal*/ FROM APP_IDAName A, App_Client B WHERE A.clientId = B.id AND A.appTypeId = 67 AND B.status & 0x4000000 <> 0x4000000
	END
	IF @inputXml.exist('/DM2ContentIndexing_CaseInfo/caseCriteria[@holdType = ''5'']') = 1  -- 5- MailBox
	BEGIN
		-- i. Get the list of user GUIDs.
		-- ii. For each userGUID convert it to mailbox GUID and find the associated subclient.
			DECLARE @userGUID nvarchar(255)
			DECLARE @formattedGUID	nvarchar(255)
			DECLARE @formattedGUID9 nvarchar(255)
			DECLARE @mbGUIDTbl TABLE
			(
				userGUID		nvarchar(255),
				formattedGUID	nvarchar(255),
				formattedGUID9	nvarchar(255)
			)
			;WITH CTEEx
			AS
			(
			SELECT
				ISNULL(i.Col.value('@_type_', 'int'),0) EntityType,
				ISNULL(i.Col.value('@userGUID', 'varchar(256)'),'') UserGuid,
				ISNULL(i.Col.value('@userGroupId', 'int'),0) userGroupId,
				ISNULL(i.Col.value('@groupId', 'int'),0) groupId,
				ISNULL(i.Col.value('../@allAssets', 'int'),0) allAssets,
				ISNULL(o.Col.value('@clientId', 'int'),0) clientId,
				ISNULL(o.col.value('(flags)[1]/@include', 'int'),0) isSelected
			FROM @inputxml.nodes('/DM2ContentIndexing_CaseInfo/userAssets/userOrGroup') as i(Col)
			outer apply i.col.nodes('../galaxyEntity') as o(col)
			)
			Insert into @mbGUIDTbl
			select distinct UserGuid, '', '' from
			CTEEx
			DECLARE mbGUIDCur CURSOR FOR
			SELECT userGUID FROM @mbGUIDTbl
			OPEN mbGUIDCur;
			FETCH NEXT FROM mbGUIDCur INTO @userGUID
			WHILE @@FETCH_STATUS = 0
			BEGIN
				SET  @formattedGUID = '{' +  REPLACE(@userGUID,'-','X') + '}'
				SET @formattedGUID = UPPER(@formattedGUID)
				--For 9.0 clients
				set @formattedGUID9 =  Replace(substring(@userGUID,7,2)+substring(@userGUID,5,2)+substring(@userGUID,3,2)+substring(@userGUID,1,2)
				+ substring(@userGUID,12,2) + substring(@userGUID,10,2)
				+ substring(@userGUID,17,2) + substring(@userGUID,15,2)
				+ substring(@userGUID,19,18),'-','')
				UPDATE @mbGUIDTbl
				SET formattedGUID = @formattedGUID, formattedGUID9 = @formattedGUID9
				WHERE userGUID = @userGUID
				FETCH NEXT FROM mbGUIDCur INTO @userGUID
			END
			CLOSE mbGUIDCur;
			DEALLOCATE mbGUIDCur;
		-- Exchange Mailbox excluding the ReferenceCopy/CaseManager clients.
		INSERT INTO #clientIdTable
		SELECT DISTINCT B.clientId, B.id/*AppId*/, 5/*CaseHoldType.Emails*/ FROM App_Client A, App_Application B
		WHERE
		B.id in (
					SELECT DISTINCT componentNameId FROM APP_SubClientProp(NOLOCK) WHERE modified =0 and id IN
(SELECT componentId FROM APP_ComponentProp(NOLOCK) WHERE propertyTypeId = 1103 AND
					 stringVal IN (select formattedGUID from @mbGUIDTbl) or stringVal IN (select formattedGUID9 from @mbGUIDTbl))
				)
		AND B.appTypeId = 54 AND A.id = B.clientId AND A.status & 0x4000000 <> 0x4000000
		-- For PST Archiving subclient
		INSERT INTO #clientIdTable
		SELECT clientId, id, 5/*CaseHoldType.Emails*/
		FROM App_Application(NOLOCK)
		WHERE id IN
		(
			SELECT C.componentId FROM App_ComponentProp(NOLOCK) C WHERE
			C.componentId in (SELECT componentNameId FROM App_SubClientProp(NOLOCK) WHERE attrName = 'ReferenceCopy PST Archiving' AND modified = 0 AND attrVal = '1')
AND C.propertyTypeId = 2300
			AND (C.stringVal IN (SELECT formattedGUID FROM @mbGUIDTbl) OR C.stringVal IN (SELECT formattedGUID9 FROM @mbGUIDTbl))
		)
		-- If there is no custodian then select all the mailbox subclients
		IF NOT EXISTS(SELECT 1 FROM @mbGUIDTbl)
		BEGIN
			INSERT INTO #clientIdTable
			SELECT app.clientId, app.id, 5/*CaseHoldType.Emails*/
			FROM App_Application app(NOLOCK), App_Client(NOLOCK) cli
			WHERE app.appTypeId = 54 AND cli.id = app.clientId AND
			(cli.status & 0x4000000 <> 0x4000000 OR EXISTS(Select 1 from App_SubclientProp(NOLOCK) where componentNameId = app.id and attrName = 'ReferenceCopy PST Archiving' and modified = 0 and attrVal = '1'))
		END
		-- Add all the PST Archiving subclients with CMIncludeAllPSTSubclients database key.
		IF EXISTS(SELECT *FROM GxGlobalParam Where name ='CMIncludeAllPSTSubclients' and value = '1' and modified = 0)
		BEGIN
			INSERT INTO #clientIdTable
			SELECT clientId, id, 5/*CaseHoldType.Emails*/
			FROM App_Application(NOLOCK)
			WHERE appTypeId = 54 AND id IN(Select componentNameId from App_SubclientProp(NOLOCK) where attrName = 'ReferenceCopy PST Archiving' and modified = 0 and attrVal = 1)
		END
	END
	-- Security Checks.
	IF OBJECT_ID('tempdb.dbo.#associatedEntitiesWithCapability') IS NOT null
	   DROP TABLE #associatedEntitiesWithCapability
	create table #associatedEntitiesWithCapability ( [capabilities] bigint NOT null, [flag] int NOT null default 0, [commCellId] int NOT null, [clientGroupId] int NOT null, [clientId] int NOT null, [appTypeId] int NOT null, [instanceId] int NOT null, [backupsetId] int NOT null, [subClientId] int NOT null, [mediaAgentId] int NOT null, [libraryId] int NOT null, [archGroupId] int NOT null, [vtContainerId] int NOT null, [vtPolicyId] int NOT null, [vtShelfId] int NOT null, [reviewSetId] int NOT null default 0, [querySetId] int NOT null default 0, [downloadSetId] int NOT null default 0, [ermId] int NOT null default 0, [legalHoldId] int NOT null default 0, [tagId] int NOT null default 0, [cdPolicyId] int NOT null default 0, [complianceReportId] int NOT null default 0, [taskId]        int	NOT null default 0, [workflowId] int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId] int	NOT null default 0, [cloudId] int	NOT null default 0, [userGroupId] int	NOT null default 0, [providerId] int	NOT null default 0, [entityId1] int	NOT null default 0, [entityId2] int	NOT null default 0, [entityId3] int	NOT null default 0, [entityId4] int	NOT null default 0, [entityId5] int	NOT null default 0, [entityId6] int	NOT null default 0, [entityId7] int	NOT null default 0, [entityId8] int	NOT null default 0, [entityId9] int	NOT null default 0)
	-- Set the capability as complianceserach
SET @capability  = 25
SET @capability2 = 22
	SET @allAssociations = 0
	EXEC sec_getUserObjects @caseManagerId, 0, 0, '#associatedEntitiesWithCapability'
	-- Delete those entities on which user doesn't have compliance search capability
	DELETE FROM #associatedEntitiesWithCapability where ((capabilities & POWER(2, @capability - 1)) = 0) OR ((capabilities & POWER(2, @capability2 - 1)) = 0)
	-- Now we have come to Entities(clientGrp/client/appType/instance/bs/sc), we can remove associations not involving these. like lib, ma, sp etc
	delete #associatedEntitiesWithCapability
	WHERE 	mediaAgentId <> 0 OR libraryID <> 0 OR archGroupID <> 0 or vtContainerId <> 0 or vtPolicyId <> 0 or vtShelfId <> 0
	OR reviewSetId <> 0 OR querySetId <> 0 OR downloadSetId <> 0 OR tagId <> 0 OR legalHoldId <> 0 OR ermId <> 0 OR cdPolicyId <> 0 OR complianceReportId <> 0
	OR taskId <> 0 OR workflowId <> 0 OR logMonitoringPolicyId <> 0 OR arrayId <> 0
	OR cloudId <> 0 OR userGroupId <> 0 OR providerId <> 0 OR entityId1 <> 0
	OR entityId2 <> 0 OR entityId3 <> 0 OR entityId4 <> 0 OR entityId5 <> 0
	OR entityId6 <> 0 OR entityId7 <> 0 OR entityId8 <> 0 OR entityId9 <> 0
	if exists(select 1 from #associatedEntitiesWithCapability
					WHERE commCellId = 2
					AND clientId    = 0
					AND appTypeId   = 0
					AND instanceId  = 0
					AND backupSetId = 0
					AND subClientId = 0
					AND clientGroupId = 0
					)
	begin
		SET @allAssociations = 1
	end
	if(@allAssociations = 0)
	begin
		Delete from #clientIdTable
		Where id not in(
						select clientId From #associatedEntitiesWithCapability
						union
						select clientId from App_ClientGroupAssoc(NOLOCK) where clientGroupId in(select clientGroupId From #associatedEntitiesWithCapability)
						)
	end
	EXEC
	('
	INSERT INTO #userClientIdTbl
	SELECT DISTINCT id, appId, holdType FROM #clientIdTable
	')
	DROP TABLE #supportedAgentTypes
	DROP TABLE #clientIdTable
	DROP TABLE #associatedEntitiesWithCapability
	DROP TABLE #sec_CMClientGroups
	SET NOCOUNT OFF
END
GO

IF EXISTS (select * from GxQscripts where name = 'DM2GetCMRefCopyAssociations')
	delete from GxQscripts where name = 'DM2GetCMRefCopyAssociations'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetCMRefCopyAssociations')
	delete from GXDBVersions where aliasname = 'DM2GetCMRefCopyAssociations'
GO

insert into GXDBVersions values(2, 'DM2GetCMRefCopyAssociations',  '00010008000200060000', 'DM2GetCMRefCopyAssociations', '00010008000200060000')
GO

