

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2GetCMClientsForRefCopy.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  DM2GetCMClientsForRefCopy()
--  | Description:  Get list of clients for given user on which compliance as well as out of place restore permission present
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DM2GetCMClientsForRefCopy.sp,v $ $Id: DM2GetCMClientsForRefCopy.sp,v 1.1.2.7 2020/09/04 15:29:06 ssivananthan Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='DM2GetCMClientsForRefCopy')
BEGIN
	print '>>> Drop Stored Procedure: DM2GetCMClientsForRefCopy <<<'
	drop procedure DM2GetCMClientsForRefCopy
END
IF EXISTS (select * from GxQscripts where name='DM2GetCMClientsForRefCopy')
	delete from GxQscripts where name = 'DM2GetCMClientsForRefCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetCMClientsForRefCopy')
	delete from GXDBVersions where aliasname = 'DM2GetCMClientsForRefCopy'
GO
print '... Creating Procedure: DM2GetCMClientsForRefCopy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DM2GetCMClientsForRefCopy
  @i_CaseManagerId int,
  @i_sortOrder VARCHAR(10) = 'asc',
  @i_offset int = 0,
  @i_PageSize int = 20,
  @i_holdType int = 4,
  @i_searchText nvarchar(255) = '',
  @o_TotalCount int = 0 OUTPUT
AS
BEGIN
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
--- Useful when debugging. Leave this around!
---
/*
DECLARE @i_CaseManagerId int = 1
DECLARE @i_SortOrder VARCHAR(10) = 'asc'
DECLARE @i_Offset int = 0
DECLARE @i_PageSize int = 10
DECLARE @i_HoldType int = 4
DECLARE @i_SearchText nvarchar(255) = ''
DECLARE @o_TotalCount int = 0
DECLARE @execStart DATETIME
DECLARE @execEnd DATETIME
SET @execStart = GETDATE()
*/
---
--- Useful when debugging. Leave this around!
-- We will only find names starting with to be faster and not do contains search to begin with
--
SET @i_SearchText = @i_SearchText + '%'
--
IF OBJECT_ID('tempdb.dbo.#CMClientListComp') IS NOT NULL
BEGIN
	DROP TABLE #CMClientListComp
END
--
IF OBJECT_ID('tempdb.dbo.#CMClientListRestore') IS NOT NULL
BEGIN
	DROP TABLE #CMClientListRestore
END
--
CREATE TABLE #CMClientListComp
(
    t_clientId INT, t_appTypeId INT, t_instanceId INT, t_backupsetId INT, t_subclientId INT
)
--
CREATE TABLE #CMClientListRestore
(
    t_clientId INT, t_appTypeId INT, t_instanceId INT, t_backupsetId INT, t_subclientId INT
)
-- Capture clients / subclients with compliance search permission
--
EXEC sec_getIdaObjectsForUser @i_CaseManagerId, 7  /* 7 (7) */ , 25 /* 25 (25) */ , 0, '#CMClientListComp'
-- Capture clients / subclients with "out of place restore" permission
--
EXEC sec_getIdaObjectsForUser @i_CaseManagerId, 7  /* 7 (7) */ , 22 /* 22 (22) */, 0, '#CMClientListRestore'
-- create necessary indexes on temp tables for faster execution, specially needed on large environments
--
create index CMClientListComp_clientid on #CMClientListComp (t_clientId)
create index CMClientListRestore_clientid on #CMClientListRestore (t_clientId)
create index CMClientListRestore_appTypeId on #CMClientListRestore (t_appTypeId)
--
-- Get rid of clients that were created for installing analytics package as a separate server
--
DELETE A
FROM #CMClientListComp A
WHERE A.t_clientId IN (SELECT componentNameId FROM App_ClientProp WITH (NOLOCK) WHERE attrName = 'Index Server Type' AND attrVal IN (15, 8))
--
-- Delete Case Manager clients
DELETE A
FROM #CMClientListComp A
WHERE A.t_clientId IN (SELECT componentNameId FROM App_ClientProp WITH (NOLOCK) WHERE attrName = 'Case Manager Pseudo Client' AND attrVal = '1')
--
-- create table to hold support app types for specified hold type
--
DECLARE @supportedAppTypes TABLE (
	appType integer
)
-- capture supported apptypes
--
INSERT INTO @supportedAppTypes
SELECT appType FROM dbo.getHoldsToAppTypeMapping(@i_HoldType)
INSERT INTO @supportedAppTypes
SELECT DISTINCT refAppType FROM dbo.getHoldsToAppTypeMapping(@i_HoldType)
-- find list of matching clients by performing sorting and paging at same time
--
;WITH CTE
AS
(
SELECT A.ID, A.NAME , ROW_NUMBER() OVER (ORDER BY
CASE WHEN @i_SortOrder = 'ASC' THEN A.NAME END ASC,
CASE WHEN @i_SortOrder = 'DESC' THEN A.NAME END DESC
) RowNum
FROM APP_Client A, APP_Application B, #CMClientListComp C, #CMClientListRestore D, @supportedAppTypes E
WHERE A.ID = B.clientId AND B.clientId = C.t_clientId AND C.t_clientId = D.t_clientId AND C.t_appTypeId = D.t_appTypeId AND D.t_appTypeId = E.appType AND A.status & 67108864 = 0
AND A.name like @i_SearchText -- Any change in this where clause should be replicated to CTECount query below!!
GROUP BY A.ID, A.name
)
SELECT * FROM CTE WHERE @i_PageSize <= 0 OR (@i_PageSize > 0 AND RowNum > @i_Offset and RowNum <= @i_Offset + @i_PageSize)
SELECT @o_TotalCount = @@ROWCOUNT
-- if valid page size was given, we have to return total number of records so that UI can do paging based on that value
--
IF @i_PageSize > 0
BEGIN
	SELECT @o_TotalCount = COUNT(DISTINCT A.NAME) FROM APP_Client A, APP_Application B, #CMClientListComp C, #CMClientListRestore D, @supportedAppTypes E
	WHERE A.ID = B.clientId AND B.clientId = C.t_clientId AND C.t_clientId = D.t_clientId AND C.t_appTypeId = D.t_appTypeId AND D.t_appTypeId = E.appType AND A.status & 67108864 = 0
	AND A.name like @i_SearchText
END
--- Useful info when debugging. Leave this around!
---
/*
SET @execEnd = GETDATE()
PRINT 'Time taken: ' + CONVERT(VARCHAR(20), DATEDIFF(millisecond,@execStart,@execEnd)) + ' milli-seconds. Total rows # ' + convert(varchar, @o_TotalCount)
*/
---
--- Useful info when debugging. Leave this around!
END
GO

IF EXISTS (select * from GxQscripts where name = 'DM2GetCMClientsForRefCopy')
	delete from GxQscripts where name = 'DM2GetCMClientsForRefCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetCMClientsForRefCopy')
	delete from GXDBVersions where aliasname = 'DM2GetCMClientsForRefCopy'
GO

insert into GXDBVersions values(2, 'DM2GetCMClientsForRefCopy',  '00010001000200070000', 'DM2GetCMClientsForRefCopy', '00010001000200070000')
GO

