

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2GetCIClientsAndProps.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DM2GetCIClientsAndProps.sp,v $ $Id: DM2GetCIClientsAndProps.sp,v 1.10.278.2 2018/03/27 08:56:50 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 				Procedure : "DM2GetCIClientsAndProps"				|
--	|	This Procedure is used when initially getting the list of clients.	|
--	|   It includes only the properties that are absolutely necessary at 	|
--	|	that time!															|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DM2GetCIClientsAndProps <<<'

IF EXISTS (select * from sysobjects where name='DM2GetCIClientsAndProps')
	drop procedure DM2GetCIClientsAndProps
IF EXISTS (select * from GxQscripts where name='DM2GetCIClientsAndProps')
	delete from GxQscripts where name = 'DM2GetCIClientsAndProps'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetCIClientsAndProps')
	delete from GXDBVersions where aliasname = 'DM2GetCIClientsAndProps'
GO
print '... Creating Procedure: DM2GetCIClientsAndProps'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure DM2GetCIClientsAndProps
  @i_userId integer
--	The next lines are the columns, in order, that will be in the
--  result set for this cursor.  EXTREME CAUTION must be exercised to
--  ensure that these match up with the result set in terms of type, size,
--  and order!
--************************************************************************
--	NEW ITEMS MAY ONLY BE ADDED AT THE END OF THE :OUT LIST!!!!!!!!!!!!!!
--	This is because some code (myIndicator) uses a hardcoded index # into
--	this list for certain items, so if an item is inserted before them,
--	the index # will reference the wrong item and we will get the wrong
--	data to send to the GUI!
--************************************************************************
AS
  DECLARE @r_id integer
  DECLARE @r_name nchar(255)
  DECLARE @r_netHostName nchar(255)
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	DECLARE @providerId int
DECLARE	@ClientListTbl	TABLE (	[r_id]				INT,
		[visibleToUser]				INT,
		[r_name]					NVARCHAR(1024)	DEFAULT(null),
		[r_netHostName]				NVARCHAR(1024)	DEFAULT(null),
		[r_CIEngine]				NVARCHAR(1024)	DEFAULT(null),
		[r_contentIndexingEnabled]	INT )
	IF object_id('tempdb.dbo.#clientListTmp') is not null
		DROP TABLE #clientListTmp
IF @i_userId <> 0
BEGIN
create table  #clientListTmp ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
END
DECLARE @clientPropTbl TABLE (	clientId		INT,
				deleted			INT,
				CIEngine		VARCHAR(1024) DEFAULT(NULL),
				virtual			INT,
				islicensed		INT,
				physClientId		INT,
				DCinstalled		INT,
				contentIndexingEnabled	INT	)
--  +---------------------------------------------------------------------------------+
--  | Create a temporary table with columns for all the data we want to return and    |
--  | .. one row for every entry in the client table that hadn't been "hard deleted"  |
--  +---------------------------------------------------------------------------------+
	INSERT INTO  @ClientListTbl
	SELECT
		[r_id]				= C.id,
		[visibleToUser]		= 0,
		[r_name]			= C.name,
		[r_netHostName]		= C.net_hostname,
		[r_CIEngine]		= '',
		[r_contentIndexingEnabled] = 0
	FROM  APP_Client C--, simsystemOS S, simOS O
	WHERE (
	EXISTS ( SELECT * FROM dbo.APP_ClientProp WHERE componentNameId = C.id AND attrName = 'Content Indexing Enabled'
	AND attrVal = '1' AND modified = 0) OR EXISTS (SELECT * FROM dbo.APP_Application WHERE clientId = C.id AND dbo.APP_Application.appTypeId IN ( 93, 105))) --AND
	--C.simSystemOSId = S.id AND S.simOSid = O.id --AND O.family in (SIM_OSID_ANY_UNIX, SIM_OSID_ANY_WINDOWS, SIM_OSID_WINNT_FAMILY, SIM_OSID_WIN9X_FAMILY, SIM_OSID_WIN_DOTNET_FAMILY)
-- Following Line removes rows for clients that were "hard deleted"
	DELETE @ClientListTbl
	WHERE  NOT exists (select * from APP_Platform where APP_Platform.clientId =[r_id] AND [platformType]=4)
--	+---------------------------------------------------------------------------------------------------------------+
--	| HERE IS THE "BEST" PLACE TO FILTER ON USER VISIBILITY .. SO WE CAN REDUCE THE NUMBER OF "JOINS" DONE LATER	|
--	+---------------------------------------------------------------------------------------------------------------+
	if (@i_userId <> 0)
	BEGIN
		EXEC sec_getUserObjects @i_userId, 0, 0, '#clientListTmp'
		IF EXISTS (SELECT * FROM #clientListTmp WHERE commCellId <> 0
								AND  clientGroupId = 0	AND  clientId = 0
								AND  appTypeId = 0		AND  instanceId = 0
								AND  backupsetId = 0	AND  subClientId = 0
								AND  mediaAgentId = 0	AND  libraryId = 0
								AND  archGroupId = 0	AND  vtContainerId = 0
								AND  vtPolicyId = 0		AND  vtShelfId = 0)
			UPDATE @ClientListTbl SET [visibleToUser] = 1
		ELSE
			UPDATE @ClientListTbl SET [visibleToUser] = 1
			WHERE EXISTS (select * from #clientListTmp WHERE [r_id] = clientId)
		-- WE DON'T EVEN WANT TO KNOW ABOUT CLIENTS WE DON'T HAVE ACCESS TO
		delete @ClientListTbl where [visibleToUser] =0
		update @ClientListTbl set [visibleToUser] =0
	END
	-- get data from clientProp table
	INSERT INTO @clientPropTbl
	SELECT	componentNameId					AS clientId,
		[platformdeleted 4]				AS deleted,
		[Content Indexing Engine]			AS CIEngine,
		[Virtual client]				AS virtual,
		[Licensed Client]				AS islicensed,
		[Active Physical Node]				AS physClientId,
		[Data Classification Installed on Client]	AS DCinstalled,
		[Content Indexing Enabled]			AS contentIndexingEnabled
	FROM	(	SELECT	componentNameId, attrName, attrVal
			FROM	App_ClientProp
			WHERE	componentNameId in (select [r_id] from @ClientListTbl) AND modified = 0
		) AS clients
	PIVOT	(	MAX(attrVal) FOR attrName IN (	[platformdeleted 4], [Content Indexing Engine],
							[Virtual client], [Licensed Client], [Active Physical Node],
							[Data Classification Installed on Client], [Content Indexing Enabled] )
		) AS P
	UPDATE	@ClientListTbl
	SET	[r_CIEngine]			= CIEngine,
		[r_contentIndexingEnabled]	= contentIndexingEnabled
	FROM	@clientPropTbl
	WHERE	[r_id] = clientId
	SELECT	[r_id],
		RTRIM([r_name]) AS [r_name],
		RTRIM([r_netHostName]) AS [r_netHostName]
	FROM @ClientListTbl -- WHERE [r_contentIndexingEnabled] = 1
	ORDER BY [r_id]
	SET NOCOUNT OFF
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'DM2GetCIClientsAndProps')
	delete from GxQscripts where name = 'DM2GetCIClientsAndProps'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetCIClientsAndProps')
	delete from GXDBVersions where aliasname = 'DM2GetCIClientsAndProps'
GO

insert into GXDBVersions values(2, 'DM2GetCIClientsAndProps',  '00010010027800020000', 'DM2GetCIClientsAndProps', '00010010027800020000')
GO

