

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2GetAnalyticsRoles.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DM2GetAnalyticsRoles <<<'

IF EXISTS (select * from sysobjects where name='DM2GetAnalyticsRoles')
	drop procedure DM2GetAnalyticsRoles
IF EXISTS (select * from GxQscripts where name='DM2GetAnalyticsRoles')
	delete from GxQscripts where name = 'DM2GetAnalyticsRoles'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetAnalyticsRoles')
	delete from GXDBVersions where aliasname = 'DM2GetAnalyticsRoles'
GO
print '... Creating Procedure: DM2GetAnalyticsRoles'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DM2GetAnalyticsRoles
  @i_maClientId INT
AS
  DECLARE @o_roleId INT
  DECLARE @o_roleTypeName VARCHAR(255)
  DECLARE @o_clientId INT
  DECLARE @o_memoryMB INT
DECLARE @analyticsRoles TABLE (t_roleId INT, t_roleTypeName VARCHAR(255), t_clientId INT, t_memoryMB INT)
INSERT INTO @analyticsRoles(t_roleId, t_roleTypeName , t_clientId )
SELECT DISTINCT AR.roleId, AR.roleTypeName, 0
FROM DM2CloudRoleMaster AR  WITH (NOLOCK)
	LEFT JOIN DM2CloudCoreRole CR WITH (NOLOCK) ON AR.roleType = CR.roleId
	LEFT JOIN DM2SearchServerCoreInfo S WITH (NOLOCK) ON CR.CloudId = S.CloudId AND S.ClientId = @i_maClientId
WHERE flags = 1
update @analyticsRoles
set t_clientId = S.clientId
FROM @analyticsRoles
	JOIN  DM2CloudCoreRole CR WITH (NOLOCK) ON CR.roleId = t_roleId
	JOIN DM2SearchServerCoreInfo S WITH (NOLOCK) ON CR.CloudId = S.CloudId AND S.ClientId = @i_maClientId
--Do not include EDGE drive if webserver or index server package is not installed on MA.
DELETE A
FROM @analyticsRoles A
WHERE A.t_roleTypeName = 'EDGE Drive'
AND NOT EXISTS ( SELECT 1 FROM  simInstalledPackages WITH (NOLOCK) WHERE clientId = @i_maClientId AND SimPackageID IN ( 252, 263, 1156))
--Do not include Download center role if it is already configured on any MA.
DELETE A
FROM @analyticsRoles A
WHERE A.t_roleTypeName = 'Download Center' AND t_clientId = 0
AND EXISTS ( SELECT * FROM  GXGlobalParam WITH (NOLOCK) WHERE name = 'DOWNLOAD_CENTER_CLIENT_ID' and modified = 0)
--Do not include Download center role if it is already configured on any MA.
DELETE A
FROM @analyticsRoles A
WHERE A.t_roleTypeName = 'Download Center' AND t_clientId = 0
AND EXISTS ( SELECT * FROM  GXGlobalParam WHERE name = 'DOWNLOAD_CENTER_CLIENT_ID' and modified = 0)
-- Do not include the ExchangeIndex Role if the mediaAgent is not V11+
IF EXISTS(SELECT 1 FROM APP_CLIENT(NOLOCK) WHERE id = @i_maClientId and releaseId <= 15/*V10*/)
BEGIN
	DELETE A
	FROM @analyticsRoles A
	WHERE A.t_roleTypeName = 'Exchange Index' AND t_clientId = 0
END
UPDATE A
SET t_memoryMB = ISNULL(CP.ATTRVAL,0)
FROM @analyticsRoles A
	INNER JOIN APP_clientProp CP WITH (NOLOCK) ON a.t_clientId = CP.componentnameID
WHERE CP.ATTRNAME = 'Analytics_Memory_MB' AND MODIFIED = 0
SELECT * FROM @analyticsRoles
GO

IF EXISTS (select * from GxQscripts where name = 'DM2GetAnalyticsRoles')
	delete from GxQscripts where name = 'DM2GetAnalyticsRoles'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetAnalyticsRoles')
	delete from GXDBVersions where aliasname = 'DM2GetAnalyticsRoles'
GO

insert into GXDBVersions values(2, 'DM2GetAnalyticsRoles',  '00000000000000000000', 'DM2GetAnalyticsRoles', '00000000000000000000')
GO

