

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2GetAnalyticsMA.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--     +-----------------------------------------------------------------------+
--     |                       PROCEDURE: "DM2GetAnalyticsMA"                  |
--     +-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='DM2GetAnalyticsMA')
BEGIN
	print '>>> Drop Stored Procedure: DM2GetAnalyticsMA <<<'
	drop procedure DM2GetAnalyticsMA
END
IF EXISTS (select * from GxQscripts where name='DM2GetAnalyticsMA')
	delete from GxQscripts where name = 'DM2GetAnalyticsMA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetAnalyticsMA')
	delete from GXDBVersions where aliasname = 'DM2GetAnalyticsMA'
GO
print '... Creating Procedure: DM2GetAnalyticsMA'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DM2GetAnalyticsMA
  @i_ClientId INT = 0,
  @i_CloudServerType INT = 0,
  @i_SelectOutput INT = 1,
  @i_isUninstallRequest INT = 0
AS
  DECLARE @o_clientId INT
  DECLARE @o_clientName VARCHAR(255)
  DECLARE @o_hostName VARCHAR(255)
  DECLARE @o_clientType INT
  DECLARE @o_nodeStatus INT
  DECLARE @o_isCAEnabled VARCHAR(32) 
  DECLARE @o_jvmMax VARCHAR(32)
  DECLARE @o_caPortNo VARCHAR(32)
  DECLARE @o_caURL VARCHAR(255)
  DECLARE @o_indexLocation VARCHAR(1024)
  DECLARE @o_clientDisplayName NVARCHAR(512)
  DECLARE @o_cloudIdId INT
  DECLARE @o_pseudoClientId INT
  DECLARE @o_cloudStatus INT
DECLARE	@CLIENTTYPE_CA			INT = 1
DECLARE	@ALREADY_CONFIGURED_CA 	INT = 1
DECLARE	@NON_CONFIGURED_CA		INT = 2
IF @i_SelectOutput = 1
BEGIN
	IF OBJECT_ID('tempdb.dbo.#contentAnalyzerTbl') IS NOT NULL DROP TABLE #contentAnalyzerTbl
    CREATE TABLE #contentAnalyzerTbl
							(	t_clientId INT,
								t_clientName VARCHAR(255),
								t_hostName VARCHAR(255),
								t_clientType INT,
								t_nodeStatus INT DEFAULT 0,
								t_isCAEnabled VARCHAR(32) DEFAULT 'false',
								t_jvmMax VARCHAR(32) DEFAULT '4096',
								t_caPortNo VARCHAR(32) DEFAULT '22000' ,
								t_caURL VARCHAR(255) DEFAULT '',
								t_indexLocation VARCHAR(1024) DEFAULT '',
								t_clientDisplayName NVARCHAR(512) DEFAULT '',
								t_cloudId	INT,
								t_pseudoClientId INT DEFAULT 0,
								t_cloudStatus INT DEFAULT 0)
END
DECLARE @caCloudDetails TABLE
			(	clientId      INT,
				isCAEnabled VARCHAR(32),
				caPort  INT,
				jvm  INT,
				indexLocation VARCHAR(1024),
				instance VARCHAR(1024)
             )
IF OBJECT_ID('tempdb.dbo.#caNodeMetaInfo') IS NOT NULL DROP TABLE #caNodeMetaInfo
    CREATE TABLE #caNodeMetaInfo ( attrValue NVARCHAR(1024),
                               attrName NVARCHAR(1024),
                               clientId INT)
IF @i_CloudServerType = 2 --ContentAnalyzer
BEGIN
	IF @i_isUninstallRequest = 1
		INSERT INTO #contentAnalyzerTbl(t_clientId, t_clientName, t_clientDisplayName, t_hostName, t_clientType)
		SELECT DISTINCT C.id, C.name, C.displayName, C.net_hostName, @CLIENTTYPE_CA
		FROM APP_CLIENT C (NOLOCK)
		WHERE C.ID= @i_ClientId
	ELSE
		--DO NOT INCLUDE CA WHERE CA  IS ALREADY part of cloud.
		INSERT INTO #contentAnalyzerTbl(t_clientId, t_clientName, t_clientDisplayName, t_hostName, t_clientType)
		SELECT DISTINCT C.id, C.name, C.displayName, C.net_hostName, @CLIENTTYPE_CA
		FROM APP_CLIENT C (NOLOCK)
		JOIN simInstalledPackages P (NOLOCK) ON C.id = P.ClientId
WHERE P.simPackageID IN ( 729,1108)
			AND (@i_ClientId = 0 OR C.ID= @i_ClientId)
--cloud details
	UPDATE #contentAnalyzerTbl
	SET t_cloudId = S.cloudId,
		t_isCAEnabled = 'true'
	FROM  #contentAnalyzerTbl T
	JOIN DM2SearchServerCoreInfo S (NOLOCK) ON  T.t_clientId = S.clientId
WHERE S.cloudType = 2
--get CA details only during configuration/install
IF @i_isUninstallRequest = 0
BEGIN
	--get meta info for
	INSERT INTO #caNodeMetaInfo
	SELECT DISTINCT CLP.attrVal , CLP.attrName, CLP.componentNameId
	FROM APP_ClientProp AS CLP (NOLOCK)
	JOIN #contentAnalyzerTbl T ON CLP.componentNameId= T.t_clientId
	WHERE CLP.attrName IN ('contentPreviewEngineEnabled', 'contentPreviewPort',
			'contentPreviewMaxJvm', 'ContentPreviewTempOutputDir', 'Galaxy Instance name')
			 AND CLP.modified = 0
	--pivot
	INSERT @caCloudDetails (clientId, isCAEnabled, caPort, jvm, indexLocation, instance)
	SELECT clientId,
			[contentPreviewEngineEnabled] AS isCAEnabled,
			[contentPreviewPort] AS caPort,
			[contentPreviewMaxJvm] AS jvm,
			[ContentPreviewTempOutputDir] AS indexLocation,
			[Galaxy Instance name] AS instance
	FROM (
		select dbo.APP_ClientProp.componentNameId AS clientId,SL.attrName AS attName, SL.attrValue AS attVal
		FROM #caNodeMetaInfo AS SL LEFT OUTER JOIN
		dbo.APP_ClientProp (NOLOCK) ON dbo.APP_ClientProp.componentNameId = SL.clientId
		WHERE SL.clientId > 0
		) AS caCloudList
	PIVOT ( MAX( attVal ) FOR attName IN ( [contentPreviewEngineEnabled],[contentPreviewPort],[contentPreviewMaxJvm], [ContentPreviewTempOutputDir], [Galaxy Instance name] )
	) AS P
	--cloud details
	UPDATE #contentAnalyzerTbl
	SET t_nodeStatus = 1,
		t_jvmMax = ISNULL(jvm, 4096),
		t_indexLocation = ISNULL (indexLocation, '')
	FROM @caCloudDetails CP
	JOIN #contentAnalyzerTbl T ON  CP.clientId = T.t_clientId
	--get only non configured clients
	IF @i_ClientId = 0
		DELETE FROM #contentAnalyzerTbl WHERE t_cloudId > 0
	--port no
	UPDATE #contentAnalyzerTbl
	SET t_caPortNo =  ISNULL(caPort, (CASE WHEN instance = 'Instance001' THEN '22000' ELSE ('2200'+ SUBSTRING (instance, LEN(instance), LEN(instance))) END))
	FROM @caCloudDetails CP
	JOIN #contentAnalyzerTbl T ON  CP.clientId = T.t_clientId
	--get ca url
	UPDATE #contentAnalyzerTbl
	SET t_caURL = 'http://' + t_hostName + ':' + t_caPortNo  +'/CvContentPreviewGenApp'
	--default index location
	UPDATE #contentAnalyzerTbl
	SET t_indexLocation = P.install_dir + CASE WHEN S.Type ='WINDOWS' THEN '\CVCIEngine\CvPreviewHome\CAcache' ELSE '/CVCIEngine/CvPreviewHome/CAcache' END
	FROM APP_Platform P (NOLOCK)
	JOIN #contentAnalyzerTbl T ON  P.clientId = T.t_clientId
	JOIN APP_Client C (NOLOCK) ON T.t_clientId = C.id
	JOIN SimOperatingSystem S (NOLOCK) ON C.simOperatingSystemId = S.id
	WHERE P.platformType = 4 AND t_indexLocation = ''
END
	--get cloud clientid & status
	UPDATE #contentAnalyzerTbl
	SET t_pseudoClientId = C.pseudoClientId,
		t_cloudStatus= C.status
	FROM DM2Cloud C (NOLOCK)
	JOIN #contentAnalyzerTbl T ON  T.t_cloudId = C.cloudId
WHERE C.cloudType = 2
END
IF @i_SelectOutput = 1
BEGIN
	--OUTPUT
	SELECT * FROM #contentAnalyzerTbl
	IF OBJECT_ID('tempdb.dbo.#contentAnalyzerTbl') IS NOT NULL DROP TABLE #contentAnalyzerTbl
END
IF OBJECT_ID('tempdb.dbo.#caNodeMetaInfo') IS NOT NULL DROP TABLE #caNodeMetaInfo
GO

IF EXISTS (select * from GxQscripts where name = 'DM2GetAnalyticsMA')
	delete from GxQscripts where name = 'DM2GetAnalyticsMA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetAnalyticsMA')
	delete from GXDBVersions where aliasname = 'DM2GetAnalyticsMA'
GO

insert into GXDBVersions values(2, 'DM2GetAnalyticsMA',  '00000000000000000000', 'DM2GetAnalyticsMA', '00000000000000000000')
GO

