

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2GetAnalyticsEngineXML.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DM2GetAnalyticsEngineXML.sp,v $ $Id: DM2GetAnalyticsEngineXML.sp,v 1.1.2.11 2018/05/28 16:07:17 pankajkumar Exp $";
--
--  +========================================================================+
--  |      Cursor:  DM2GetAnalyticsEngineXML()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DM2GetAnalyticsEngineXML <<<'

IF EXISTS (select * from sysobjects where name='DM2GetAnalyticsEngineXML')
	drop procedure DM2GetAnalyticsEngineXML
IF EXISTS (select * from GxQscripts where name='DM2GetAnalyticsEngineXML')
	delete from GxQscripts where name = 'DM2GetAnalyticsEngineXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetAnalyticsEngineXML')
	delete from GXDBVersions where aliasname = 'DM2GetAnalyticsEngineXML'
GO
print '... Creating Procedure: DM2GetAnalyticsEngineXML'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DM2GetAnalyticsEngineXML
  @i_xmlText XML
AS
  DECLARE @o_xmlText XML;
SET NOCOUNT ON
IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
    CREATE TABLE #getIndexServers
            (     serverURL NVARCHAR(512),
                  clientId INT,
                  clientName NVARCHAR(256),
                  cloudId INT,
                  hostName NVARCHAR(256),
                  basePort INT,
                  engineName  NVARCHAR(256),
                  serverType INT,
                  indexServerClientId INT,
                  internalCloudName NVARCHAR(256)
            )
DECLARE @ClientID INT;
SET @ClientID = ISNULL(( SELECT ref.value('@clientId', 'int')
							FROM @i_xmlText.nodes('EVGui_AnalyticsEngineClientID/client') R ( ref ) ), 0)
DECLARE @indexServerClientId INT;
SET @indexServerClientId = ISNULL(( SELECT ref.value('@clientId', 'int')
							FROM @i_xmlText.nodes('EVGui_AnalyticsEngineClientID/indexServerClient') R ( ref ) ), 0)
DECLARE @RoleName VARCHAR(255);
SET @RoleName = ISNULL(( SELECT ref.value('@roleName', 'VARCHAR(255)')
							FROM @i_xmlText.nodes('EVGui_AnalyticsEngineClientID') R ( ref ) ), '')
exec DM2GetIndexServers @RoleName, @indexServerClientId /*i_indexServerClientId*/, 0 /*i_cloudId*/, @ClientID /*i_nodeClientId*/
SET @o_xmlText = (SELECT
					( SELECT serverURL '@serverName',
						cloudId '@cloudId',
						hostName '@hostName',
						basePort  '@basePort',
						engineName '@engineName',
						serverType '@serverType'
					FROM  #getIndexServers S
					FOR XML PATH('indexServers'), TYPE
             ) FOR XML PATH('IndexServerList')
			)
IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
IF @o_xmlText IS NULL
    SET @o_xmlText = '<IndexServerList/>'
SELECT @o_xmlText AS [o_xmlText]
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'DM2GetAnalyticsEngineXML')
	delete from GxQscripts where name = 'DM2GetAnalyticsEngineXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetAnalyticsEngineXML')
	delete from GXDBVersions where aliasname = 'DM2GetAnalyticsEngineXML'
GO

insert into GXDBVersions values(2, 'DM2GetAnalyticsEngineXML',  '00010001000200110000', 'DM2GetAnalyticsEngineXML', '00010001000200110000')
GO

