

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2GetAnalyticsEngineOfSimPackageType.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='DM2GetAnalyticsEngineOfSimPackageType')
BEGIN
	print '>>> Drop Stored Procedure: DM2GetAnalyticsEngineOfSimPackageType <<<'
	drop procedure DM2GetAnalyticsEngineOfSimPackageType
END
IF EXISTS (select * from GxQscripts where name='DM2GetAnalyticsEngineOfSimPackageType')
	delete from GxQscripts where name = 'DM2GetAnalyticsEngineOfSimPackageType'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetAnalyticsEngineOfSimPackageType')
	delete from GXDBVersions where aliasname = 'DM2GetAnalyticsEngineOfSimPackageType'
GO
print '... Creating Procedure: DM2GetAnalyticsEngineOfSimPackageType'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DM2GetAnalyticsEngineOfSimPackageType
  @i_simPackageIds NVARCHAR(Max),
  @i_roleType VARCHAR(32) =''
AS
-- Get all packageIds for this user
DECLARE @packageIDs TABLE (simPackageID INT PRIMARY KEY)
DECLARE @SEPARATOR CHAR = ','
IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL
    DROP TABLE #getIndexServers
CREATE TABLE #getIndexServers
            (     serverURL NVARCHAR(512),
                  clientId INT,
                  clientName NVARCHAR(256),
                  cloudId INT,
                  hostName NVARCHAR(256),
                  basePort INT,
                  engineName  NVARCHAR(256),
                  serverType INT,
                  indexServerClientId INT,
                  internalCloudName NVARCHAR(256)
            )
INSERT INTO @packageIDs
SELECT CAST(Data AS INT) FROM dbo.split(@i_simPackageIds, @SEPARATOR)
EXEC DM2GetIndexServers @i_roleType
SELECT distinct S.serverURL AS 'serverName',
       S.clientId,
       S.clientName,
       S.cloudId,
       S.hostName,
       S.basePort,
       S.engineName,
       S.serverType 'cloudType',
       S.indexServerClientId 'indexServerClientId',
       S.internalCloudName 'internalCloudName'
 FROM #getIndexServers S
 INNER JOIN siminstalledpackages sim WITH (NOLOCK) ON
    sim.ClientId = S.clientId
 INNER JOIN @packageIDs pkg  ON
    sim.simPackageID = pkg.simPackageID
IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL
    DROP TABLE #getIndexServers
GO

IF EXISTS (select * from GxQscripts where name = 'DM2GetAnalyticsEngineOfSimPackageType')
	delete from GxQscripts where name = 'DM2GetAnalyticsEngineOfSimPackageType'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetAnalyticsEngineOfSimPackageType')
	delete from GXDBVersions where aliasname = 'DM2GetAnalyticsEngineOfSimPackageType'
GO

insert into GXDBVersions values(2, 'DM2GetAnalyticsEngineOfSimPackageType',  '00000000000000000000', 'DM2GetAnalyticsEngineOfSimPackageType', '00000000000000000000')
GO

