

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2GetAllCaseClients.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  DM2GetAllCaseClients()
--  | Description:  Get clients for given case.
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DM2GetAllCaseClients.sp,v $ $Id: DM2GetAllCaseClients.sp,v 1.6.2.3 2020/09/04 15:29:09 ssivananthan Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='DM2GetAllCaseClients')
BEGIN
	print '>>> Drop Stored Procedure: DM2GetAllCaseClients <<<'
	drop procedure DM2GetAllCaseClients
END
IF EXISTS (select * from GxQscripts where name='DM2GetAllCaseClients')
	delete from GxQscripts where name = 'DM2GetAllCaseClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetAllCaseClients')
	delete from GXDBVersions where aliasname = 'DM2GetAllCaseClients'
GO
print '... Creating Procedure: DM2GetAllCaseClients'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DM2GetAllCaseClients
  @i_XmlText XML,
  @CaseId int = 0,
  @GetUserClientRelationPerCase INT = 0,
  @debug int = 0
AS
BEGIN
	SET NOCOUNT ON
	DECLARE @allAssociations	INT
	DECLARE @capability			INT
	DECLARE @caseManagerId		INT
DECLARE @EntityType_USER_ENTITY INT = 13
DECLARE @EntityType_USERGROUP_ENTITY INT = 15
DECLARE @EntityType_EXTERNAL_GROUP_ENTITY INT = 62
	IF object_id('tempdb.dbo.#clientIdTbl') IS NOT NULL
	DROP TABLE #clientIdTbl
	CREATE TABLE #clientIdTbl ( id integer)
	IF object_id('tempdb.dbo.#custodianAssetInfo') IS NOT NULL
	   DROP TABLE #custodianAssetInfo
	CREATE TABLE #custodianAssetInfo
	(
		entityType integer,
		userGUID nvarchar(512),
		userGrpId integer,
		groupId integer,
		allAssetsFlag int,
		clientId int,
		isSelected int
	)
	IF object_id('tempdb.dbo.#custodianInfo') IS NOT NULL
	   DROP TABLE #custodianInfo
	CREATE TABLE #custodianInfo
	(
		entityType integer,
		userGUID nvarchar(512),
		userGrpId integer,
		groupId integer,
		allAssetsFlag int
	)
	IF object_id('tempdb.dbo.#FinalUserAssetInfo') IS NOT NULL
	   DROP TABLE #FinalUserAssetInfo
	CREATE TABLE #FinalUserAssetInfo
	(
		ClientId int,
		ClientName nvarchar(255),
		allAssetsFlag INT,
		UserGuid nvarchar(256),
		UserId int,
		LoginUserName nvarchar(255),
		groupId int,
		GroupName nvarchar(255),
		userGrpId int,
		ExternalGroupName nvarchar(255),
		SelectedStatus int
	)
	-- Populate the supported AppTypes
	DECLARE @supportedRefAppTypes TABLE
	(
		refAppType			integer,
		appType				integer
	)
	-- Use table to catpure user/group to client ownership relation
	DECLARE @ownersTable TABLE (clientId INT, userId INT, userGroupId INT, externalGroupId INT)
	--
	if @CaseId > 0
	BEGIN
		SELECT @i_XmlText = CaseXML FROM DM2CaseInfo WHERE CaseId = @caseId
	END
	Insert Into @supportedRefAppTypes values(33, 11)
	Insert Into @supportedRefAppTypes values(33, 34)
	Insert Into @supportedRefAppTypes values(33, 42)
	Insert Into @supportedRefAppTypes values(33, 43)
	Insert Into @supportedRefAppTypes values(33, 1)
	Insert Into @supportedRefAppTypes values(29, 17)
	Insert Into @supportedRefAppTypes values(29, 18)
	Insert Into @supportedRefAppTypes values(29, 19)
	Insert Into @supportedRefAppTypes values(29, 20)
	Insert Into @supportedRefAppTypes values(29, 21)
	Insert Into @supportedRefAppTypes values(29, 29)
	Insert Into @supportedRefAppTypes values(29, 36)
	Insert Into @supportedRefAppTypes values(29, 38)
	Insert Into @supportedRefAppTypes values(29, 63)
	Insert Into @supportedRefAppTypes values(29, 64)
	Insert Into @supportedRefAppTypes values(29, 74)
	Insert Into @supportedRefAppTypes
	select T.ref.value('@applicationId','int'), T.ref.value('@applicationId','int') from @i_XmlText.nodes('/DM2ContentIndexing_CaseInfo/supportedAgents') T(ref)
	Select @caseManagerId = ISNULL(i.Col.value('@userId', 'int'),0) From  @i_XmlText.nodes('/DM2ContentIndexing_CaseInfo/basicCaseInfo/modifiedBy') as i(col)
	IF ISNULL(@caseManagerId, 0) = 0
	Select @caseManagerId = ISNULL(i.Col.value('@userId', 'int'),0) From  @i_XmlText.nodes('/DM2ContentIndexing_CaseInfo/basicCaseInfo/caseCreatedBy') as i(col)
	IF @debug = 1
	SELECT ISNULL(@caseManagerId, 0) 'CaseManagerId', ISNULL(@caseId, 0) 'CaseId'
	;WITH CTEEx
	AS
	(
	SELECT
		ISNULL(i.Col.value('@_type_', 'int'),0) EntityType,
		ISNULL(i.Col.value('@userGUID', 'varchar(256)'),'') UserGuid,
		ISNULL(i.Col.value('@userGroupId', 'int'),0) userGroupId,
		ISNULL(i.Col.value('@groupId', 'int'),0) groupId,
		ISNULL(i.Col.value('../@allAssets', 'int'),0) allAssets,
		ISNULL(o.Col.value('@clientId', 'int'),0) clientId,
		ISNULL(o.col.value('(flags)[1]/@include', 'int'),0) isSelected
	FROM @i_XmlText.nodes('/DM2ContentIndexing_CaseInfo/userAssets/userOrGroup') as i(Col)
	outer apply i.col.nodes('../galaxyEntity') as o(col)
	)
	INSERT INTO #custodianAssetInfo(entityType, UserGuid, userGrpId, groupId, allAssetsFlag, clientId, isSelected)
	SELECT EntityType, UserGuid, userGroupId, groupId, allAssets, clientId, isSelected FROM CTEEx
	IF @debug & 8 = 8
	SELECT * FROM #custodianAssetInfo
	INSERT INTO #custodianInfo
	SELECT DISTINCT CAI.entityType, CAI.userGUID, CAI.userGrpId, CAI.groupId, CAI.allAssetsFlag FROM #custodianAssetInfo CAI
	IF @debug & 2 = 2
		SELECT *, '#custodianInfo' FROM #custodianInfo
	IF object_id('tempdb.dbo.#userIdTbl') IS NOT NULL
	   DROP TABLE #userIdTbl
	create table #userIdTbl
	(
		id integer
	)
	IF object_id('tempdb.dbo.#userGrpTbl') IS NOT NULL
	   DROP TABLE #userGrpTbl
	create table #userGrpTbl
	(
		id integer
	)
	IF object_id('tempdb.dbo.#externalGrpTbl') IS NOT NULL
	   DROP TABLE #externalGrpTbl
	create table #externalGrpTbl
	(
		id integer
	)
	IF object_id('tempdb.dbo.#supportedAgents') IS NOT NULL
		DROP TABLE #supportedAgents
	CREATE TABLE #supportedAgents(appTypeId int)
	insert into #supportedAgents
	select T.ref.value('@applicationId','int') from @i_XmlText.nodes('/DM2ContentIndexing_CaseInfo/supportedAgents') T(ref)
	insert into #userIdTbl
	select distinct B.id from #custodianInfo A, UMUsers B
	Where A.userGUID = B.userGuid And A.userGrpId = 0 And A.groupId = 0
	insert into #userGrpTbl
	select distinct userGrpId from #custodianInfo A
	Where userGrpId > 0 AND LEN(A.userGUID) = 0 And A.groupId = 0
	insert into #externalGrpTbl
	select distinct groupId from #custodianInfo A
	Where groupId > 0 AND LEN(A.userGUID) = 0 And A.userGrpId = 0
	IF @debug = 1
	select id as userId From #userIdTbl
	IF @debug = 1
	select id as userGrpId From #userGrpTbl
	IF @debug = 1
	select id as externalGrpId From #externalGrpTbl
	--We need this information multiple queries. so useful to capture the same in local table variable
	insert into @ownersTable
	SELECT clientId, userId, userGroupId, externalGroupId FROM dbo.sec_getClientOwners(1)
	INSERT INTO #clientIdTbl
	SELECT clientId FROM @ownersTable
	WHERE
	-- user is direct owner of client
	userId IN (SELECT Id FROM #userIdTbl)
	-- user part of internal group which is client owner
	OR (userGroupId IN (SELECT groupId FROM UMUserGroup um WHERE um.userId in (select id From #userIdTbl)))
	-- user part of external group which associated with internal group which is client owner
	OR (userGroupId IN ( SELECT umgroupId FROM UMDSGroupMaps WHERE umDSgroupId IN (SELECT umds.groupId FROM UMDSUserGroup umds WHERE umds.userId in(select id From #userIdTbl)) ))
	-- user part of exteranl group which is client owner
	OR (externalGroupId IN ( SELECT umds1.groupId FROM UMDSUserGroup umds1 WHERE umds1.userId in (select id From #userIdTbl) ))
	/*
	so far we only figured out ownership with respect to list of users given in input
	now figure out ownership w.r.t any input internal/external user-groups (if any)
	Till now (Feb 2015) case manager in compliance search doesn't have support for this, but still back-end suport is there
	*/
    IF @debug = 1
    select id as UserAndGroupClientID from #clientIdTbl
	INSERT INTO #clientIdTbl
	SELECT clientId FROM @ownersTable
	WHERE userGroupId IN
					(
			--specified input external group mapped to internal group which is owner
			SELECT umgroupId FROM UMDSGroupMaps WHERE umDSgroupId IN (select id from #externalGrpTbl )
						union
			--specified input internal group is direct owner
						(select id from #userGrpTbl )
					)
				OR
		externalGroupId IN (select id from #externalGrpTbl) --specified external group is direct owner
	IF @debug = 1
	select id as AllClientID from #clientIdTbl
	IF OBJECT_ID('tempdb.dbo.#associatedEntitiesWithCapability') IS NOT null
	   DROP TABLE #associatedEntitiesWithCapability
	create table #associatedEntitiesWithCapability ( [capabilities] bigint NOT null, [flag] int NOT null default 0, [commCellId] int NOT null, [clientGroupId] int NOT null, [clientId] int NOT null, [appTypeId] int NOT null, [instanceId] int NOT null, [backupsetId] int NOT null, [subClientId] int NOT null, [mediaAgentId] int NOT null, [libraryId] int NOT null, [archGroupId] int NOT null, [vtContainerId] int NOT null, [vtPolicyId] int NOT null, [vtShelfId] int NOT null, [reviewSetId] int NOT null default 0, [querySetId] int NOT null default 0, [downloadSetId] int NOT null default 0, [ermId] int NOT null default 0, [legalHoldId] int NOT null default 0, [tagId] int NOT null default 0, [cdPolicyId] int NOT null default 0, [complianceReportId] int NOT null default 0, [taskId]        int	NOT null default 0, [workflowId] int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId] int	NOT null default 0, [cloudId] int	NOT null default 0, [userGroupId] int	NOT null default 0, [providerId] int	NOT null default 0, [entityId1] int	NOT null default 0, [entityId2] int	NOT null default 0, [entityId3] int	NOT null default 0, [entityId4] int	NOT null default 0, [entityId5] int	NOT null default 0, [entityId6] int	NOT null default 0, [entityId7] int	NOT null default 0, [entityId8] int	NOT null default 0, [entityId9] int	NOT null default 0)
	-- Set the capability as complianceserach
	SET @capability = 25
	SET @allAssociations = 0
	EXEC sec_getUserObjects @caseManagerId, 2009, 0, '#associatedEntitiesWithCapability'
	-- Delete those entities on which user doesn't have compliance search capability
	DELETE FROM #associatedEntitiesWithCapability where ((capabilities & POWER(2, @capability - 1)) = 0)
	IF @debug = 1
	select 1 from #associatedEntitiesWithCapability
	if exists(select 1 from #associatedEntitiesWithCapability
					WHERE commCellId = 2
					AND clientId    = 0
					AND appTypeId   = 0
					AND instanceId  = 0
					AND backupSetId = 0
					AND subClientId = 0
					AND clientGroupId = 0
					)
	begin
		SET @allAssociations = 1
	end
	if(@allAssociations = 0)
	begin
		IF @debug = 1
		begin
			select clientId PermittedClient From #associatedEntitiesWithCapability
			select clientId PermittedClientFromGroup from App_ClientGroupAssoc(NOLOCK) where clientGroupId in(select clientGroupId From #associatedEntitiesWithCapability)
		end
		Delete from #clientIdTbl
		Where id not in(
						select clientId From #associatedEntitiesWithCapability
						union
						select clientId from App_ClientGroupAssoc(NOLOCK) where clientGroupId in(select clientGroupId From #associatedEntitiesWithCapability)
						)
	end
	if @debug = 1
	select appTypeId as SupportedAppType from #supportedAgents
	DELETE FROM @supportedRefAppTypes WHERE refAppType NOT IN (SELECT appTypeId FROM #supportedAgents)
	DELETE TC
	FROM #clientIdTbl TC
	WHERE TC.id NOT IN (
		SELECT distinct clientId FROM #clientIdTbl A, APP_IDAName B
		Where A.id = B.clientId And B.appTypeId in (select appType From @supportedRefAppTypes)
		)
	-- Remove duplicates
	;With clientIdCTE As
	(
	select id, ROW_NUMBER() OVER(PARTITION BY id ORDER BY id) as RowNum
	From #clientIdTbl
	)
	Delete From clientIdCTE Where RowNum > 1;
	IF @debug & 4 = 4
	SELECT *, 'PermittedClient' PermittedClient FROM #clientIdTbl
	;WITH CTEResult
	AS
	(
		SELECT CL.id as ClientId , CL.name as ClientName, CI.allAssetsFlag,
		ISNULL(CI.UserGUID, '') UserGuid, ISNULL(U.id, 0) UserId, ISNULL(U.login,'') LoginUserName,
		ISNULL(UG.id, 0) groupId, ISNULL(UG.name, '') GroupName,
		ISNULL(UDG.id,0) userGrpId, ISNULL(UDG.name, '') as ExternalGroupName
		FROM #clientIdTbl TC
		JOIN APP_CLIENT CL WITH(NOLOCK) ON TC.id = CL.id
		JOIN @ownersTable UA ON TC.id = UA.clientId
		LEFT JOIN UMUsers U WITH(NOLOCK) ON UA.userid = U.id
		LEFT JOIN UMGroups UG WITH(NOLOCK) ON UA.usergroupId = UG.id
		LEFT JOIN UMDSGroups UDG WITH(NOLOCK) ON UA.externalGroupId = UDG.id
		JOIN #custodianInfo CI ON U.UserGuid = CI.userGUID OR UG.id = CI.groupId OR UDG.id = CI.userGrpId -- allow rows to be fetched from all left join tables which-ever matches (user/group/external-group)
	)
	INSERT INTO #FinalUserAssetInfo (ClientId,ClientName,allAssetsFlag,UserGuid,UserId,LoginUserName,
		groupId,GroupName,userGrpId,ExternalGroupName)
	SELECT ClientId,ClientName,allAssetsFlag,UserGuid,UserId,LoginUserName,
		groupId,GroupName,userGrpId,ExternalGroupName FROM CTEResult
	-- Delete Case Manager clients
	DELETE UAI
	FROM #FinalUserAssetInfo UAI
	WHERE UAI.ClientId IN (SELECT componentNameId FROM App_ClientProp WITH (NOLOCK) WHERE attrName = 'Case Manager Pseudo Client' AND attrVal = '1')
	UPDATE T
	SET SelectedStatus =
					CASE WHEN allAssetsFlag = 1 THEN 1 ELSE
					(
						ISNULL((
							SELECT TOP 1 (CASE WHEN ISNULL(isSelected,0) > 0 THEN 1 ELSE 0 END) SelectedStatus FROM #custodianAssetInfo CAI
							WHERE CAI.clientId = T.ClientId AND ((CAI.UserGuid = T.UserGuid AND ISNULL(CAI.UserGuid,'') <> '') OR
							(CAI.groupId = T.groupId AND T.groupId > 0) OR (CAI.userGrpId = T.userGrpId AND T.userGrpId > 0))
						), 0)
					) END
	FROM #FinalUserAssetInfo T
	IF @debug & 2 = 2
	SELECT * FROM #FinalUserAssetInfo
	ORDER BY UserGuid
	IF ISNULL(@GetUserClientRelationPerCase,0) = 1
	BEGIN
		SELECT
		(
		SELECT C.allAssetsFlag '@allAssets',
		(
			SELECT C.userGUID '@userGUID',
			CASE WHEN ISNULL(C.userGrpId, 0) > 0 THEN C.userGrpId ELSE NULL END '@groupId',
			CASE WHEN ISNULL(C.groupId, 0) > 0 THEN C.groupId ELSE NULL END '@userGroupId',
			CASE WHEN ISNULL(C.userGUID,'') <> '' THEN @EntityType_USER_ENTITY
			WHEN ISNULL(C.userGrpId,0) > 0 THEN @EntityType_EXTERNAL_GROUP_ENTITY
			WHEN ISNULL(C.groupId,0) > 0 THEN @EntityType_USERGROUP_ENTITY END '@_type_'
			FOR XML PATH('userOrGroup'), TYPE
		),
		(
			SELECT ISNULL(CL.ClientId, 0) '@clientId', ISNULL(CL.ClientName, '') '@clientName',
				(
					SELECT SelectedStatus AS '@include'
					FOR XML PATH('flags'), TYPE
				)
			FROM #FinalUserAssetInfo CL
			WHERE (CL.UserGuid = C.UserGuid AND ISNULL(CL.UserGuid,'') <> '') OR
			(CL.groupId = C.groupId AND C.groupId > 0) OR
			(CL.userGrpId = C.userGrpId AND C.userGrpId > 0)
			ORDER BY 2
			FOR XML PATH('galaxyEntity'), TYPE
		)
		FROM #custodianInfo C
		FOR XML PATH('userAssets'), TYPE
		)
		FOR XML PATH('DM2ContentIndexing_CaseInfo')
	END
	ELSE
	BEGIN
		IF object_id('tempdb.dbo.#userClientIdTbl') IS NULL
		BEGIN
			SELECT DISTINCT ClientId id FROM #FinalUserAssetInfo WHERE ISNULL(SelectedStatus, 0) = 1
		END
		ELSE
		BEGIN
			EXEC
			('
			INSERT INTO #userClientIdTbl
			SELECT DISTINCT ClientId, 0, 4 FROM #FinalUserAssetInfo WHERE ISNULL(SelectedStatus, 0) = 1
			')
		END
	END
	DROP TABLE #custodianInfo
	DROP TABLE #custodianAssetInfo
	DROP TABLE #userIdTbl
	DROP TABLE #userGrpTbl
	DROP TABLE #externalGrpTbl
	DROP TABLE #supportedAgents
	SET NOCOUNT OFF
END
GO

IF EXISTS (select * from GxQscripts where name = 'DM2GetAllCaseClients')
	delete from GxQscripts where name = 'DM2GetAllCaseClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetAllCaseClients')
	delete from GXDBVersions where aliasname = 'DM2GetAllCaseClients'
GO

insert into GXDBVersions values(2, 'DM2GetAllCaseClients',  '00010006000200030000', 'DM2GetAllCaseClients', '00010006000200030000')
GO

