

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2GetAllAnalyticsEngine.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DM2GetAllAnalyticsEngine <<<'

IF EXISTS (select * from sysobjects where name='DM2GetAllAnalyticsEngine')
	drop procedure DM2GetAllAnalyticsEngine
IF EXISTS (select * from GxQscripts where name='DM2GetAllAnalyticsEngine')
	delete from GxQscripts where name = 'DM2GetAllAnalyticsEngine'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetAllAnalyticsEngine')
	delete from GXDBVersions where aliasname = 'DM2GetAllAnalyticsEngine'
GO
print '... Creating Procedure: DM2GetAllAnalyticsEngine'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DM2GetAllAnalyticsEngine
  @i_Type VARCHAR(128)= NULL,
  @i_userId INT =0,
  @i_permissionId INT =0
AS
  DECLARE @o_serverName NVARCHAR(512)
  DECLARE @o_clientId INT
  DECLARE @o_clientName NVARCHAR(256)
  DECLARE @o_cloudId INT
  DECLARE @o_hostName NVARCHAR(256)
  DECLARE @o_basePort INT
  DECLARE @o_version VARCHAR(32)
  DECLARE @o_engineName NVARCHAR(256)
  DECLARE @o_serverType INT
  DECLARE @o_indexServerClientId INT
  DECLARE @o_cloudInternalName NVARCHAR(256)
-- By default return ALL MAs (analytics engine)
DECLARE @permissionId INT =0
DECLARE @allIndexServers INT =0
IF OBJECT_ID('tempdb.dbo.#secClientList') IS NOT NULL  DROP TABLE #secClientList
	 CREATE TABLE #secClientList (pseudoClientId INT)
IF @i_permissionId <> 0
	SET @permissionId = @i_permissionId
ELSE IF (ISNULL(@i_Type,'') <> '')
BEGIN
	IF @i_Type = 'Web Analytics'
SET @permissionId = 136
	ELSE IF @i_Type = 'Data Analytics'
SET @permissionId= 137
END
--check for permission CAT_ANALYTICS_SEA / CAT_ANALYTICS_WEB / i_permissionId  on pseudoClient	if userId>0
--
IF( @i_userId > 0 AND @permissionId > 0)
BEGIN
	--get all associated client list
EXEC sec_getNonIdaObjectsForThisUser @i_userId, 3, @permissionId, '#secClientList'
END
ELSE
BEGIN
	--all index servers
	SET @allIndexServers = 1
END
--get index servers
 IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
		CREATE TABLE #getIndexServers
            (     serverURL NVARCHAR(512),
                  clientId INT,
                  clientName NVARCHAR(256),
                  cloudId INT,
                  hostName NVARCHAR(256),
                  basePort INT,
                  engineName  NVARCHAR(256),
                  serverType INT,
                  indexServerClientId INT,
                  internalCloudName NVARCHAR(256)
            )
EXEC DM2GetIndexServers @i_Type
SELECT S.serverURL AS 'serverName', S.clientId, S.clientName, S.cloudId, S.hostName, S.basePort, M.roleTypeVersion 'version', S.engineName, S.serverType 'cloudType', S.indexServerClientId 'indexServerClientId', S.internalCloudName 'internalCloudName'
FROM #getIndexServers S
	LEFT JOIN DM2CloudCoreRole CR WITH (NOLOCK) ON S.CloudId = CR.CloudId
    LEFT JOIN DM2CloudRoleMaster M WITH (NOLOCK) ON CR.roleId = M.roleType
	WHERE (@allIndexServers =1 OR S.indexServerClientId IN (SELECT pseudoClientId FROM #secClientList))
	AND (M.roleTypeName = @i_Type OR ISNULL(@i_Type,'') ='')
GO

IF EXISTS (select * from GxQscripts where name = 'DM2GetAllAnalyticsEngine')
	delete from GxQscripts where name = 'DM2GetAllAnalyticsEngine'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2GetAllAnalyticsEngine')
	delete from GXDBVersions where aliasname = 'DM2GetAllAnalyticsEngine'
GO

insert into GXDBVersions values(2, 'DM2GetAllAnalyticsEngine',  '00000000000000000000', 'DM2GetAllAnalyticsEngine', '00000000000000000000')
GO

