

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2EvaluateCaseGalaxyCriteria.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  DM2EvaluateCaseGalaxyCriteria()
--  | Description:  Evaluate galaxy criteria for selected case.
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DM2EvaluateCaseGalaxyCriteria.sp,v $ $Id: DM2EvaluateCaseGalaxyCriteria.sp,v 1.3.60.2 2018/03/27 08:53:15 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DM2EvaluateCaseGalaxyCriteria <<<'

IF EXISTS (select * from sysobjects where name='DM2EvaluateCaseGalaxyCriteria')
	drop procedure DM2EvaluateCaseGalaxyCriteria
IF EXISTS (select * from GxQscripts where name='DM2EvaluateCaseGalaxyCriteria')
	delete from GxQscripts where name = 'DM2EvaluateCaseGalaxyCriteria'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2EvaluateCaseGalaxyCriteria')
	delete from GXDBVersions where aliasname = 'DM2EvaluateCaseGalaxyCriteria'
GO
print '... Creating Procedure: DM2EvaluateCaseGalaxyCriteria'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DM2EvaluateCaseGalaxyCriteria
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS
-- i_xmlText --> XML of type CvAdvancedSearchGroup which contains caseFilter
-- i_AppTypeXML --> XML of type DataServiceResp that contains listOfAppTypes
-- debug --> Pass 1 only for troubleshooting.
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_xmlText XML,
  @i_AppTypeXML XML,
  @debug INT = 0
AS
BEGIN
	DECLARE @caseXML				XML
	DECLARE @caseId					INT
	DECLARE @SearchByAppType		INT
	DECLARE @AllClientCondition		INT
	Declare @LocCount				INT
	DECLARE @isDataCopyEnabled				INT
	--Define temp tables required
	IF object_id('tempdb.dbo.#RefCopyAgentMapping') IS NOT NULL
	DROP TABLE #RefCopyAgentMapping
	CREATE TABLE #RefCopyAgentMapping (RefAppTypeId int, ActualAppTypeId int)
	if object_id('tempdb.dbo.#ClientAppTypes') IS NOT NULL
	DROP TABLE #ClientAppTypes
	CREATE TABLE #ClientAppTypes
	(
		clientId int,
		appTypeId int
	)
	--Populate necessary temp tables and capture necessary input data into variables as needed..
	insert into #RefCopyAgentMapping(ActualAppTypeId, RefAppTypeId)
	values (11, 33), (33, 33), (34, 33), (42, 33), (43, 33), (1, 33), (54, 54), (17, 29), (18, 29), (19, 29), (20, 29), (21, 29), (29, 29), (36, 29), (38, 29), (63, 29), (64, 29), (74, 29), (67, 67)
	SELECT @SearchByAppType = G.ref.value('@applicationType', 'int')
	FROM @i_xmlText.nodes('(/DM2ContentIndexing_CvAdvancedSearchGroup/galaxyFilter)[1]') G(ref)
	SELECT @AllClientCondition = @i_xmlText.exist('/DM2ContentIndexing_CvAdvancedSearchGroup/galaxyFilter/clients[@clientId = ("0")]')
	if @debug = 1
		PRINT 'ALL='+ CONVERT(VARCHAR, @ALLClientCondition) + ', SearchAppType= ' + CONVERT(VARCHAR, @SearchByAppType)
	IF object_id('tempdb.dbo.#userClientIdTbl') IS NOT NULL
	DROP TABLE #userClientIdTbl
	CREATE TABLE #userClientIdTbl (id integer, appId integer, holdType integer)
	IF object_id('tempdb.dbo.#CaseSupportedAgents') IS NOT NULL
	DROP TABLE #CaseSupportedAgents
	CREATE TABLE #CaseSupportedAgents(appTypeId int)
	IF object_id('tempdb.dbo.#AppTypeTbl') IS NOT NULL
	DROP TABLE #AppTypeTbl
	CREATE TABLE #AppTypeTbl ( AppTypeId integer, IsEmailAppType integer, IsFileAppType integer, GroupName varchar(128))
	insert into #AppTypeTbl
	SELECT A.ref.value('@appTypeId', 'int') AppTypeId,
	A.ref.value('@isEmailAppType', 'int') isEmailAppType,
	A.ref.value('@isFileAppType', 'int') isFileAppType,
	A.ref.value('@groupNameResourceKey', 'varchar(128)')
	FROM @i_AppTypeXML.nodes('/DM2ContentIndexing_DataServiceResp/listOfAppTypes') A(ref)
	-- Capture which caseId and case XML
	SELECT @caseId = T.ref.value('@caseId', 'int') FROM  @i_xmlText.nodes('(/DM2ContentIndexing_CvAdvancedSearchGroup/caseList)[1]') T(ref)
	SELECT @caseXML = CaseXML FROM DM2CaseInfo WHERE CaseId = @caseId
	SELECT @isDataCopyEnabled = T.ref.value('@enableDataCopy', 'INT') from @caseXML.nodes('/DM2ContentIndexing_CaseInfo') T(ref)
	-- We need to know what app type exist in the case so that we will not search un-necessary app type data
	insert into #CaseSupportedAgents
	select T.ref.value('@applicationId','int') from @caseXML.nodes('/DM2ContentIndexing_CaseInfo/supportedAgents') T(ref)
	IF @debug = 1
	BEGIN
		PRINT 'Case id: ' + CONVERT(VARCHAR(10), @caseId)
		SELECT *, 'CaseSupportedAgents' CaseAgents FROM #CaseSupportedAgents
		SELECT *, 'RefCopyAgentMapping' RefCopyAgentMapping FROM #RefCopyAgentMapping
	END
	IF ISNULL(@isDataCopyEnabled, 0) = 0
	BEGIN
		--Execute stored procedure for in-line reference copy and get list of clients on which to do the search.
		exec dbo.DM2GetAllCaseClients NULL, @caseId
		IF @debug = 1
			PRINT 'This is inline reference copy condition'
	END
	ELSE
	BEGIN
		INSERT INTO #userClientIdTbl(id)
		SELECT RefCopyClientId FROM DM2CaseInfo
		WHERE CaseId = @caseId
		IF @debug = 1
			PRINT 'This is actual reference copy condition'
	END
	if @debug = 1
	BEGIN
		SELECT @LocCount = ISNULL((SELECT COUNT(*) FROM #userClientIdTbl), 0)
		PRINT 'Case client count is ' + convert(varchar(10), @LocCount) + ' for case # ' + CONVERT(VARCHAR(10), isnull(@caseId,0)) + 'and all client condition value = ' + convert(varchar(10),@AllClientCondition)
		SELECT DISTINCT id FROM #userClientIdTbl
	END
	IF @AllClientCondition = 1
	BEGIN
		INSERT INTO #ClientAppTypes
		SELECT T.Id as clientId, AT.appTypeId as appTypeId
		FROM #userClientIdTbl T
		CROSS APPLY #CaseSupportedAgents CSA
		JOIN #RefCopyAgentMapping RT ON CSA.AppTypeId = RT.RefAppTypeId
		JOIN #AppTypeTbl AT ON RT.ActualAppTypeId = AT.AppTypeId
		WHERE AT.IsEmailAppType = (CASE WHEN @SearchByAppType in (0, 3) THEN 1 ELSE 0 END) OR AT.IsFileAppType = (CASE WHEN @SearchByAppType IN (0, 4) THEN 1 ELSE 0 END)
		if @debug = 1
			PRINT 'All client condition. Intersecting app type and client, found rows # ' + convert(varchar(10), @@rowcount)
	END
	ELSE
	BEGIN
		--Intersect case (ref copy) client and app types with requested client and app-type group
		;WITH ClientAndAppTypeGroup
		AS
		(
		SELECT AP.ref.value('@val', 'varchar(128)') ReqAppTypeGroup, AP.ref.value('../@clientId', 'int') ClientId
		FROM @i_xmlText.nodes('DM2ContentIndexing_CvAdvancedSearchGroup/galaxyFilter/clients/appTypeGroups') AP(ref)
		)
		insert into #ClientAppTypes
		SELECT T.id as clientId, AT.AppTypeId as appTypeId
		FROM #userClientIdTbl T
		INNER JOIN ClientAndAppTypeGroup G ON T.id = G.ClientId
		INNER JOIN #AppTypeTbl AT ON G.ReqAppTypeGroup = AT.GroupName
		INNER JOIN #RefCopyAgentMapping RT ON AT.AppTypeId = RT.ActualAppTypeId
		INNER JOIN #CaseSupportedAgents CSA ON RT.RefAppTypeId = CSA.appTypeId
		if @debug = 1
			PRINT 'Intersecting app type and client count, found rows # ' + convert(varchar(10), @@rowcount)
	END
	--Return final Galaxy Filter object with clients and app types..
	SELECT 0 '@ccn', 0 '@searchByAppTypeGroupNames',  @SearchByAppType '@applicationType',
	(
	SELECT clientId '@clientId', ISNULL((SELECT TOP 1 name FROM APP_CLIENT CLI WITH(NOLOCK) WHERE CLI.id = C.clientId), '') '@clientName',
	(
		SELECT AT.appTypeId '@val' FROM #ClientAppTypes AT
		WHERE AT.clientId = C.clientId
		GROUP BY AT.appTypeId
		FOR XML PATH('appTypeGroups'), TYPE
	)
	FROM #ClientAppTypes C
	GROUP BY c.clientId
	FOR XML PATH('clients'), TYPE
	)
	FOR XML PATH('DM2ContentIndexing_CVGalaxySecurityGroup')
END

IF EXISTS (select * from GxQscripts where name = 'DM2EvaluateCaseGalaxyCriteria')
	delete from GxQscripts where name = 'DM2EvaluateCaseGalaxyCriteria'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2EvaluateCaseGalaxyCriteria')
	delete from GXDBVersions where aliasname = 'DM2EvaluateCaseGalaxyCriteria'
GO

insert into GXDBVersions values(2, 'DM2EvaluateCaseGalaxyCriteria',  '00010003006000020000', 'DM2EvaluateCaseGalaxyCriteria', '00010003006000020000')
GO

