

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2DiscoverClientsForCaseUser.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  DM2DiscoverClientsForCaseUser()
--  | Description:  Get owned clients for given user and list of exchange clients in CommCell.
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DM2DiscoverClientsForCaseUser.sp,v $ $Id: DM2DiscoverClientsForCaseUser.sp,v 1.3.72.1 2018/03/27 08:56:00 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DM2DiscoverClientsForCaseUser <<<'

IF EXISTS (select * from sysobjects where name='DM2DiscoverClientsForCaseUser')
	drop procedure DM2DiscoverClientsForCaseUser
IF EXISTS (select * from GxQscripts where name='DM2DiscoverClientsForCaseUser')
	delete from GxQscripts where name = 'DM2DiscoverClientsForCaseUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2DiscoverClientsForCaseUser')
	delete from GXDBVersions where aliasname = 'DM2DiscoverClientsForCaseUser'
GO
print '... Creating Procedure: DM2DiscoverClientsForCaseUser'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DM2DiscoverClientsForCaseUser
  @i_xmlText XML 
AS
BEGIN
	IF object_id('tempdb.dbo.#userClientIdTbl') IS NOT NULL
	DROP TABLE #userClientIdTbl
	CREATE TABLE #userClientIdTbl ( id integer)
	exec PopulateCaseManagerAssociations 0, @i_xmlText
	;WITH ClientCTE
	AS
	(
		SELECT DISTINCT ua.Id clientId, c.name AS clientName, 'Files' as dataType, 'Laptop' as assetType
		FROM #userClientIdTbl ua
		JOIN APP_Client C ON ua.id = c.id
	)
	SELECT dataType '@dataType', assetType '@assetType',
	(
		select clientId '@clientId', clientName '@clientName' FROM ClientCTE cc where cc.clientId = c.clientId
		FOR XML PATH('galaxyEntity'), TYPE
	)
	FROM ClientCTE c
	ORDER BY dataType, clientName
	FOR XML PATH('caseClients'), ROOT('DM2ContentIndexing_CaseClientEntities')
END
GO

IF EXISTS (select * from GxQscripts where name = 'DM2DiscoverClientsForCaseUser')
	delete from GxQscripts where name = 'DM2DiscoverClientsForCaseUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2DiscoverClientsForCaseUser')
	delete from GXDBVersions where aliasname = 'DM2DiscoverClientsForCaseUser'
GO

insert into GXDBVersions values(2, 'DM2DiscoverClientsForCaseUser',  '00010003007200010000', 'DM2DiscoverClientsForCaseUser', '00010003007200010000')
GO

