

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2DetermineCaseClientSharing.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  DM2DetermineCaseClientSharing()
--  | Description:  Evaluate users or groups to be deleted and/or added depending upon reviewers modification on given case
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DM2DetermineCaseClientSharing.sp,v $ $Id: DM2DetermineCaseClientSharing.sp,v 1.1.2.3 2018/03/27 08:58:44 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DM2DetermineCaseClientSharing <<<'

IF EXISTS (select * from sysobjects where name='DM2DetermineCaseClientSharing')
	drop procedure DM2DetermineCaseClientSharing
IF EXISTS (select * from GxQscripts where name='DM2DetermineCaseClientSharing')
	delete from GxQscripts where name = 'DM2DetermineCaseClientSharing'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2DetermineCaseClientSharing')
	delete from GXDBVersions where aliasname = 'DM2DetermineCaseClientSharing'
GO
print '... Creating Procedure: DM2DetermineCaseClientSharing'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DM2DetermineCaseClientSharing
  @i_CaseId INT,
  @i_CaseXML XML,
  @o_CaseName NVARCHAR(255) OUTPUT
AS
BEGIN
DECLARE @ex_CaseXML XML
DECLARE @DeleteIt INT = POWER(2, 3-1)   -- OperationType.DELETE = 3
DECLARE @AddIt INT = POWER(2, 1-1)		-- OperationType.ADD = 1
SELECT @ex_CaseXML = CaseXML, @o_CaseName = CaseName FROM DM2CaseInfo WITH(NOLOCK) WHERE CaseId = @i_CaseId
;WITH CTE
AS
(
SELECT
(Case
When Old.Name Is Not Null AND new.Name Is Null then @DeleteIt
When Old.Name Is null and new.Name Is Not Null then @AddIt
end) ownersOperationTypes,
COALESCE(Old.Name, New.Name, '') Name,
ISNULL(New.capabilities, 0) capabilities,
COALESCE(Old.Id, New.Id, 0) Id,
COALESCE(Old.EntityType, New.EntityType, 0) EntityType
FROM
(
SELECT U.ref.value('@userId', 'int') Id, U.ref.value('@userGUID', 'varchar(255)') [Guid], U.ref.value('@userName', 'nvarchar(255)') Name, U.ref.value('@_type_', 'int') EntityType,
ISNULL(U.ref.value('../@capabilities', 'int'), 0) capabilities
FROM @i_CaseXML.nodes('//casePartakers/user') U(ref)
UNION
SELECT G.ref.value('@userGroupId', 'int') Id, '' [Guid], G.ref.value('@userGroupName', 'nvarchar(512)') Name, G.ref.value('@_type_', 'int') EntityType,
ISNULL(G.ref.value('../@capabilities', 'int'), 0) capabilities
FROM @i_CaseXML.nodes('//casePartakers/group') G(ref)
) New
FULL OUTER JOIN
(
SELECT U.ref.value('@userId', 'int') Id, U.ref.value('@userGUID', 'varchar(255)') [Guid], U.ref.value('@userName', 'nvarchar(255)') Name, U.ref.value('@_type_', 'int') EntityType,
ISNULL(U.ref.value('../@capabilities', 'int'), 0) capabilities
FROM @ex_CaseXML.nodes('//casePartakers/user') U(ref)
UNION
SELECT G.ref.value('@userGroupId', 'int') Id, '' [Guid], G.ref.value('@userGroupName', 'nvarchar(512)') Name, G.ref.value('@_type_', 'int') EntityType,
ISNULL(G.ref.value('../@capabilities', 'int'), 0) capabilities
FROM @ex_CaseXML.nodes('//casePartakers/group') G(ref)
) Old ON New.EntityType = Old.EntityType AND New.Name = Old.Name
)
SELECT * FROM CTE
WHERE ownersOperationTypes IS NOT NULL
END
GO

IF EXISTS (select * from GxQscripts where name = 'DM2DetermineCaseClientSharing')
	delete from GxQscripts where name = 'DM2DetermineCaseClientSharing'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2DetermineCaseClientSharing')
	delete from GXDBVersions where aliasname = 'DM2DetermineCaseClientSharing'
GO

insert into GXDBVersions values(2, 'DM2DetermineCaseClientSharing',  '00010001000200030000', 'DM2DetermineCaseClientSharing', '00010001000200030000')
GO

