

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2DetectClientAndSecurityChanges.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  DM2DetectClientAndSecurityChanges()
--  | Description:  Detects if any changes made to galaxy security or any change in count of clients (content indexed)
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DM2DetectClientAndSecurityChanges.sp,v $ $Id: DM2DetectClientAndSecurityChanges.sp,v 1.2.86.2 2020/12/21 14:43:07 jswaminathan Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='DM2DetectClientAndSecurityChanges')
BEGIN
	print '>>> Drop Stored Procedure: DM2DetectClientAndSecurityChanges <<<'
	drop procedure DM2DetectClientAndSecurityChanges
END
IF EXISTS (select * from GxQscripts where name='DM2DetectClientAndSecurityChanges')
	delete from GxQscripts where name = 'DM2DetectClientAndSecurityChanges'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2DetectClientAndSecurityChanges')
	delete from GXDBVersions where aliasname = 'DM2DetectClientAndSecurityChanges'
GO
print '... Creating Procedure: DM2DetectClientAndSecurityChanges'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure DM2DetectClientAndSecurityChanges
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_UnixDateTimeStart INT,
  @i_ClientCount INT,
  @i_MaxClientId INT,
  @i_SubClientCount INT,
  @i_MaxSubClientId INT
AS
BEGIN
	SET NOCOUNT ON
	DECLARE @o_DBDateTimeValue INT
	DECLARE @o_ReturnValue INT
	DECLARE @o_DBClientCount INT
	DECLARE @o_DBMaxClientId INT
	DECLARE @o_DBSubClientCount INT
	DECLARE @o_DBMaxSubClientId INT
	SELECT @o_ReturnValue = 0
	--check max client id changed
	SELECT @o_DBMaxClientId = MAX(ID), @o_DBClientCount = COUNT(*) FROM APP_Client A WITH(NOLOCK)
	WHERE EXISTS (SELECT ComponentNameId FROM APP_ClientProp P  WITH(NOLOCK) WHERE P.attrName = 'Content Indexing Enabled' AND P.attrVal = '1' AND modified = 0 AND P.componentNameId = A.id)
	IF @i_ClientCount <> @o_DBClientCount
	BEGIN
		SET @o_ReturnValue = 1
	END
	IF @o_DBMaxClientId <> @i_MaxClientId
	BEGIN
		SET @o_ReturnValue = @o_ReturnValue | 2
	END
	IF ISNULL(@o_DBDateTimeValue,0) > 0
	BEGIN
		SET @o_ReturnValue = @o_ReturnValue | 4
	END
	SELECT @o_DBMaxSubClientId = MAX(A.id), @o_DBSubClientCount = COUNT(A.id) FROM APP_Application A WITH(NOLOCK)
	WHERE EXISTS (SELECT ComponentNameId FROM APP_ClientProp P  WITH(NOLOCK) WHERE P.attrName = 'Content Indexing Enabled' AND P.attrVal = '1' AND modified = 0 AND P.componentNameId = A.clientId)
	IF @i_SubClientCount <> @o_DBSubClientCount
	BEGIN
		SET @o_ReturnValue = @o_ReturnValue | 8
	END
	IF @i_MaxSubClientId <> @o_DBMaxSubClientId
	BEGIN
		SET @o_ReturnValue = @o_ReturnValue | 16
	END
	SELECT @o_ReturnValue AS ReturnValue, @o_DBDateTimeValue as UpdatedDateTimeValue, @o_DBClientCount as CIClientCount, @o_DBMaxClientId as MaxClientId,
	@o_DBSubClientCount AS CISubClientCount, @o_DBMaxSubClientId AS MaxSubClientId
END
GO

IF EXISTS (select * from GxQscripts where name = 'DM2DetectClientAndSecurityChanges')
	delete from GxQscripts where name = 'DM2DetectClientAndSecurityChanges'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2DetectClientAndSecurityChanges')
	delete from GXDBVersions where aliasname = 'DM2DetectClientAndSecurityChanges'
GO

insert into GXDBVersions values(2, 'DM2DetectClientAndSecurityChanges',  '00010002008600020000', 'DM2DetectClientAndSecurityChanges', '00010002008600020000')
GO

