

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2DeleteSearchServerCoreInfo.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  DM2DeleteSearchServerCoreInfo
--  | Description: Remove new Search Server Core
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DM2DeleteSearchServerCoreInfo.sp,v $ $Id: DM2DeleteSearchServerCoreInfo.sp,v 1.2.88.2 2018/03/22 03:00:39 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DM2DeleteSearchServerCoreInfo <<<'

IF EXISTS (select * from sysobjects where name='DM2DeleteSearchServerCoreInfo')
	drop procedure DM2DeleteSearchServerCoreInfo
IF EXISTS (select * from GxQscripts where name='DM2DeleteSearchServerCoreInfo')
	delete from GxQscripts where name = 'DM2DeleteSearchServerCoreInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2DeleteSearchServerCoreInfo')
	delete from GXDBVersions where aliasname = 'DM2DeleteSearchServerCoreInfo'
GO
print '... Creating Procedure: DM2DeleteSearchServerCoreInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure DM2DeleteSearchServerCoreInfo
  @i_CoreId integer
AS
  DECLARE @o_errorCode INT = 0;
  DECLARE @o_errorString NVARCHAR(MAX) = 'Search Server Core Delete Successfully for ID [' + CAST(@i_CoreId as varchar(10)) + ']';
SET NOCOUNT ON
	DECLARE @CloudId		INTEGER
	DECLARE @CommCellId		INTEGER
	DECLARE @CoreRoles		INTEGER
	SELECT	@CloudId = ISNULL(CloudId, 0),
			@CommCellId = ISNULL(CommCellId, 2),
			@CoreRoles = ISNULL(CoreRoles, 0)
	FROM	DM2SearchServerCoreInfo WITH (READUNCOMMITTED)
	WHERE	CoreId = @i_CoreId
	IF @CloudId IS NULL OR @CloudId = 0
	BEGIN
		SET @o_errorCode = 1
		SET @o_errorString = 'Failed to find Search Server Core in database for id [' + CAST(@i_CoreId as varchar(10)) + ']'
		GOTO EXIT_AND_RETURN
	END
	-- Make sure there is only one admin core for each cloud
IF @CoreRoles & 4 > 0
	BEGIN
		UPDATE	DM2SearchServerCoreInfo
SET		CoreRoles = CoreRoles | 4
		WHERE	CoreID = (
							SELECT
								TOP 1 CoreId
							FROM
								DM2SearchServerCoreInfo WITH (READUNCOMMITTED)
							WHERE
								CoreId != @i_CoreId
								AND	CloudId = @CloudId
								AND	CommCellId = @CommCellId
AND ((CoreRoles & 8 = 8) OR (CoreRoles & 16 = 16))
							ORDER BY
								CollectionSize DESC, OccupiedSpace DESC, FreeSpace
						)
	END
	DELETE FROM DM2SearchServerCoreInfo WHERE CoreId = @i_CoreId
	SELECT @o_errorCode = @@ERROR
	IF @o_errorCode != 0
	BEGIN
		SET @o_errorString = 'Failed to delete Search Server Core due to database error [' + CAST(@o_errorCode as varchar(10)) + ']'
		GOTO EXIT_AND_RETURN
	END
EXIT_AND_RETURN:
	SELECT @o_errorCode, @o_errorString
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'DM2DeleteSearchServerCoreInfo')
	delete from GxQscripts where name = 'DM2DeleteSearchServerCoreInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2DeleteSearchServerCoreInfo')
	delete from GXDBVersions where aliasname = 'DM2DeleteSearchServerCoreInfo'
GO

insert into GXDBVersions values(2, 'DM2DeleteSearchServerCoreInfo',  '00010002008800020000', 'DM2DeleteSearchServerCoreInfo', '00010002008800020000')
GO

