

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2CreatePreviewEngine.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  DM2CreatePreviewEngine
--  | Description:   Creates/ delete entries in DM2SearchServerCodeInfo, DM2Cloud
--  |                and DM2CloudCoreRole tables based on i_opType
--  |
--  | Input:
--  |			i_optype : CV_ANALYTICS_ROLE_CONFIG	- Configure analytics cloud
--  |					   CV_ANALYTICS_ROLE_DECONFIG - Deconfigure analytics cloud
--  |			i_clientId: clientId on which Analytics engine is configured or deconfigured
--  |			i_dataLocation: analytics index path
--  |			i_previewMemoryMB: jvm memory for preview engine
--  |			i_portNo: port no for preview engine
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DM2CreatePreviewEngine.sp,v $ $Id: DM2CreatePreviewEngine.sp,v 1.1.2.7 2020/08/24 15:17:54 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='DM2CreatePreviewEngine')
BEGIN
	print '>>> Drop Stored Procedure: DM2CreatePreviewEngine <<<'
	drop procedure DM2CreatePreviewEngine
END
IF EXISTS (select * from GxQscripts where name='DM2CreatePreviewEngine')
	delete from GxQscripts where name = 'DM2CreatePreviewEngine'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2CreatePreviewEngine')
	delete from GXDBVersions where aliasname = 'DM2CreatePreviewEngine'
GO
print '... Creating Procedure: DM2CreatePreviewEngine'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure DM2CreatePreviewEngine
  @i_opType integer = 1,
  @i_clientId integer,
  @i_dataLocation nvarchar(max),
  @i_previewMemoryMB integer = 4096,
  @i_portNo integer = 22000
AS
  DECLARE @o_errorCode integer = 0
  DECLARE @o_errorStr varchar(max) = 'Success'
  DECLARE @o_coreId integer = 0
-- check validity of the client
if (@i_clientId < 1 or not exists(select * from APP_Client WITH (NOLOCK) where id = @i_clientId))
begin
	set @o_errorStr = 'Invalid clientId'
	set @o_errorCode = 10412 -- validation error
	goto errorexit
end
declare @installTime int = dbo.GetUnixTime(GETDATE())
--
begin transaction
IF @i_opType = 1  --CV__ANALYTICS_ROLE_CONFIG
	BEGIN
		IF NOT EXISTS (SELECT * FROM APP_ClientProp (NOLOCK) WHERE componentNameId = @i_clientId AND attrName = 'contentPreviewEngineEnabled' AND attrval = '1')
		BEGIN
			-- add the client properties
			insert into APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
			values (@i_clientId, N'contentPreviewEngineEnabled', 2 /*PROPERTY_BOOLEAN*/, N'1', @installTime, 0, 0),
				   (@i_clientId, N'ContentPreviewTempOutputDir', 1 /*PROPERTY_STRING*/, @i_dataLocation, @installTime, 0, 0),
				   (@i_clientId, N'contentPreviewMaxJvm', 7 /*PROPERTY_INTEGER*/, cast(@i_previewMemoryMB as nvarchar(10)) , @installTime, 0, 0),
				   (@i_clientId, N'contentPreviewPort', 1 /*PROPERTY_STRING*/, cast(@i_portNo as nvarchar(10)), @installTime, 0, 0)
			set @o_errorCode = @@ERROR
			if (@o_errorCode <> 0) begin
				set @o_errorStr = 'Error inserting client properties'
				goto errorexit
			end
		END
	END
ELSE IF @i_opType = 2  --CV__ANALYTICS_ROLE_DECONFIG
	BEGIN
		DELETE FROM APP_ClientProp WHERE componentNameId = @i_clientId AND modified = 0
		AND ( attrname IN ( N'contentPreviewURL', N'contentPreviewEngineEnabled', N'ContentPreviewTempOutputDir', N'contentPreviewMaxJvm', N'contentPreviewPort'))
	END
errorexit:
	if @o_errorCode <> 0 AND @o_errorCode <> 10417 begin
		if @@TRANCOUNT > 0 rollback transaction
	end
	else begin
		if @@TRANCOUNT > 0 commit transaction
	end
	select @o_errorCode, @o_errorStr, @o_coreId
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'DM2CreatePreviewEngine')
	delete from GxQscripts where name = 'DM2CreatePreviewEngine'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2CreatePreviewEngine')
	delete from GXDBVersions where aliasname = 'DM2CreatePreviewEngine'
GO

insert into GXDBVersions values(2, 'DM2CreatePreviewEngine',  '00010001000200070000', 'DM2CreatePreviewEngine', '00010001000200070000')
GO

