

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2CreatePreviewCloud.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  DM2CreatePreviewCloud
--  | Description:   Creates/ delete entries in DM2SearchServerCodeInfo, DM2Cloud
--  |                and DM2CloudCoreRole tables based on i_opType
--  |
--  | Input:
--  |			i_optype : CV_ANALYTICS_ROLE_CONFIG	- Configure analytics cloud
--  |					   CV_ANALYTICS_ROLE_DECONFIG - Deconfigure analytics cloud
--  |			i_clientId: clientId on which Analytics engine is configured or deconfigured
--  |			i_dataLocation: analytics index path
--  |			i_previewMemoryMB: jvm memory for preview engine
--  |			i_portNo: port no for preview engine
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DM2CreatePreviewCloud.sp,v $ $Id: DM2CreatePreviewCloud.sp,v 1.1.2.15 2020/08/24 15:16:09 sjohnson Exp $";
SET ANSI_NULLS ON
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='DM2CreatePreviewCloud')
BEGIN
	print '>>> Drop Stored Procedure: DM2CreatePreviewCloud <<<'
	drop procedure DM2CreatePreviewCloud
END
IF EXISTS (select * from GxQscripts where name='DM2CreatePreviewCloud')
	delete from GxQscripts where name = 'DM2CreatePreviewCloud'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2CreatePreviewCloud')
	delete from GXDBVersions where aliasname = 'DM2CreatePreviewCloud'
GO
print '... Creating Procedure: DM2CreatePreviewCloud'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure DM2CreatePreviewCloud
  @i_opType integer = 1,
  @i_clientId integer,
  @i_cloudName nvarchar(max),
  @i_dataLocation nvarchar(max),
  @i_previewMemoryMB integer = 4096,
  @i_portNo integer = 22000,
  @i_psuedoClientId int = 0
AS
  DECLARE @o_errorCode integer = 0
  DECLARE @o_errorStr varchar(max) = 'Success'
  DECLARE @o_coreId integer = 0
-- check validity of the client
if (@i_clientId < 1 or not exists(select * from APP_Client WITH (NOLOCK) where id = @i_clientId))
begin
	set @o_errorStr = 'Invalid clientId'
	set @o_errorCode = 10412 -- validation error
	goto errorexit
end
DECLARE @result int
declare @installTime int = dbo.GetUnixTime(GETDATE())
DECLARE @oldPortNo INT = 0
DECLARE @reqXML XML
--
IF @i_opType = 4  --CV_ANALYTICS_ROLE_UPDATE
BEGIN
	IF NOT EXISTS (SELECT 1 FROM APP_ClientProp (NOLOCK) WHERE attrName = 'contentPreviewEngineEnabled' AND attrVal = '1' AND componentNameId = @i_clientId )
	BEGIN
		-- add the client properties
		insert into APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
		values (@i_clientId, N'contentPreviewEngineEnabled', 2 /*PROPERTY_BOOLEAN*/, N'1', @installTime, 0, 0),
				(@i_clientId, N'ContentPreviewTempOutputDir', 1 /*PROPERTY_STRING*/, @i_dataLocation, @installTime, 0, 0),
				(@i_clientId, N'contentPreviewMaxJvm', 7 /*PROPERTY_INTEGER*/, cast(@i_previewMemoryMB as nvarchar(10)) , @installTime, 0, 0),
				(@i_clientId, N'contentPreviewPort', 1 /*PROPERTY_STRING*/, cast(@i_portNo as nvarchar(10)), @installTime, 0, 0)
		set @o_errorCode = @@ERROR
		if (@o_errorCode <> 0) begin
			set @o_errorStr = 'Error inserting client properties'
			goto errorexit
		end
	END
	ELSE IF EXISTS (SELECT * FROM APP_ClientProp (NOLOCK) WHERE componentNameId = @i_clientId AND attrName IN('contentPreviewMaxJvm','contentPreviewPort','ContentPreviewTempOutputDir'))
	BEGIN
			UPDATE APP_ClientProp
			SET attrVal = cast(@i_previewMemoryMB as nvarchar(10))
			WHERE attrName = 'contentPreviewMaxJvm' AND componentNameId = @i_clientId AND modified = 0
			SELECT @oldPortNo = attrVal FROM APP_ClientProp
			WHERE attrName = 'contentPreviewPort' AND componentNameId = @i_clientId AND modified = 0
			UPDATE APP_ClientProp
			SET attrVal =  cast(@i_portNo as nvarchar(10))
			WHERE attrName = 'contentPreviewPort' AND componentNameId = @i_clientId AND modified = 0
			UPDATE APP_ClientProp
			SET attrVal =  @i_dataLocation
			WHERE attrName  = 'ContentPreviewTempOutputDir' AND componentNameId = @i_clientId AND modified = 0
			UPDATE DM2SearchServerCoreInfo
			SET portNo = @i_portNo,
				modifiedTime = @installTime
			WHERE portNo != @i_portNo AND clientId = @i_clientId AND cloudType = 2
			SELECT @reqXML = (SELECT @i_clientId AS '@caClientId',@oldPortNo AS '@oldPortNumber',@i_portNo AS '@newPortNumber' FOR XML PATH('DM2ContentIndexing_UpdateCAPortReq'), TYPE)
			EXEC UpdateCAPortInFirwallTPPM @i_xmlText = @reqXML,@i_returnResult= 0
	END
END
ELSE IF @i_opType = 1  --CV__ANALYTICS_ROLE_CONFIG
BEGIN
	declare @cloudName nvarchar(256)
	SET @cloudName = @i_cloudName
	DECLARE @commcellId INT = ISNULL ((SELECT origCCId FROM APP_Client (nolock) WHERE id = @i_clientId), 2)
	DECLARE @cloudId INT = ISNULL((SELECT cloudId FROM DM2Cloud (nolock) WHERE name = @cloudName ),0)
	-- Set DM2Cloud TABLE
	IF @cloudId = 0
	BEGIN
		INSERT INTO DM2Cloud ( commcellId, name,  flags, createTime, cloudType, displayName, status, pseudoClientId)
VALUES ( @commcellId, @cloudName, 16,  @installTime, 2, @cloudName, 1, @i_psuedoClientId)
		SET @cloudId = ISNULL((SELECT cloudId FROM DM2Cloud WHERE name = @cloudName ),0)
	END
	-- Set DM2SearchServerCoreInfo TABLE
declare @engineType int = (16 | 8)
	DECLARE @coreName nvarchar(1024)
	SET @coreName = 'Cloud_' + CAST(@CloudId as varchar(10)) + '_Client_' + CAST(@i_clientId as varchar(10)) + '_Core'
DECLARE @coreRoles INT = 8 | 16
	--ADD A NEW NODE
	IF NOT EXISTS (SELECT 1 FROM DM2SearchServerCoreInfo  (nolock) WHERE CloudId = @CloudId AND ClientId = @i_clientId )
	BEGIN
		INSERT INTO DM2SearchServerCoreInfo
		(
			CoreName, CommCellId, CloudId, ClientId,
			CreateTime,
			SoftState, Enabled,
			Attributes,
			ServiceLink, CoreRoles,
			CollectionSize, FreeSpace, OccupiedSpace,
			Description,
			skippedItems, failedItems, numFiles, numEmails, cloudType, nodeProps, portNo, status
		)
		VALUES
		(
			@coreName, @commcellId, @cloudId, @i_clientId,
			getutcdate(),
			1, 1,
			0,	'', @coreRoles,
			0, -1, 0,
			'',	0, 0, 0, 0, 2, '', @i_portNo, 1
		)
	END
declare @clientGroupId int = isnull((select top 1 componentNameId from APP_ClientGroupProp (nolock) WHERE attrName = 'Client Group Unique Id' AND attrVal = 9 AND modified=0),0)
	if @i_psuedoClientId > 0 and  @clientGroupId>0
		INSERT INTO APP_ClientGroupAssoc (clientGroupId, clientId)
		VALUES (@clientGroupId, @i_psuedoClientId)
END
ELSE IF @i_opType = 2  --CV__ANALYTICS_ROLE_DECONFIG
BEGIN
	SET @cloudId = ( SELECT TOP 1 CloudId FROM DM2Cloud (NOLOCK) WHERE pseudoClientId = @i_clientId AND cloudType = 2)  --App::CloudServerType_ContentAnalyzer = 2
	DELETE FROM DM2SearchServerCoreInfo WHERE cloudid = @cloudId AND cloudType = 2
	DELETE FROM DM2Cloud WHERE cloudId = @cloudId AND cloudType = 2
END
errorexit:
	SELECT @o_errorCode, @o_errorStr, @o_coreId
GO

IF EXISTS (select * from GxQscripts where name = 'DM2CreatePreviewCloud')
	delete from GxQscripts where name = 'DM2CreatePreviewCloud'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2CreatePreviewCloud')
	delete from GXDBVersions where aliasname = 'DM2CreatePreviewCloud'
GO

insert into GXDBVersions values(2, 'DM2CreatePreviewCloud',  '00010001000200150000', 'DM2CreatePreviewCloud', '00010001000200150000')
GO

