

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2CreateAnalyticsRoles.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  DM2CreateAnalyticsRoles
--  | Description:   Creates roles and insert entries into DM2CloudCoreRole
--  |
--  | Input:
--  |			i_maClientId: clientId on which Analytics engine is configured
--  |			i_analyticsInfoStr: multi row insert query
--  |				eg.
--  |					SELECT 1, 2, 1401969832
--  |					UNION ALL
--  |					SELECT 1, 3, 1401969832
--  |
--  |
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DM2CreateAnalyticsRoles <<<'

IF EXISTS (select * from sysobjects where name='DM2CreateAnalyticsRoles')
	drop procedure DM2CreateAnalyticsRoles
IF EXISTS (select * from GxQscripts where name='DM2CreateAnalyticsRoles')
	delete from GxQscripts where name = 'DM2CreateAnalyticsRoles'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2CreateAnalyticsRoles')
	delete from GXDBVersions where aliasname = 'DM2CreateAnalyticsRoles'
GO
print '... Creating Procedure: DM2CreateAnalyticsRoles'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure DM2CreateAnalyticsRoles
  @i_maClientId INT,
  @i_analyticsInfoStr NVARCHAR(MAX)
AS
  DECLARE @o_errorCode INT
  DECLARE @o_errorString VARCHAR(MAX)
declare @installTime int = dbo.GetUnixTime(GETDATE())
declare @hostName nvarchar(256) = (select net_hostname from  APP_Client WITH (NOLOCK) where id = @i_maClientId)
DECLARE @portNo integer = ISNULL((select top 1 cast (attrval as int) from APP_ClientProp WITH (NOLOCK) where componentnameid = @i_maClientId AND attrName = 'Analytics_baseport' and modified = 0), 20000)
DECLARE @createAnaltyicsCloud int  = 0
DECLARE @createPreviewCloud int  = 0
DECLARE @i_analyticsEngineType int = 0
declare @cloudName nvarchar(256)
-- Below statement is to check whether Lm role is changed or not.
DECLARE @oldLMClient INT = (ISNULL((SELECT TOP 1  Core.ClientId FROM DM2SearchServerCoreInfo Core WITH (NOLOCK) INNER JOIN DM2CloudCoreRole CoreRole WITH (NOLOCK)
									ON Core.CloudId = CoreRole.CloudId
									INNER JOIN APP_Client appClient ON Core.ClientId = appClient.id WHERE CoreRole.roleId = 3 AND appClient.status & 2 <> 2 ORDER BY Core.ClientId ) , 0))
-- delete existing values
DELETE CR
FROM DM2CloudCoreRole CR
	INNER JOIN DM2SearchServerCoreInfo S WITH (NOLOCK) ON CR.CloudId = S.CloudId AND S.ClientId = @i_maClientId
-- insert core roles
INSERT INTO DM2CloudCoreRole(CloudId, roleId, createTime)
EXECUTE sp_executeSql @i_analyticsInfoStr
SELECT @o_errorCode = @@ERROR
IF @o_errorCode != 0
BEGIN
	SET @o_errorString = 'Failed to insert row into DM2CloudCoreRole. Error [' + ERROR_MESSAGE() + ']'
END
DECLARE @CloudId INT = ISNULL((select top 1 S.CloudId from DM2SearchServerCoreInfo S WITH (NOLOCK) INNER JOIN DM2Cloud R WITH (NOLOCK) ON S.cloudId = R.cloudid WHERE ClientId = @i_maClientId AND R.flags &  16 = 0),0)
IF EXISTS (SELECT 1 FROM DM2CloudCoreRole WHERE roleId = 13 AND CloudId = @CloudId )
AND NOT EXISTS (SELECT 1 FROM DM2CloudCoreRole WHERE roleId IN (14) AND CloudId = @CloudId)
BEGIN
		INSERT INTO DM2CloudCoreRole(CloudId, roleId, createTime)
VALUES (@CloudId, 14, @installTime)
END
--insert roles_info
DECLARE @newRolesList VARCHAR(1024)
SELECT @newRolesList = COALESCE( @newRolesList + ',', '') + CONVERT(VARCHAR(10),roleId) from DM2CloudCoreRole where CloudId = @CloudId
IF ISNULL (@newRolesList,'') != ''
BEGIN
	DECLARE @oldRolesList NVARCHAR(1024)
	SET @oldRolesList =  ISNUll ((SELECT attrval FROM APP_ClientProp WITH (NOLOCK) WHERE componentNameId = @i_maClientId AND attrName = N'Analytics_RolesInfo'), N'')
	 IF @oldRolesList = ''
                insert into APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
                values (@i_maClientId, N'Analytics_RolesInfo', 1 /*PROPERTY_STRING*/, @newRolesList, @installTime, 0, 0)
            ELSE
			BEGIN
			-- DO NOT APPEND EXISTING ROLES
				SET @newRolesList = NULL
				SELECT @newRolesList = COALESCE( @newRolesList + ',', '') + CONVERT(VARCHAR(10),roleId) from DM2CloudCoreRole where CloudId = @CloudId AND roleId NOT IN (SELECT _ID FROM dbo.SplitIDs(@oldRolesList))
				IF ISNULL (@newRolesList,'') != ''
				BEGIN
					UPDATE APP_ClientProp
					SET attrVal = attrVal + N',' + @newRolesList
					WHERE componentNameId = @i_maClientId AND attrName = N'Analytics_RolesInfo'
				END
			END
END
DECLARE @commcellId INT = ISNULL ((SELECT origCCId FROM APP_Client WITH (NOLOCK) WHERE id = @i_maClientId), 2)
--avoid cloudId conflicts
DECLARE @cloudComponentId INT = ISNULL((SELECT MAX(cloudId) FROM DM2Cloud WITH (NOLOCK)),0)
EXECUTE AS USER = 'sqladmin_cv'
SET IDENTITY_INSERT DM2Cloud ON
--create virtual cloud only once when exchange index role is configured
IF EXISTS (SELECT 1 FROM DM2CloudCoreRole WITH (NOLOCK) WHERE roleId = 12) OR @i_analyticsEngineType = 12
BEGIN
IF NOT EXISTS (SELECT 1 FROM DM2Cloud WITH (NOLOCK) WHERE (flags & 4) > 0)
		BEGIN
			SET @cloudComponentId = @cloudComponentId + 1
IF EXISTS (SELECT * FROM APP_ComponentProp WITH (NOLOCK) WHERE componentType = 1 AND componentId = 2 AND propertyTypeId = 1 AND ID = @cloudComponentId)
				SET @cloudComponentId = @cloudComponentId + 1
			INSERT INTO DM2Cloud (cloudId, commcellId, name,  flags, createTime)
VALUES (@cloudComponentId , @commcellId, 'Mailbox Index', 4,  @installTime)  --CV_VIRTUAL_CLOUD_MAILBOXINDEX
		END
IF NOT EXISTS (SELECT 1 FROM DM2Cloud WITH (NOLOCK) WHERE (flags & 2) > 0)
		BEGIN
			SET @cloudComponentId = @cloudComponentId + 1
IF EXISTS (SELECT * FROM APP_ComponentProp WITH (NOLOCK) WHERE componentType = 1 AND componentId = 2 AND propertyTypeId = 1 AND ID = @cloudComponentId)
				SET @cloudComponentId = @cloudComponentId + 1
			INSERT INTO DM2Cloud (cloudId, commcellId, name,  flags, createTime)
VALUES (@cloudComponentId, @commcellId, 'Journal Index', 2,  @installTime)  --CV_VIRTUAL_CLOUD_JOURNALINDEX
		END
END
IF @createAnaltyicsCloud = 1
BEGIN
	SET @cloudComponentId = @cloudComponentId + 1
IF EXISTS (SELECT * FROM APP_ComponentProp WITH (NOLOCK) WHERE componentType = 1 AND componentId = 2 AND propertyTypeId = 1 AND ID = @cloudComponentId)
      SET @cloudComponentId = @cloudComponentId + 1
	INSERT INTO DM2Cloud (cloudId, commcellId, name,  flags, createTime)
VALUES (@cloudComponentId, @commcellId, @cloudName, 1,  @installTime)
END
IF @createPreviewCloud = 1
BEGIN
	SET @cloudComponentId = @cloudComponentId + 1
IF EXISTS (SELECT * FROM APP_ComponentProp WITH (NOLOCK) WHERE componentType = 1 AND componentId = 2 AND propertyTypeId = 1 AND ID = @cloudComponentId)
      SET @cloudComponentId = @cloudComponentId + 1
	INSERT INTO DM2Cloud (cloudId, commcellId, name,  flags, createTime)
VALUES (@cloudComponentId, @commcellId, @cloudName, 16,  @installTime)
END
SET IDENTITY_INSERT DM2Cloud OFF
set @o_errorCode = @@ERROR
if (@o_errorCode <> 0) begin
      set @o_errorCode = 1001 -- validation error
      goto errorexit
end
--
DECLARE @curLMClient INT
SET @curLMClient = (ISNULL((SELECT TOP 1  Core.ClientId FROM DM2SearchServerCoreInfo Core WITH (NOLOCK) INNER JOIN DM2CloudCoreRole CoreRole WITH (NOLOCK)
									ON Core.CloudId = CoreRole.CloudId
									INNER JOIN APP_Client appClient ON Core.ClientId = appClient.id WHERE CoreRole.roleId = 3 AND appClient.status & 2 <> 2 ORDER BY Core.ClientId ) , 0))
--If the lm role is changed, workQueue request should be sent for first MA and prev MA.
IF (@oldLMClient <> @curLMClient)
BEGIN
	-- IF @oldLMClient <> @curLMClient , THEN THERE IS A CHANGE IN LOGMONITORING TOP MA , So send WQ request to both ma's
	EXEC LMSendAlertProcessingWorkQueueReq @curLMClient,@oldLMClient , @o_errorCode output, @o_errorString output
	IF @o_errorCode <> 0
	BEGIN
		GOTO errorexit
	END
END
IF Exists (select * FROM DM2CloudCoreRole CR WITH (NOLOCK)
	INNER JOIN DM2SearchServerCoreInfo S WITH (NOLOCK) ON CR.CloudId = S.CloudId AND S.ClientId = @i_maClientId AND CR.roleId= 4 )
		BEGIN
		DECLARE @paramValue nvarchar(255)
		DECLARE @result int
			--GXGLOBALPARAM table
			SET @paramValue= ISNULL((SELECT CAST (value AS nvarchar(255)) FROM GXGlobalParam WITH(READUNCOMMITTED) WHERE name = 'DOWNLOAD_CENTER_CLIENT_ID' AND modified = 0), N'')
			if @paramValue=N''
			BEGIN
				EXEC @result = sp_getapplock @Resource = 'createDCAnalyticLock', @LockMode = 'Exclusive', @LockTimeout = 60000
				IF (@result NOT IN (0, 1))
				BEGIN
					set @o_errorString = 'Failed to get lock '
					set @o_errorCode = 1001 -- validation error
					GOTO errorexit
				END
					INSERT INTO GXGlobalParam (name, value, created , modified) VALUES('DOWNLOAD_CENTER_CLIENT_ID', CAST (@i_maClientId AS nvarchar(255)),dbo.GetUnixTime(getdate()), 0)
					INSERT INTO GXGlobalParam (name, value, created , modified) VALUES('DOWNLOAD_CENTER_BASE_PORT', CAST (@portNo AS nvarchar(255)),dbo.GetUnixTime(getdate()), 0)
					INSERT INTO GXGlobalParam (name, value, created , modified) VALUES('DOWNLOAD_CENTER_HOST', CAST (@hostName AS nvarchar(255)),dbo.GetUnixTime(getdate()), 0)
					INSERT INTO GXGlobalParam (name, value, created , modified) VALUES('DOWNLOAD_CENTER_CORE_NAME', N'downloadcenterdata',dbo.GetUnixTime(getdate()), 0)
					INSERT INTO GXGlobalParam (name, value, created , modified) VALUES('DOWNLOAD_CENTER_URL', (N'http://' + CAST (@hostName AS nvarchar(255))),dbo.GetUnixTime(getdate()), 0)
				EXEC @result = sp_releaseapplock @Resource = 'createDCAnalyticLock'
			END
		END
ELSE
begin
		SET @paramValue= ISNULL((SELECT CAST (value AS nvarchar(255)) FROM GXGlobalParam WITH(READUNCOMMITTED) WHERE name = 'DOWNLOAD_CENTER_CLIENT_ID' AND modified = 0), N'')
		if @paramValue = @i_maClientId
		begin
			DELETE FROM GXGLOBALPARAM WHERE NAME IN ('DOWNLOAD_CENTER_CLIENT_ID','DOWNLOAD_CENTER_BASE_PORT','DOWNLOAD_CENTER_HOST','DOWNLOAD_CENTER_URL', 'DOWNLOAD_CENTER_CORE_NAME')
		END
end
errorexit:
SELECT @o_errorCode ,@o_errorString
GO

IF EXISTS (select * from GxQscripts where name = 'DM2CreateAnalyticsRoles')
	delete from GxQscripts where name = 'DM2CreateAnalyticsRoles'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2CreateAnalyticsRoles')
	delete from GXDBVersions where aliasname = 'DM2CreateAnalyticsRoles'
GO

insert into GXDBVersions values(2, 'DM2CreateAnalyticsRoles',  '00000000000000000000', 'DM2CreateAnalyticsRoles', '00000000000000000000')
GO

