

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2CreateAnalyticsCloud.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  DM2CreateAnalyticsCloud
--  | Description:   Creates/ delete entries in DM2SearchServerCodeInfo, DM2Cloud
--  |                and DM2CloudCoreRole tables based on i_opType
--  |
--  | Input:
--  |			i_optype : CV_ANALYTICS_ROLE_CONFIG	- Configure analytics cloud
--  |					   CV_ANALYTICS_ROLE_DECONFIG - Deconfigure analytics cloud
--  |			i_clientId: clientId on which Analytics engine is configured or deconfigured
--  |			i_dataLocation: analytics index path
--  |			i_analyticsEngineType: roleType mentioned in DM2CloudRoleMaster table
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DM2CreateAnalyticsCloud.sp,v $ $Id: DM2CreateAnalyticsCloud.sp,v 1.19.2.19 2018/03/27 09:18:21 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DM2CreateAnalyticsCloud <<<'

IF EXISTS (select * from sysobjects where name='DM2CreateAnalyticsCloud')
	drop procedure DM2CreateAnalyticsCloud
IF EXISTS (select * from GxQscripts where name='DM2CreateAnalyticsCloud')
	delete from GxQscripts where name = 'DM2CreateAnalyticsCloud'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2CreateAnalyticsCloud')
	delete from GXDBVersions where aliasname = 'DM2CreateAnalyticsCloud'
GO
print '... Creating Procedure: DM2CreateAnalyticsCloud'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DM2CreateAnalyticsCloud
  @i_opType integer = 1,
  @i_clientId integer,
  @i_dataLocation nvarchar(max),
  @i_analyticsEngineType integer = 4,
  @i_analyticsMemoryMB integer = 4096,
  @i_pseudoClientId integer = 0
AS
  DECLARE @o_errorCode integer = 0
  DECLARE @o_errorStr varchar(max) = 'Success'
  DECLARE @o_CloudId integer = 0
-- check validity of the client
if (@i_clientId < 1 or not exists(select * from APP_Client WITH (NOLOCK) where id = @i_clientId))
begin
	set @o_errorStr = 'Invalid clientId'
	set @o_errorCode = 10412 -- validation error
	goto errorexit
end
--check if role supported
IF @i_analyticsEngineType NOT IN (SELECT roleType FROM DM2CloudRoleMaster WITH (NOLOCK) WHERE FLAGS =1) AND @i_analyticsEngineType <> 0
BEGIN
	set @o_errorStr = 'Invalid engine Type'
	set @o_errorCode = 10412 -- validation error
	goto errorexit
END
DECLARE @portNo integer = ISNULL((select top 1 cast (attrval as int) from APP_ClientProp WITH (NOLOCK) where componentnameid = @i_clientId AND attrName = 'Analytics_baseport' and modified = 0), 20000)
DECLARE @paramValue nvarchar(255)
declare @cloudName nvarchar(256)
declare @hostName nvarchar(256)
DECLARE @result int
select @cloudName = N'Analytics_' + net_hostname, @hostName = net_hostname from  APP_Client WITH (NOLOCK) where id = @i_clientId
declare @installTime int = dbo.GetUnixTime(GETDATE())
DECLARE @curLMClient INT
DECLARE @oldLMClient INT
SET @oldLMClient = ISNULL((SELECT TOP 1  ClientId FROM DM2SearchServerCoreInfo Core WITH (NOLOCK) INNER JOIN DM2CloudCoreRole CoreRole WITH (NOLOCK)
				ON Core.CloudId = CoreRole.CloudId
				INNER JOIN APP_Client appClient ON Core.ClientId = appClient.id WHERE CoreRole.roleId = 3 AND appClient.status & 2 <> 2 ORDER BY Core.ClientId) , 0)
DECLARE @createAnaltyicsCloud int  = 1
DECLARE @createPreviewCloud int  = 0
--
begin transaction
EXEC @result = sp_getapplock @Resource = 'createAnalyticsLock', @LockMode = 'Exclusive', @LockTimeout = 60000
IF (@result NOT IN (0, 1))
BEGIN
	set @o_errorStr = 'Failed to get lock '
	set @o_errorCode = 1001 -- validation error
	GOTO errorexit
END
IF @i_opType = 1  --CV__ANALYTICS_ROLE_CONFIG
	BEGIN
		--if DC role already configured, nothing to do
IF @i_analyticsEngineType = 4
		BEGIN
			--GXGLOBALPARAM table
			SET @paramValue= ISNULL((SELECT CAST (value AS nvarchar(255)) FROM GXGlobalParam WITH(READUNCOMMITTED) WHERE name = 'DOWNLOAD_CENTER_CLIENT_ID' AND modified = 0), N'')
			if len (@paramValue) > 0
			begin
set @o_CloudId =  (select top 1 S.CloudId from DM2SearchServerCoreInfo S WITH (NOLOCK) INNER JOIN DM2Cloud R WITH (NOLOCK) ON S.cloudId = R.cloudid WHERE ClientId = @i_clientId AND R.flags &  16 = 0)
				goto errorexit
			end
		END
		-- check if the cloud already exists
		if exists (select * from DM2SearchServerCoreInfo S WITH (NOLOCK) INNER JOIN DM2CloudCoreRole R WITH (NOLOCK) ON S.CloudId = R.CloudId INNER JOIN DM2CloudRoleMaster M WITH (NOLOCK) ON R.roleId = M.roleType WHERE ClientId = @i_clientId AND M.flags =1)
		begin
			set @o_CloudId =  (select top 1 S.CloudId from DM2SearchServerCoreInfo S WITH (NOLOCK) INNER JOIN DM2CloudCoreRole R WITH (NOLOCK) ON S.CloudId = R.CloudId INNER JOIN DM2CloudRoleMaster M WITH (NOLOCK) ON R.roleId = M.roleType WHERE ClientId = @i_clientId AND M.flags =1)
			-- check if the role already exists
			if exists (select * from dm2cloudcorerole CR WITH (NOLOCK)  WHERE CR.CloudId= @o_CloudId AND CR.roleId = @i_analyticsEngineType)
			begin
				set @o_errorStr = 'Role already exists for the client'
				set @o_errorCode = 10417 -- validation error
			end
			goto globalParamExit
		end
		-- all looks good, create properties
declare @engineType int = (16 | 8)
		DECLARE @commcellId INT = ISNULL ((SELECT origCCId FROM APP_Client WHERE id = @i_clientId), 2)
--avoid cloudId conflicts
DECLARE @cloudComponentId INT = ISNULL((SELECT MAX(cloudId) FROM DM2Cloud WITH (NOLOCK)),0)
EXECUTE AS USER = 'sqladmin_cv'
SET IDENTITY_INSERT DM2Cloud ON
--create virtual cloud only once when exchange index role is configured
IF EXISTS (SELECT 1 FROM DM2CloudCoreRole WITH (NOLOCK) WHERE roleId = 12) OR @i_analyticsEngineType = 12
BEGIN
IF NOT EXISTS (SELECT 1 FROM DM2Cloud WITH (NOLOCK) WHERE (flags & 4) > 0)
		BEGIN
			SET @cloudComponentId = @cloudComponentId + 1
IF EXISTS (SELECT * FROM APP_ComponentProp WITH (NOLOCK) WHERE componentType = 1 AND componentId = 2 AND propertyTypeId = 1 AND ID = @cloudComponentId)
				SET @cloudComponentId = @cloudComponentId + 1
			INSERT INTO DM2Cloud (cloudId, commcellId, name,  flags, createTime)
VALUES (@cloudComponentId , @commcellId, 'Mailbox Index', 4,  @installTime)  --CV_VIRTUAL_CLOUD_MAILBOXINDEX
		END
IF NOT EXISTS (SELECT 1 FROM DM2Cloud WITH (NOLOCK) WHERE (flags & 2) > 0)
		BEGIN
			SET @cloudComponentId = @cloudComponentId + 1
IF EXISTS (SELECT * FROM APP_ComponentProp WITH (NOLOCK) WHERE componentType = 1 AND componentId = 2 AND propertyTypeId = 1 AND ID = @cloudComponentId)
				SET @cloudComponentId = @cloudComponentId + 1
			INSERT INTO DM2Cloud (cloudId, commcellId, name,  flags, createTime)
VALUES (@cloudComponentId, @commcellId, 'Journal Index', 2,  @installTime)  --CV_VIRTUAL_CLOUD_JOURNALINDEX
		END
END
IF @createAnaltyicsCloud = 1
BEGIN
	SET @cloudComponentId = @cloudComponentId + 1
IF EXISTS (SELECT * FROM APP_ComponentProp WITH (NOLOCK) WHERE componentType = 1 AND componentId = 2 AND propertyTypeId = 1 AND ID = @cloudComponentId)
      SET @cloudComponentId = @cloudComponentId + 1
	INSERT INTO DM2Cloud (cloudId, commcellId, name,  flags, createTime)
VALUES (@cloudComponentId, @commcellId, @cloudName, 1,  @installTime)
END
IF @createPreviewCloud = 1
BEGIN
	SET @cloudComponentId = @cloudComponentId + 1
IF EXISTS (SELECT * FROM APP_ComponentProp WITH (NOLOCK) WHERE componentType = 1 AND componentId = 2 AND propertyTypeId = 1 AND ID = @cloudComponentId)
      SET @cloudComponentId = @cloudComponentId + 1
	INSERT INTO DM2Cloud (cloudId, commcellId, name,  flags, createTime)
VALUES (@cloudComponentId, @commcellId, @cloudName, 16,  @installTime)
END
SET IDENTITY_INSERT DM2Cloud OFF
set @o_errorCode = @@ERROR
if (@o_errorCode <> 0) begin
      set @o_errorCode = 1001 -- validation error
      goto errorexit
end
--
		-- Setting admin url
		declare @adminUrl nvarchar(max)
		select @adminUrl = N'http://' + net_hostname + ':' + cast(@portNo as nvarchar(10)) from  APP_Client where id = @i_clientId
		--
		declare @resTable table (errcode int, errstr nvarchar(max))
		insert into @resTable
		exec DM2AddSearchServerCoreInfo  @i_coreName = N'', @i_CommCellId = @commcellId, @i_CloudId = @cloudComponentId,
										 @i_ClientId = @i_clientId, @i_ServiceLink = @adminUrl, @i_Attributes = 0,
										 @i_CoreRoles = @engineType, @i_Description = N'' , @i_cloudType = 1 --App::CloudServerType_AnalyticsEngine
		if exists (select * from @resTable where errcode <> 0)
		begin
			select @o_errorStr = 'Executing DM2AddSearchServerCoreInfo failed', @o_errorCode = 1
			goto errorexit
		end
		declare @stopAnalyticsPort INT = @portNo + 10
		-- add the client properties
		insert into APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
		values (@i_clientId, N'Analytics_CloudId', 7 /*PROPERTY_INTEGER*/, CAST(@cloudComponentId as nvarchar(10)), @installTime, 0, 0),
			   (@i_clientId, N'Analytics_CloudType', 7 /*PROPERTY_INTEGER*/, CAST(@engineType as nvarchar(10)), @installTime, 0, 0),
			   (@i_clientId, N'Analytics_hostname', 1 /*PROPERTY_STRING*/, @hostName, @installTime, 0, 0),
			   (@i_clientId, N'Analytics_QPS_URL', 1 /*PROPERTY_STRING*/, @adminUrl, @installTime, 0, 0),
			   (@i_clientId, N'AnalyticSearchEngineEnabled', 2 /*PROPERTY_BOOLEAN*/, N'1', @installTime, 0, 0),
			   (@i_clientId, N'Analytics_index-dir', 1 /*PROPERTY_STRING*/, @i_dataLocation, @installTime, 0, 0),
			   (@i_clientId, N'Analytics_Memory_MB', 7 /*PROPERTY_INTEGER*/, cast(@i_analyticsMemoryMB as nvarchar(10)) , @installTime, 0, 0),
			   (@i_clientId, N'Analytics_stopPort', 1 /*PROPERTY_STRING*/, cast(@stopAnalyticsPort as nvarchar(10)), @installTime, 0, 0)
		--insert analytics port no only for default port
		-- other ports are inserted by client cvd
		IF @portNo = 20000
			insert into APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
			values (@i_clientId, N'Analytics_baseport', 1 /*PROPERTY_STRING*/, cast(@portNo as nvarchar(10)), @installTime, 0, 0)
		set @o_errorCode = @@ERROR
		if (@o_errorCode <> 0) begin
			set @o_errorStr = 'Error inserting client properties'
			goto errorexit
		end
globalParamExit:
		--	now add roles information
set @o_CloudId =  (select top 1 S.CloudId from DM2SearchServerCoreInfo S WITH (NOLOCK) INNER JOIN DM2Cloud R WITH (NOLOCK) ON S.cloudId = R.cloudid WHERE ClientId = @i_clientId AND R.flags &  16 =0)
IF @i_analyticsEngineType > 0 AND @o_errorCode = 0
		BEGIN
			INSERT INTO DM2CloudCoreRole(CloudId, roleId, createTime)
			VAlues(@o_CloudId, @i_analyticsEngineType, @installTime)
			set @o_errorCode = @@ERROR
			if (@o_errorCode <> 0) begin
				set @o_errorStr = 'Error inserting core role into DM2CloudCoreRole. Error [' + ERROR_MESSAGE() + ']'
				goto errorexit
			end
IF  @i_analyticsEngineType = 13 AND NOT EXISTS (SELECT 1 FROM DM2CloudCoreRole WHERE roleId IN (14) AND CloudId = @o_CloudId)
			BEGIN
				INSERT INTO DM2CloudCoreRole(CloudId, roleId, createTime)
VALUES (@o_CloudId, 14, @installTime)
			END
			IF NOT EXISTS (SELECT 1 FROM APP_ClientProp WITH (NOLOCK) WHERE componentNameId = @i_clientId AND attrName = N'Analytics_RolesInfo')
				insert into APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
				values (@i_clientId, N'Analytics_RolesInfo', 1 /*PROPERTY_STRING*/, cast(@i_analyticsEngineType as nvarchar(5)), @installTime, 0, 0)
			ELSE
				UPDATE APP_ClientProp
				SET attrVal = attrVal + N',' + cast(@i_analyticsEngineType as nvarchar(5))
				WHERE componentNameId = @i_clientId AND attrName = N'Analytics_RolesInfo' AND CHARINDEX(cast(@i_analyticsEngineType as nvarchar(5)),attrVal,0) = 0
		END
		--on upgraded analytics engine, analytics memory is updated
		IF EXISTS (SELECT * FROM APP_ClientProp WITH (NOLOCK) WHERE Componentnameid = @i_clientId AND attrName = N'Analytics_Memory_MB'  AND modified =0)
			UPDATE APP_ClientProp
			SET attrVal = @i_analyticsMemoryMB
			WHERE Componentnameid = @i_clientId AND attrName = N'Analytics_Memory_MB'  AND cast (attrVal as INT) <> @i_analyticsMemoryMB AND modified =0
		ELSE
			insert into APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
			VALUES (@i_clientId, N'Analytics_Memory_MB', 7 /*PROPERTY_INTEGER*/, cast(@i_analyticsMemoryMB as nvarchar(10)) , @installTime, 0, 0)
IF @i_analyticsEngineType = 4
		BEGIN
			--GXGLOBALPARAM table
			SET @paramValue= ISNULL((SELECT CAST (value AS nvarchar(255)) FROM GXGlobalParam WITH(READUNCOMMITTED) WHERE name = 'DOWNLOAD_CENTER_CLIENT_ID' AND modified = 0), N'')
			if @paramValue=N''
			BEGIN
				EXEC @result = sp_getapplock @Resource = 'createDCAnalyticsLock', @LockMode = 'Exclusive', @LockTimeout = 60000
				IF (@result NOT IN (0, 1))
				BEGIN
					set @o_errorStr = 'Failed to get lock '
					set @o_errorCode = 1001 -- validation error
					GOTO errorexit
				END
				INSERT INTO GXGlobalParam (name, value, created , modified) VALUES('DOWNLOAD_CENTER_CLIENT_ID', CAST (@i_clientId AS nvarchar(255)),dbo.GetUnixTime(getdate()), 0)
				INSERT INTO GXGlobalParam (name, value, created , modified) VALUES('DOWNLOAD_CENTER_BASE_PORT', CAST (@portNo AS nvarchar(255)),dbo.GetUnixTime(getdate()), 0)
				INSERT INTO GXGlobalParam (name, value, created , modified) VALUES('DOWNLOAD_CENTER_HOST', CAST (@hostName AS nvarchar(255)),dbo.GetUnixTime(getdate()), 0)
				INSERT INTO GXGlobalParam (name, value, created , modified) VALUES('DOWNLOAD_CENTER_CORE_NAME', N'downloadcenterdata',dbo.GetUnixTime(getdate()), 0)
				INSERT INTO GXGlobalParam (name, value, created , modified) VALUES('DOWNLOAD_CENTER_URL', (N'http://' + CAST (@hostName AS nvarchar(255))),dbo.GetUnixTime(getdate()), 0)
				EXEC @result = sp_releaseapplock @Resource = 'createDCAnalyticsLock'
			END
		END
		DECLARE @curTime INT
		SET @curTime  = datediff(second, '01/01/1970', GETDATE())
		IF @i_pseudoClientId > 0
		BEGIN
				IF NOT EXISTS (SELECT 1 FROM APP_ClientProp WHERE componentNameId=@i_pseudoClientId AND attrname = 'Index Server ClientId' )
					INSERT INTO APP_ClientProp (componentNameId,attrName,attrType, attrVal,created, modified)
					VALUES	(@i_pseudoClientId,	'Index Server ClientId',	7,	@i_clientId,	@curTime,0)
				ELSE
					UPDATE APP_ClientProp
					SET attrVal = @i_clientId
					WHERE componentNameId=@i_pseudoClientId AND attrname = 'Index Server ClientId'
		END
		--create solr index server pseudo client for download center & reviewset role
IF @i_analyticsEngineType IN ( 4, 8) AND @i_pseudoClientId = 0
		BEGIN
			DECLARE @analyticsClients TABLE (t_clientId INT, t_clientName NVARCHAR(2048), t_hostName NVARCHAR(2048))
			--GET ALL CLIENTS WHERE ANALYTICS ENGINE IS CONFIGURED
			INSERT INTO @analyticsClients (t_clientId, t_clientName, t_hostName)
			SELECT DISTINCT ID, name, net_hostname
			FROM APP_CLIENT (NOLOCK)
			WHERE ID = @i_clientId
			--DELETE ALREADY UPGRADED SOLR INDEX SERVERS OR NEW EXISTING SERVERS
			DELETE T
			FROM @analyticsClients T
			INNER JOIN APP_ClientProp CP WITH (NOLOCK) ON CAST (CP.attrVal AS INT) = T.t_clientId
			WHERE attrName = 'Index Server ClientId' AND cp.modified = 0
			DECLARE @psuedoClientId INT  = 0
			DECLARE @psuedoInstanceId INT  = 0
			DECLARE @psuedoBackupsetId INT  = 0
			DECLARE @psuedoAppId INT  = 0
			DECLARE @idxServerClientId INT  = 0
			DECLARE @psuedoClientName NVARCHAR(2048)  = N''
			DECLARE @idxSvrClientName NVARCHAR(2048)  = N''
			DECLARE @idxSvrHostName NVARCHAR(2048)  = N''
			DECLARE @idxServerCGId INT  = 0
SET @idxServerCGId = ISNULL((SELECT id FROM APP_ClientGroup WHERE NAME = 'Index Servers'),0)
			BEGIN TRY
			BEGIN TRAN
			DECLARE GetIncrementalCur CURSOR
				FOR select t_clientId, t_clientName , t_hostName from @analyticsClients
				OPEN GetIncrementalCur
				FETCH NEXT FROM GetIncrementalCur INTO @idxServerClientId, @idxSvrClientName, @idxSvrHostName
				--CREATE PSEUDO CLIENTS FOR EACH ANALYTICS ENGINE
				WHILE @@FETCH_STATUS=0
				BEGIN
					SET @psuedoClientName = @idxSvrClientName + '_AnalyticsServer'
					--CLIENT
					INSERT INTO APP_Client (name, simOperatingSystemId, net_hostname, refTime, client_password, releaseId,origCCId,GUID,specialClientFlags,displayName, modified, offlineEntity, offlineTimeStamp, csHostName, clientDescription, jobResultDir, clientSkewTime, cvdPort, evmgrcPort, status, spaceCheckFlags)
					SELECT  @psuedoClientName,	0, @psuedoClientName , @curTime,	'3cfe3eeb854e8aa64e0155bec019674d5',	16,	2	, NEWID() , 2, @psuedoClientName, @curTime, 0, 0, N'', N'',  N'', 0, 0, 0, 0, 0
					SET @psuedoClientId = ISNULL((SELECT TOP 1 id FROM APP_Client WHERE NAME = @psuedoClientName),0)
					IF @psuedoClientId >0
					BEGIN
						INSERT INTO APP_ClientProp (componentNameId,attrName,attrType, attrVal,created, modified)
						VALUES	(@psuedoClientId,	'Distributed iDA Client',	2,	1,	@curTime,0),
								(@psuedoClientId,	'Index Server Type',		7	, 6	,@curTime	,0),
								(@psuedoClientId,	'Index Server ClientId',	7,	@idxServerClientId,	@curTime,0),
								(@psuedoClientId,	'IndexingV2',			2	,1,	@curTime,0),
								(@psuedoClientId,	'SP Version Info',		1,	11,	@curTime,0)
						--INSTANCE
						INSERT INTO APP_InstanceName (name, status, origCCId,GUID, refTime, modified)
						VALUES ('defaultInstanceName',	0,	2, NEWID(), @curTime, @curTime)
						SET @psuedoInstanceId = @@IDENTITY
						INSERT INTO APP_InstanceProp (componentNameId,attrName, attrType, attrVal,created, modified)
						VALUES (@psuedoInstanceId , 'Distributed Cluster Type',	7,	6,	@curTime,0),
						(@psuedoInstanceId,	'Solr Index Client Id',	10,	@idxServerClientId	,@curTime,0	)
						--BACKUPSET
						INSERT INTO APP_BackupSetName (name, status, origCCId,GUID,refTime, modified)
						VALUES ('defaultBackupSet',	8,	2, NEWID(), @curTime, @curTime)
						SET @psuedoBackupsetId = @@IDENTITY
						--SUBCLIENT
						INSERT INTO APP_Application (clientId,appTypeId,instance,backupSet,subclientName,subclientStatus,origCCId,GUID,appNumber, dataArchGrpID,logArchGrpID, refTime, modified)
						VALUES ( @psuedoClientId,	64	,@psuedoInstanceId,	@psuedoBackupsetId,	'default',	8	,2,	NEWID(), 0,1,1, @curTime,@curTime)
						SET @psuedoAppId = (SELECT id FROM APP_Application WHERE clientId = @psuedoClientId)
						--IDA
						INSERT INTO APP_IDAName (clientId, appTypeId, status, refTime, modified)
						VALUES (@psuedoClientId,	64,	0, 0 , @curTime)
						--CONTENTS
						INSERT INTO APP_ScFilterFile (componentNameId, type, fileName, created, modified)
						SELECT DISTINCT  @psuedoAppId,  1, '\%'+ RM.roleTypeName +'%', @curTime, 0
						FROM DM2CloudCoreRole CR WITH (NOLOCK)
						INNER JOIN DM2CloudRoleMaster RM WITH (NOLOCK) ON CR.roleId =RM.roleType
						INNER JOIN DM2SearchServerCoreInfo S WITH (NOLOCK) ON CR.CloudId =S.CloudId AND S.ClientId = @idxServerClientId
						--ACCESS NODES
						DECLARE @dataAccessNode NVARCHAR(2048) = N'<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_DataAccessNodes><dataAccessNodes _type_="3" clientId="'+ CAST (@idxServerClientId AS nvarchar(20))  +'" clientName="' + @idxSvrClientName +'" hostName="'+ @idxSvrHostName +'"/></App_DataAccessNodes>'
						INSERT INTO APP_SubClientProp (componentNameId,attrName, attrType, attrVal,created, modified)
						VALUES (@psuedoAppId , 'Solr Index Client Id',	10,	@dataAccessNode,	@curTime, 0)
						--PLATFORM
						INSERT INTO APP_Platform
						VALUES (@psuedoClientId,	4,	'N/A',	0)
						--APP_ClientGroupAssoc
						INSERT INTO APP_ClientGroupAssoc (clientGroupId, clientId)
						VALUES (@idxServerCGId, @psuedoClientId)
						--JOB ACTIVITY
						INSERT INTO JMJobAction
						VALUES (@psuedoClientId,	1,	0,	4,	2,	1,	0,	0,	0,	0,	1,	''),
								(@psuedoClientId,	1,	0,	5,	2,	1,	0,	0,	0,	0,	1,	''),
								(@psuedoClientId,	1,	0,	57,	2,	1,	0,	0,	0,	0,	1,	''),
								(@psuedoClientId,	1,	64,	4,	2,	1,	0,	0,	0,	0,	1,	''),
								(@psuedoClientId,	1,	64,	5,	2,	1,	0,	0,	0,	0,	1,	'')
					END
					FETCH NEXT FROM GetIncrementalCur INTO @idxServerClientId, @idxSvrClientName, @idxSvrHostName
				END
				CLOSE GetIncrementalCur
				DEALLOCATE GetIncrementalCur
				COMMIT TRAN
				END TRY
				BEGIN CATCH
					ROLLBACK TRAN
					SELECT @@ERROR, ERROR_MESSAGE()
				END CATCH
		END
	END
ELSE IF @i_opType = 2  --CV__ANALYTICS_ROLE_DECONFIG
	BEGIN
		DECLARE @cloudId INT
		SET @cloudId = (SELECT TOP 1 CloudId FROM DM2SearchServerCoreInfo WITH (NOLOCK) WHERE clientId = @i_clientId AND ServiceLink like '%'+CAST(@portNo AS varchar(50)))
		DELETE CR
		FROM DM2CloudCoreRole CR
			INNER JOIN DM2SearchServerCoreInfo S WITH (NOLOCK)  ON CR.CloudId = S.CloudId AND S.ClientId = @i_clientId AND ServiceLink like '%'+CAST(@portNo AS varchar(50))
		DELETE FROM archFLAIndexingInfo WHERE cloudId = @cloudId
		DELETE FROM archFLAIndexingAged WHERE cloudId = @cloudId
		DELETE FROM archFLAIndexingRestart WHERE cloudId = @cloudId
		DELETE FROM DM2SearchServerCoreInfo WHERE cloudid = @cloudId
		DELETE FROM APP_ClientProp WHERE componentNameId = @i_clientId AND modified = 0
		AND ( attrname IN ( N'Analytics_CloudId', N'Analytics_CloudType', N'Analytics_baseport', N'Analytics_hostname', N'Analytics_QPS_URL', N'AnalyticSearchEngineEnabled',  N'AnalyticsEngineType',N'Analytics_index-dir', N'Analytics_Memory_MB',N'Analytics_RolesInfo', N'Analytics_stopPort'))
IF @i_analyticsEngineType = 4 OR @i_analyticsEngineType = 0
		BEGIN
			SET @paramValue= ISNULL((SELECT CAST (value AS nvarchar(255)) FROM GXGlobalParam WITH(READUNCOMMITTED) WHERE name = 'DOWNLOAD_CENTER_CLIENT_ID' AND modified = 0), N'')
			if @paramValue = @i_clientId
			begin
				DELETE FROM GXGLOBALPARAM WHERE NAME IN ('DOWNLOAD_CENTER_CLIENT_ID','DOWNLOAD_CENTER_BASE_PORT','DOWNLOAD_CENTER_HOST','DOWNLOAD_CENTER_URL', 'DOWNLOAD_CENTER_CORE_NAME')
			END
		END
DELETE FROM APP_ComponentProp WHERE modified=0 AND ((id = @cloudId AND componentType = 1 AND componentId = 2) OR (componentId = @cloudId AND componentType = 2 ))
		DELETE FROM DM2Cloud WHERE cloudId = @cloudId
		--delete virtual cloud only if no exchange index role exists
IF NOT EXISTS (SELECT 1 FROM DM2CloudCoreRole WHERE roleId = 12)
		BEGIN
DELETE FROM DM2Cloud WHERE (flags & 2) > 0 OR  (flags & 4) > 0
		END
		--delete index server client association for proxy client if anlaytics engine is deconfigured
		IF @i_pseudoClientId > 0
			DELETE FROM APP_ClientProp WHERE componentnameid = @i_pseudoClientId AND attrname =  N'Index Server ClientId' AND attrval = @i_clientId AND modified = 0
		--DELELE FLA SCHEDULES IF ANY
		UPDATE T
		SET deleted = 1
		FROM TM_Task T
INNER JOIN TM_SubTask ST WITH (NOLOCK) ON T.taskId = ST.taskId AND ST.operationType = 4022
		INNER JOIN TM_AssocEntity AE WITH (NOLOCK) ON T.taskId = AE.taskId AND AE.MediaAgentId = @i_clientId
INNER JOIN TM_SubTaskOptions SO WITH (NOLOCK) ON ST.subTaskId = SO.subTaskId AND SO.optionId IN ( 1458825153, 300510029 /*CONTENTINDEXINGOPTION_SUB_CLIENT_BASED_ANALYTICS*/)  AND SO.value = 1
	END
SET @curLMClient = ISNULL((SELECT TOP 1  ClientId FROM DM2SearchServerCoreInfo Core WITH (NOLOCK) INNER JOIN DM2CloudCoreRole CoreRole WITH (NOLOCK)
				ON Core.CloudId = CoreRole.CloudId
				INNER JOIN APP_Client appClient ON Core.ClientId = appClient.id WHERE CoreRole.roleId = 3 AND appClient.status & 2 <> 2 ORDER BY Core.ClientId) , 0)
IF (@oldLMClient <> @curLMClient)
BEGIN
	EXEC LMSendAlertProcessingWorkQueueReq @curLMClient , @oldLMClient, @o_errorCode output, @o_errorStr output
	IF @o_errorCode <> 0
	BEGIN
		GOTO errorexit
	END
END
errorexit:
	if @o_errorCode <> 0 AND @o_errorCode <> 10417 begin
		if @@TRANCOUNT > 0 rollback transaction
	end
	else begin
		if @@TRANCOUNT > 0 commit transaction
	end
	select @o_errorCode, @o_errorStr, @o_CloudId
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'DM2CreateAnalyticsCloud')
	delete from GxQscripts where name = 'DM2CreateAnalyticsCloud'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2CreateAnalyticsCloud')
	delete from GXDBVersions where aliasname = 'DM2CreateAnalyticsCloud'
GO

insert into GXDBVersions values(2, 'DM2CreateAnalyticsCloud',  '00010019000200190000', 'DM2CreateAnalyticsCloud', '00010019000200190000')
GO

