

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2ConfigureCvDrillServer.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  DM2ConfigureCvDrillServer
--  | Description:   Creates/ delete entries in DM2SearchServerCodeInfo, DM2Cloud
--  |                and DM2CloudCoreRole tables based on i_opType
--  |
--  | Input:
--  |			i_optype : CV_ANALYTICS_ROLE_CONFIG	- Configure drill cloud
--  |					   CV_ANALYTICS_ROLE_DECONFIG - Deconfigure drill cloud
--  |			i_clientId: clientId on which drill engine is configured or deconfigured
--  |			i_dataLocation: drill index path
--  |			i_zkPort: drill port no
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DM2ConfigureCvDrillServer.sp,v $ $Id: DM2ConfigureCvDrillServer.sp,v 1.1.2.4 2018/03/27 08:58:30 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DM2ConfigureCvDrillServer <<<'

IF EXISTS (select * from sysobjects where name='DM2ConfigureCvDrillServer')
	drop procedure DM2ConfigureCvDrillServer
IF EXISTS (select * from GxQscripts where name='DM2ConfigureCvDrillServer')
	delete from GxQscripts where name = 'DM2ConfigureCvDrillServer'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2ConfigureCvDrillServer')
	delete from GXDBVersions where aliasname = 'DM2ConfigureCvDrillServer'
GO
print '... Creating Procedure: DM2ConfigureCvDrillServer'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure DM2ConfigureCvDrillServer
  @i_opType integer = 1,
  @i_clientId integer,
  @i_coreId integer=0,
  @i_dataSourceId integer,
  @i_zkPort integer = 2181,
  @i_DrillMemoryMB integer = 4096,
  @i_webServerClientId integer 
AS
  DECLARE @o_errorCode integer = 0
  DECLARE @o_errorStr varchar(max) = 'Success'
  DECLARE @o_coreId integer = 0
  DECLARE @o_portNo integer = ISNULL(@i_zkPort, 2181)
  DECLARE @o_maHostName nvarchar(256)=''
-- check validity of the client
if (@i_clientId < 1 or not exists(select * from APP_Client WITH (NOLOCK) where id = @i_clientId))
begin
	set @o_errorStr = 'Invalid clientId'
	set @o_errorCode = 10412 -- validation error
	goto errorexit
end
IF @i_dataSourceId < 1
begin
	set @o_errorStr = 'Invalid DataSourceId'
	set @o_errorCode = 10627 -- validation error
	goto errorexit
end
DECLARE @paramValue nvarchar(255)
DECLARE @result int
DECLARE @hostName nvarchar(256)
DECLARE @hostPortNum integer
DECLARE @isDrillConfigured varchar(256)='true'
DECLARE @DRILL_PROP_NAME varchar(256) = 'isDrillEnabled'
DECLARE @installTime int = dbo.GetUnixTime(GETDATE())
DECLARE @tempDataSource as TABLE ( datasourceId INT)
DECLARE @propertyId INT =0
--
begin transaction
EXEC @result = sp_getapplock @Resource = 'createDrillLock', @LockMode = 'Exclusive', @LockTimeout = 60000
IF (@result NOT IN (0, 1))
BEGIN
	set @o_errorStr = 'Failed to get lock '
	set @o_errorCode = 1001 -- validation error
	GOTO errorexit
END
			--Getting the WEBSERVER Host Name
		SELECT @hostName = net_hostname
			FROM APP_Client
			WHERE id = @i_webServerClientId
		--Getting the ma Host Name
		SELECT @o_maHostName = net_hostname
					FROM APP_Client
					WHERE id = @i_clientId
		--Getting the WEBSERVER Port Number
		SELECT @hostPortNum = ISNULL((SELECT attrVal
                      FROM APP_ClientProp WITH (NOLOCK)
                      WHERE componentNameId = @i_webServerClientId
                      AND attrName = 'DM2WebService Web Site Port'
                      AND modified = 0), '')
		SELECT @propertyId = PropertyId from SEProperty WHERE PropertyName=@DRILL_PROP_NAME
IF @i_opType = 1  --CV__ANALYTICS_ROLE_CONFIG
	BEGIN
		-- add the client properties
		IF NOT EXISTS(SELECT TOP 1 * from APP_ClientProp where attrName ='isDrillServerConfigured' and componentNameId = @i_clientId)
		BEGIN
			insert into APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
			values  (@i_clientId, N'isDrillServerConfigured', 2 /*PROPERTY_BOOLEAN*/, N'1', @installTime, 0, 0),
				   (@i_clientId, N'Drill_jvmMax', 7 /*PROPERTY_INTEGER*/, cast(@i_DrillMemoryMB as nvarchar(10)) , @installTime, 0, 0),
     				 (@i_clientId, N'Drill_zkPort', 1 /*PROPERTY_STRING*/, cast(@o_portNo as nvarchar(10)), @installTime, 0, 0),
					 (@i_clientId, N'Drill_WShostName', 1 /*PROPERTY_STRING*/, cast(@hostName as nvarchar(50)), @installTime, 0, 0),
					 (@i_clientId, N'Drill_WShostPort', 1 /*PROPERTY_STRING*/, cast( @hostPortNum as nvarchar(10)), @installTime, 0, 0)
		END
		set @o_errorCode = @@ERROR
		if (@o_errorCode <> 0) begin
			set @o_errorStr = 'Error inserting client properties'
			goto errorexit
		end
		Insert into @tempDataSource
		Select @i_dataSourceId
	END
	ELSE IF @i_opType = 2  --CV__ANALYTICS_ROLE_DECONFIG
	BEGIN
		DELETE FROM APP_ClientProp WHERE componentNameId = @i_clientId AND modified = 0
		AND ( attrname IN ( N'isDrillServerConfigured', N'Drill_jvmMax',N'Drill_zkPort',N'Drill_WShostName',N'Drill_WShostPort'))
		SET @isDrillConfigured='false'
		Insert into @tempDataSource
				select SD.DataSourceid  from SECollectionInfo SC
				INNER JOIN SEDataSource SD
				ON SD.CoreId = SC.CoreId AND sc.ClientId = @i_clientId
				INNER JOIN SEDataSourceProperty SDP
				ON SDP.DataSourceId = SD.DataSourceId AND SDP.PropertyId =@propertyId
	END
	IF @i_dataSourceId > 0
		BEGIN
				MERGE SEDataSourceProperty AS SDP
				USING (select dataSourceId from @tempDataSource) S
				ON SDP.DataSourceId = S.dataSourceId AND SDP.PropertyId = @propertyId
				WHEN MATCHED THEN
				UPDATE SET PropertyValue = @isDrillConfigured
				WHEN NOT MATCHED BY TARGET THEN
				INSERT  (DataSourceId, PropertyId, PropertyValue)
				values (@i_dataSourceId,@propertyId,@isDrillConfigured);
		END
errorexit:
	if @o_errorCode <> 0 begin
		if @@TRANCOUNT > 0 rollback transaction
	end
	else begin
		if @@TRANCOUNT > 0 commit transaction
	end
	select @o_errorCode, @o_errorStr, @o_coreId,@o_maHostName,@o_portNo
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'DM2ConfigureCvDrillServer')
	delete from GxQscripts where name = 'DM2ConfigureCvDrillServer'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2ConfigureCvDrillServer')
	delete from GXDBVersions where aliasname = 'DM2ConfigureCvDrillServer'
GO

insert into GXDBVersions values(2, 'DM2ConfigureCvDrillServer',  '00010001000200040000', 'DM2ConfigureCvDrillServer', '00010001000200040000')
GO

