

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2AutoDetectSearchEngine.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='DM2AutoDetectSearchEngine')
BEGIN
	print '>>> Drop Stored Procedure: DM2AutoDetectSearchEngine <<<'
	drop procedure DM2AutoDetectSearchEngine
END
IF EXISTS (select * from GxQscripts where name='DM2AutoDetectSearchEngine')
	delete from GxQscripts where name = 'DM2AutoDetectSearchEngine'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2AutoDetectSearchEngine')
	delete from GXDBVersions where aliasname = 'DM2AutoDetectSearchEngine'
GO
print '... Creating Procedure: DM2AutoDetectSearchEngine'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure DM2AutoDetectSearchEngine
  @i_userGuid VARCHAR(64)
AS
  DECLARE @o_cloudId INT
--if user is associated to V2 mailbox, return mailbox index cloudid
--check if email status is active and at least one backup job exists
	IF EXISTS(SELECT TOP  1 1
				FROM APP_EmailConfigPolicyAssoc (NOLOCK)
				WHERE mailboxType = 1 /*MailboxType.USER_MAILBOXES*/
					AND REPLACE(userGuid,'X','-') = @i_userGuid
					AND modified = 0
					AND deleted = 0
					AND status = 0 /*emailstatus active*/
					AND ISNULL(backupReferenceTime ,0) != 0 )
SET @o_cloudId = ISNULL((SELECT TOP 1 cloudId FROM DM2Cloud (NOLOCK) WHERE (flags & 4) > 0),0)
	ELSE
		SET @o_cloudId = ISNULL((SELECT TOP 1 R.cloudId
		FROM  APP_Application S WITH (NOLOCK)
		INNER JOIN  APP_SubClientProp SCP  WITH (NOLOCK) on scp.componentNameId=s.id AND attrType=111 AND scp.modified=0
INNER JOIN  archContentIndexingRules R  WITH (NOLOCK) on S.dataArchGrpID = R.archGroupId AND R.operationType = 1
		INNER JOIN  archGroup G  WITH (NOLOCK) on S.dataArchGrpID = G.id
		INNER JOIN  UMUsers U WITH (NOLOCK) on REPLACE(U.userGuid,'-','X') = SUBSTRING(SCP.attrVal,CHARINDEX('{',SCP.attrVal)+1 ,CHARINDEX('}',SCP.attrVal)-CHARINDEX('{',SCP.attrVal)-1)
		WHERE  CHARINDEX('{',SCP.attrVal) > 0 AND s.appTypeID IN (54,56) AND U.userGuid = @i_userGuid),0)
--OUTPUT
SELECT @o_cloudId
GO

IF EXISTS (select * from GxQscripts where name = 'DM2AutoDetectSearchEngine')
	delete from GxQscripts where name = 'DM2AutoDetectSearchEngine'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2AutoDetectSearchEngine')
	delete from GXDBVersions where aliasname = 'DM2AutoDetectSearchEngine'
GO

insert into GXDBVersions values(2, 'DM2AutoDetectSearchEngine',  '00000000000000000000', 'DM2AutoDetectSearchEngine', '00000000000000000000')
GO

