

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2AuditOperation.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  DM2AuditOperation()
--  | Description:  Perform the audit operation for the DM2
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DM2AuditOperation.sp,v $ $Id: DM2AuditOperation.sp,v 1.3.60.3 2018/03/27 08:50:40 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DM2AuditOperation <<<'

IF EXISTS (select * from sysobjects where name='DM2AuditOperation')
	drop procedure DM2AuditOperation
IF EXISTS (select * from GxQscripts where name='DM2AuditOperation')
	delete from GxQscripts where name = 'DM2AuditOperation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2AuditOperation')
	delete from GXDBVersions where aliasname = 'DM2AuditOperation'
GO
print '... Creating Procedure: DM2AuditOperation'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DM2AuditOperation
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_xmlText XML = ''
AS
SET NOCOUNT ON
BEGIN
	DECLARE @opMsgId INTEGER
	DECLARE @userId INTEGER
	DECLARE @opEvMsgId INTEGER
	DECLARE @opId INTEGER
	DECLARE @paramMsgId INTEGER
	DECLARE @paramDataXml XML
	DECLARE @paramData NVARCHAR(MAX)
	DECLARE @dataIsEvent INTEGER = 0
	DECLARE @o_errorCode		INT = 0
	DECLARE @o_errorString		NVARCHAR(MAX) = ''
	DECLARE @clientId	INTEGER
BEGIN TRY
BEGIN TRAN
	--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	-- Set Gui Audit Operation
	SET @userId = ISNULL(( SELECT ref.value('@userId', 'int')
      							FROM @i_xmlText.nodes('DM2ContentIndexing_DM2AuditOperation') R ( ref ) ), 0)
	SET @opMsgId= ISNULL(( SELECT ref.value('@operationMsgId', 'int')
      							FROM @i_xmlText.nodes('DM2ContentIndexing_DM2AuditOperation') R ( ref ) ), 0)
    SET @clientId= ISNULL(( SELECT ref.value('@clientId', 'int')
      							FROM @i_xmlText.nodes('DM2ContentIndexing_DM2AuditOperation') R ( ref ) ), 0)
	IF(@opMsgId <= 0 )
	BEGIN
		SET @o_errorCode = 1
		SET @o_errorString = 'ERROR: Invalid OperationMessge id '
		GOTO EXIT_ERROR
	END
	ELSE
	BEGIN
		SET @opMsgId = (@opMsgId | (CAST(POWER(2, 24) AS BIGINT) * 84))
		EXEC EvGuiAuditSetOperation @opMsgId, @userId, @opEvMsgId OUTPUT, @opId OUTPUT
		IF(@opEvMsgId <= 0 OR @opId <= 0)
		BEGIN
			SET @o_errorCode = 2
			SET @o_errorString = 'ERROR: Invalid OperationMessge from evMsgs or EvGuiAuditOperation'
			GOTO EXIT_ERROR
		END
		--Update the client Id in evMsg Table with the opEvMsgId got
		IF(@clientId > 0)
		BEGIN
			DECLARE @clientName	NVARCHAR(MAX)
			SELECT @clientName = name FROM APP_Client WHERE id = @clientId
			UPDATE evMsg SET
				clientID = @clientId,
				client = @clientName
			 WHERE id = @opEvMsgId;
			IF @@error <> 0
			BEGIN
			    EXECUTE dbo.GetError @o_errorString OUTPUT , @o_errorCode OUTPUT
			    SET @o_errorString = 'ERROR: Could not update the evMsg with clientId' + @o_errorCode
				GOTO EXIT_ERROR
			END
		END
	END
	--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	-- Set Gui Audit Parameter
	-- Open cursor for paramMsgIds
	DECLARE paramMsgCursor CURSOR FAST_FORWARD FOR
	SELECT
		T.list.value('@paramMsgId','INTEGER')
	FROM @i_xmlText.nodes('/DM2ContentIndexing_DM2AuditOperation/paramList') AS T(list)
	OPEN paramMsgCursor
	FETCH NEXT FROM paramMsgCursor INTO @paramMsgId
	WHILE @@FETCH_STATUS = 0
	BEGIN
		--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
		--Perform operation only if its a valid paramMessage id
		IF(@paramMsgId > 0)
		BEGIN
			--Set paramData
			--Open cursor for the available parameters obtained from list
			DECLARE paramDataCursor CURSOR FAST_FORWARD FOR
			SELECT
				dbo.DecodeInvalidXMLChar(P.val.value('@val','VARCHAR(MAX)'))
			FROM @i_xmlText.nodes('/DM2ContentIndexing_DM2AuditOperation/paramList/paramDatas') AS P(val)
			WHERE P.Val.value('../@paramMsgId','INTEGER')=@paramMsgId
			OPEN paramDataCursor
			FETCH NEXT FROM paramDataCursor INTO @paramData
			WHILE @@FETCH_STATUS = 0
			BEGIN
				--
				EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
			FETCH NEXT FROM paramDataCursor INTO @paramData
			END
			CLOSE paramDataCursor
			DEALLOCATE paramDataCursor
			SET @paramMsgId = (@paramMsgId | (CAST(POWER(2, 24) AS BIGINT) * 85))
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
		END
		--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	FETCH NEXT FROM paramMsgCursor INTO @paramMsgId
	END
	CLOSE paramMsgCursor
	DEALLOCATE paramMsgCursor
	--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	COMMIT TRAN
END TRY
---------------------------------------------
-- CHECK FOR ERRORS ----
---------------------------------------------
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	-- Call procedure to print error information.
	-- Call procedure to get error information.
	EXECUTE dbo.GetError @o_errorString OUTPUT , @o_errorCode OUTPUT
	-- Rollback any active or uncommittable transactions before
	-- inserting information in the ErrorLog
	IF XACT_STATE() <> 0
	BEGIN
		ROLLBACK TRANSACTION;
	END
END CATCH;
EXIT_ERROR:
	-- Rollback any active or uncommittable transactions before
	-- inserting information in the ErrorLog
	IF XACT_STATE() <> 0
	BEGIN
		ROLLBACK TRANSACTION;
	END
	IF @o_errorCode = 0
	BEGIN
		SET @o_errorString = 'NO ERROR'
	END
	SELECT	1					as TAG,
			0					as Parent,
			@o_errorCode			as [CVGui_GenericResp!1!errorCode],
			@o_errorString			as [CVGui_GenericResp!1!errorMessage]
		FOR XML EXPLICIT
END
GO

IF EXISTS (select * from GxQscripts where name = 'DM2AuditOperation')
	delete from GxQscripts where name = 'DM2AuditOperation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2AuditOperation')
	delete from GXDBVersions where aliasname = 'DM2AuditOperation'
GO

insert into GXDBVersions values(2, 'DM2AuditOperation',  '00010003006000030000', 'DM2AuditOperation', '00010003006000030000')
GO

