

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2AddUserGUID.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  DM2AddUserGUID()
--  | Description:  Add the user GUID information
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DM2AddUserGUID.sp,v $ $Id: DM2AddUserGUID.sp,v 1.17.32.8 2019/12/18 22:20:03 sgolla Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='DM2AddUserGUID')
BEGIN
	print '>>> Drop Stored Procedure: DM2AddUserGUID <<<'
	drop procedure DM2AddUserGUID
END
IF EXISTS (select * from GxQscripts where name='DM2AddUserGUID')
	delete from GxQscripts where name = 'DM2AddUserGUID'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2AddUserGUID')
	delete from GXDBVersions where aliasname = 'DM2AddUserGUID'
GO
print '... Creating Procedure: DM2AddUserGUID'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DM2AddUserGUID
  @i_userId INT,
  @i_xmlText XML
AS
  DECLARE @o_ErrorCode integer
  DECLARE @o_ErrorString nvarchar(1024)
BEGIN
	DECLARE @i_userName		NVARCHAR(1024)
	DECLARE @i_userLogIn	NVARCHAR(1024)
	DECLARE @i_domainName	NVARCHAR(255)
	DECLARE @i_userGUID		NVARCHAR(36)
	DECLARE @i_canonicalName NVARCHAR(256)
	DECLARE @userGUID		NVARCHAR(36)
	DECLARE @origUserGUID	NVARCHAR(256)
	DECLARE @createTime		INT
	DECLARE @umDSproviderId INT
	SET @o_ErrorCode = 0
	SET @o_ErrorString = ''
	-------------------------------
	--CREATE TEMP TABLE------------
	-------------------------------
	-- None of these temp tables should ever exist when this procedure is called!
	if object_id('tempdb.dbo.#dm2UserObjectsTbl') is not null
				DROP TABLE #dm2UserObjectsTbl
	CREATE TABLE #dm2UserObjectsTbl (	commCellId	integer, clientId	integer, appTypeId	integer,
						instanceId	integer, backupsetId	integer, subClientId	integer, archGroupId	integer )
	IF object_id('tempdb.dbo.#tmpextGroupListTbl') is not null
					DROP TABLE #tmpextGroupListTbl
	CREATE TABLE #tmpextGroupListTbl (  t_groupName	varchar(1024) )
	SET @createTime = dbo.getunixtime(GETUTCDATE())
	SET @i_userName = ISNULL(( SELECT ref.value('@userName', 'nvarchar(255)')
						FROM @i_xmlText.nodes('DM2ContentIndexing_AddUserGUIReq') R ( ref ) ), '')
	SET @i_userLogIn = ISNULL(( SELECT ref.value('@userLogin', 'nvarchar(255)')
						FROM @i_xmlText.nodes('DM2ContentIndexing_AddUserGUIReq') R ( ref ) ), '')
	SET @i_userGUID = ( SELECT ref.value('@userGUID', 'nvarchar(36)')
						FROM @i_xmlText.nodes('DM2ContentIndexing_AddUserGUIReq') R ( ref ) )
	--CASE IF @i_userGuid is empty but not NULL
	IF(LEN(ISNULL(@i_userGUID,'')) = 0)
		SET @i_userGUID = NEWID()
	SET @i_domainName = ISNULL(( SELECT ref.value('@domainName', 'nvarchar(255)')
						FROM @i_xmlText.nodes('DM2ContentIndexing_AddUserGUIReq') R ( ref ) ), '')
	--Changes for LN user.
	-- @i_canonicalName will be empty for all user other LN users
	SET @i_canonicalName = ISNULL(( SELECT ref.value('@canonicalName', 'NVARCHAR(256)')
						FROM @i_xmlText.nodes('DM2ContentIndexing_AddUserGUIReq') R ( ref ) ), '')
	INSERT INTO #tmpextGroupListTbl (t_groupName)
	SELECT ref.value('@val', 'nvarchar(1024)')
	FROM  @i_xmlText.nodes ('DM2ContentIndexing_AddUserGUIReq/groups') R(ref)
	IF @i_userLogIn = ''
	BEGIN
			SET @o_ErrorCode = -1
			SET @o_ErrorString = 'User name cannot be empty'
			GOTO EXIT_PROC
	END
	IF @i_userGUID = ''
	BEGIN
			SET @o_ErrorCode = -2
			SET @o_ErrorString = 'User GUID cannot be empty'
			GOTO EXIT_PROC
	END
	IF @i_domainName <> ''
		SET @i_userLogIn = @i_domainName + '\' + @i_userLogIn
	--IF NOT EXISTS(SELECT * FROM UMUSers WHERE login = @i_userLogIn)
	--BEGIN
	--	DECLARE @flags	INT
	--	DECLARE @userId	INT
	--	SET @flags = CAST(USERS_VALID AS INT) | CAST(USERS_WEBGUI_CHANGE AS INT)
	--	IF @UMDSProvider IS NULL OR @UMDSProvider = ''
	--	BEGIN
	--		SET @o_ErrorCode = -1
	--		SET @o_ErrorString = 'Could not create user [' + @i_userLogIn +'] Missing or wrong domain name'
	--		GOTO EXIT_PROC
	--	END
	--	INSERT INTO UMUsers
	--	SELECT TOP(1) @i_userName, 'WebUI created user', @i_userLogIn, '2AZdUUxUUyUUz', email, @createTime, 0, 0,
	--			1, @flags, 0, CVPWD_VERSION_2, Pager, 0, 0, @UMDSProvider, '', ''
	--			FROM UMUsers WHERE id < 0
	--	SET @o_ErrorCode = @@error
	--	SET @userId = @@IDENTITY
	--	INSERT INTO UMDSUserGroup
	--	SELECT	@userId, id, @createTime
	--	FROM	UMDSGroups, #tmpextGroupListTbl
	--	WHERE	name = t_groupName and umdsProviderId = @UMDSProvider and enabled = 1
	--END
	--IF @o_ErrorCode <> 0
	--BEGIN
	--	SET @o_ErrorString = 'Could not create user [' + @i_userLogIn +'] '
	--	GOTO EXIT_PROC
	--END
	SELECT @userGUID= userGuid, @i_userId=id,@origUserGUID = origUserGuid, @umDSproviderId=umDSproviderId FROM UMUSers (NOLOCK) WHERE login = @i_userLogIn
	-- AEB v11: Bhavyan identified that sec_updateUserCredentials should not be
	--			executed here, already executed during the login process and if
	--			performed here it increases login delay.
	UPDATE UMUSers SET lastLogInTime = @createTime WHERE id = @i_userId
	--EXEC sec_updateUserCredentials @i_userId
	--IF GUID INFORMATION IS MISSING, ADD IT
	IF (@userGUID IS null OR @userGUID = '')
	BEGIN
		UPDATE UMUSers SET userGuid = @i_userGUID, flags = (flags | 0x400) WHERE login = @i_userLogIn
		SET @o_ErrorCode = @@error
		IF(@o_ErrorCode = 0 AND LEN(@i_canonicalName) > 0 AND LEN(ISNULL(@origUserGUID,'')) = 0 )
		BEGIN
			/*CASE WHEN LN User first logs into the webUI.
			* Its userGuid will be a new GUID and not canonical name.
			* So we update the origuserGuid column to input canonical name .
			* this should EXECUTE WHEN USER LOGS FIRST TIME
			* */
			--SET @i_userGUID = @userGUID
			UPDATE UMUSers SET origUserGuid = @i_canonicalName
			WHERE login = @i_userLogIn
			SET @o_ErrorCode = @@error
		END
	END
 --Fix for TR 190813-128. We will always update origUserGUID as it is important to have canonical name here for domino end user search operation.
	ELSE IF LEN(ISNULL(@userGUID,''))>0 AND LEN(@i_canonicalName) > 0
	BEGIN
		/*CASE WHEN LN User logged into JavaGUI AND Then into webUI
		* userGuid will not be empty but origUserGuid will be null/empty
		* So we update the origuserGuid column to input canonical name.
		* */
		--SET @i_userGUID = @userGUID
		UPDATE UMUSers SET origUserGuid = @i_canonicalName
				,flags = (flags | 0x400)
		WHERE login = @i_userLogIn
		SET @o_ErrorCode = @@error
	END
	ELSE IF (@userGUID <> @i_userGUID)
	BEGIN
		IF (@umDSproviderId > 0)
		BEGIN
			UPDATE UMUSers SET origUserGuid = userGuid WHERE login = @i_userLogIn
			UPDATE UMUSers SET userGuid = @i_userGUID, flags = (flags | 0x400) WHERE login = @i_userLogIn
		END
		ELSE
		BEGIN
			UPDATE UMUSers SET origUserGuid = @i_userGUID, flags = (flags | 0x400) WHERE login = @i_userLogIn
		END
		--IF (@i_domainName <> '')
		--BEGIN
		--	SET @o_ErrorCode = -3
		--	SET @o_ErrorString = 'User GUID supplied by WEB did not match GUID found in CS'
		--END
	END
	--Returnt the userGuid in errorString object only if the errorCode is 0
	IF(@o_ErrorCode = 0)
		SET @o_ErrorString = (SELECT userGuid FROM UMUSers WITH(NOLOCK) WHERE login = @i_userLogIn)
EXIT_PROC:
	DROP TABLE #tmpextGroupListTbl
	DROP TABLE #dm2UserObjectsTbl
	SELECT @o_ErrorCode AS errorCode, @o_ErrorString AS errorString
END
SET NOCOUNT ON
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'DM2AddUserGUID')
	delete from GxQscripts where name = 'DM2AddUserGUID'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2AddUserGUID')
	delete from GXDBVersions where aliasname = 'DM2AddUserGUID'
GO

insert into GXDBVersions values(2, 'DM2AddUserGUID',  '00010017003200080000', 'DM2AddUserGUID', '00010017003200080000')
GO

