

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2AddSearchServerCoreInfo.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  DM2AddSearchServerCoreInfo
--  | Description:  Add new Search Server Core
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DM2AddSearchServerCoreInfo.sp,v $ $Id: DM2AddSearchServerCoreInfo.sp,v 1.8.2.5 2018/03/22 02:57:52 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DM2AddSearchServerCoreInfo <<<'

IF EXISTS (select * from sysobjects where name='DM2AddSearchServerCoreInfo')
	drop procedure DM2AddSearchServerCoreInfo
IF EXISTS (select * from GxQscripts where name='DM2AddSearchServerCoreInfo')
	delete from GxQscripts where name = 'DM2AddSearchServerCoreInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2AddSearchServerCoreInfo')
	delete from GXDBVersions where aliasname = 'DM2AddSearchServerCoreInfo'
GO
print '... Creating Procedure: DM2AddSearchServerCoreInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure DM2AddSearchServerCoreInfo
  @i_CoreName nvarchar(256) = '',
  @i_CommCellId integer,
  @i_CloudId integer,
  @i_ClientId integer,
  @i_ServiceLink nvarchar(1000),
  @i_Attributes integer = -1,
  @i_CoreRoles integer = 0,
  @i_Description nvarchar(max),
  @i_cloudType integer = 0
AS
  DECLARE @o_errorCode INT = 0;
  DECLARE @o_errorString NVARCHAR(MAX) = 'Search Server Core Update Successfully';
SET NOCOUNT ON
	DECLARE @CoreId INTEGER
	IF @i_CommCellId IS NULL OR @i_CommCellId = 0
		SET @i_CommCellId = 2
	IF @i_ClientId IS NULL OR @i_ClientId = 0
	BEGIN
		SET @o_errorCode = 1
		SET @o_errorString = 'Failed to add Search Server Core due to invalid Client ID'
		GOTO EXIT_AND_RETURN
	END
	IF @i_CloudId IS NULL OR @i_CloudID = 0
	BEGIN
		SET @o_errorCode = 1
		SET @o_errorString = 'Failed to add Search Server Core due to invalid Cloud ID'
		GOTO EXIT_AND_RETURN
	END
	IF @i_ServiceLink IS NULL OR LEN(@i_ServiceLink) = 0
	BEGIN
		SET @o_errorCode = 1
		SET @o_errorString = 'Failed to add Search Server Core due to invalid service link'
		GOTO EXIT_AND_RETURN
	END
	-- Verify the given values
	IF @i_CoreName IS NULL OR LEN(@i_CoreName) = 0
		SET @i_CoreName = 'Cloud_' + CAST(@i_CloudId as varchar(10)) + '_Client_' + CAST(@i_ClientId as varchar(10)) + '_Core'
	-- By default, the core is for search/index
	IF @i_CoreRoles IS NULL OR @i_CoreRoles = 0
	BEGIN
SET @i_CoreRoles = 8 | 16
	END
	--NODE ALREADY EXISTS, DO NOTHING.
	IF EXISTS (SELECT CoreId FROM DM2SearchServerCoreInfo WITH (READUNCOMMITTED) WHERE ClientId = @i_ClientId and CloudId = @i_CloudId and ServiceLink = @i_ServiceLink)
		GOTO EXIT_AND_RETURN
	IF NOT EXISTS (SELECT CoreId FROM DM2SearchServerCoreInfo WITH (READUNCOMMITTED) WHERE CloudId = @i_CloudId)
	BEGIN
SET @i_CoreRoles = @i_CoreRoles | 4
	END
	ELSE
	BEGIN
SET @i_CoreRoles = @i_CoreRoles & (~4)
	END
	---NODE ALREADY EXISTS, BUT PORT IS DIFFERENT.
	IF EXISTS (SELECT CoreId FROM DM2SearchServerCoreInfo WITH (READUNCOMMITTED) WHERE ClientId = @i_ClientId and CloudId = @i_CloudId and ServiceLink != @i_ServiceLink)
		DELETE FROM DM2SearchServerCoreInfo WHERE ClientId = @i_ClientId and CloudId = @i_CloudId
	DECLARE @portNo INT = SUBSTRING(@i_ServiceLink,LEN(@i_ServiceLink) - CHARINDEX(':',REVERSE(@i_ServiceLink)) + 2,5)
	--ADD A NEW NODE
	INSERT INTO DM2SearchServerCoreInfo
	(
		CoreName, CommCellId, CloudId, ClientId,
		CreateTime,
		SoftState, Enabled,
		Attributes,
		ServiceLink, CoreRoles,
		CollectionSize, FreeSpace, OccupiedSpace,
		Description,
		skippedItems, failedItems, numFiles, numEmails, portNo, cloudType
	)
	VALUES
	(
		@i_CoreName, @i_CommCellId, @i_CloudId, @i_ClientId,
		getutcdate(),
		1, 1,
		CASE WHEN @i_Attributes IS NULL OR @i_Attributes = -1 THEN 0 ELSE @i_Attributes END,
		@i_ServiceLink, @i_CoreRoles,
		0, -1, 0,
		CASE WHEN @i_Description IS NULL THEN '' ELSE @i_Description END,
		0, 0, 0, 0, @portNo, @i_cloudType
	)
	SELECT @CoreId = @@IDENTITY, @o_errorCode = @@ERROR
	IF @o_errorCode != 0
	BEGIN
		SET @o_errorString = 'Failed to add Search Server Core due to database error [' + CAST(@o_errorCode as varchar(10)) + ']'
		GOTO EXIT_AND_RETURN
	END
	UPDATE DM2SearchServerCoreInfo SET CoreName = CoreName + '_' + CAST(@CoreId as varchar(10))
	WHERE CoreId = @CoreId
	SET @o_errorString = 'Search Server Core Add Successfully with ID [' + CAST(@CoreId as varchar(10)) + ']'
EXIT_AND_RETURN:
	SELECT @o_errorCode, @o_errorString
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'DM2AddSearchServerCoreInfo')
	delete from GxQscripts where name = 'DM2AddSearchServerCoreInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2AddSearchServerCoreInfo')
	delete from GXDBVersions where aliasname = 'DM2AddSearchServerCoreInfo'
GO

insert into GXDBVersions values(2, 'DM2AddSearchServerCoreInfo',  '00010008000200050000', 'DM2AddSearchServerCoreInfo', '00010008000200050000')
GO

