

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DM2AddLegalHold.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  DM2AddLegalHold()
--  | Description:  Add new LegalHold
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DM2AddLegalHold.sp,v $ $Id: DM2AddLegalHold.sp,v 1.12.88.3 2018/09/21 04:49:08 csingh Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DM2AddLegalHold <<<'

IF EXISTS (select * from sysobjects where name='DM2AddLegalHold')
	drop procedure DM2AddLegalHold
IF EXISTS (select * from GxQscripts where name='DM2AddLegalHold')
	delete from GxQscripts where name = 'DM2AddLegalHold'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2AddLegalHold')
	delete from GXDBVersions where aliasname = 'DM2AddLegalHold'
GO
print '... Creating Procedure: DM2AddLegalHold'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DM2AddLegalHold
@CompPolicyID 	varchar(36),
@CompPolicyName nvarchar(256),
@CompPolicyDesc	nvarchar(max) = '',
@RetainUntil	 	datetime = null,
@BackupsetId		integer,
@Attribute 			integer				= 0,
@UserGUID 			varchar(36),
@CreateTime			datetime,
@ModifiedTime		datetime,
@emailIds		nvarchar(max) = '',
@sendOutput			integer = 1,
@flags			integer = 1
AS
BEGIN
DECLARE @o_errorCode		INT = 0
DECLARE @o_errorString		NVARCHAR(MAX) = 'Legalhold Successfully added'
DECLARE @entityType INT = 9505
DECLARE @userId int = null
DECLARE @t_userCaps 		TABLE (caps bigint)
DECLARE @userCaps 			bigint = 0
DECLARE @UserName			NVARCHAR(MAX)
DECLARE @domainName			NVARCHAR(MAX)
DECLARE @SPName	NVARCHAR(MAX)
DECLARE @LHId				int
DECLARE @permissionsList 	NVARCHAR(MAX)
SET @userId = ( SELECT id FROM UMUsers WHERE userGuid = @UserGUID )
IF ( @userId = 0 OR @userId IS null )
BEGIN
	SET @o_errorCode = 1
	SET @o_errorString = 'Invalid User Name'
	RETURN
END
SET @UserName   = ISNULL(( SELECT name FROM UMUsers WHERE userGuid = @UserGUID ), N'')
SET @domainName = ISNULL((SELECT domainName FROM UMDSProviders WITH (NOLOCK)
						WHERE id = (SELECT umDSproviderId FROM UMUsers WHERE userGuid = @UserGUID AND id>1)), N'')
SET @SPName = ISNULL (( SELECT name FROM archGroup WITH (NOLOCK)
						WHERE id = (SELECT dataArchGrpID FROM APP_Application WITH (NOLOCK) WHERE backupSet =@BackupsetId)), N'')
INSERT INTO @t_userCaps
EXECUTE GetUserCapabilities @userId
SET @userCaps = ISNULL((SELECT TOP(1) caps FROM @t_userCaps), 0)
IF ( @userCaps & CONVERT(bigint, (POWER(2.0, 29-1))) = 0 )
BEGIN
	SET @o_errorCode = 2
	SET @o_errorString = 'User does not have Legal Hold Management Rights'
	RETURN
END
IF (@RetainUntil IS NOT NULL AND CONVERT(CHAR(10), @RetainUntil, 101) <> '12/31/9999' AND DATEPART(YEAR, @RetainUntil) >= 2038)
BEGIN
	SET @o_errorCode = 3
	SET @o_errorString = 'RetainUntil Date not supported.'
	RETURN
END
INSERT INTO DM2CompliancePolicy (CompPolicyID,	CompPolicyName, CompPolicyDesc, RetainUntil, BackupsetId, Attribute, UserGUID, CreateTime, ModifiedTime, ownerUserId,emailIds,flags)
VALUES (@CompPolicyID,	@CompPolicyName, @CompPolicyDesc, @RetainUntil, @BackupsetId, @Attribute, @UserGUID,	@CreateTime, @ModifiedTime, @userId,@emailIds,@flags)
-- If we get success, then capture legal hold Id and give Change Security Settings permission so that Share feature works with new security model
--
IF @@ERROR = 0
BEGIN
	SET @LHId = SCOPE_IDENTITY()
SET @permissionsList = CAST(107 as nvarchar(10))
	EXEC sec_setDM2CreatorOwner @entityType, @userId, @LHId, @o_ErrorCode OUTPUT, @o_ErrorString OUTPUT
END
ELSE
BEGIN
	SET @o_errorCode = 4
	SET @o_errorString = 'Inserting entry into database failed.'
	GOTO ExitLine
END
-- audit..
INSERT INTO DM2CompliancePolicyAudit (CompPolicyID, ModifiedTime, ModifiedUserGUID, Notes)
VALUES (@CompPolicyID, @ModifiedTime, @UserGUID, 'Created the LegalHold - ' + @CompPolicyName)
-- SET GUI AUDIT OPERATION
	DECLARE @opEvMsgId          INT
	DECLARE @opId               INT
DECLARE  @opMsgId			INT = (208 | (CAST(POWER(2, 24) AS BIGINT) * 84))
DECLARE  @paramMsgId 		INT = (411 | (CAST(POWER(2, 24) AS BIGINT) * 85))
	EXEC EvGuiAuditSetOperation @opMsgId, @userId, @opEvMsgId OUTPUT, @opId OUTPUT
	-- SET GUI AUDIT PARAMETER
	EXEC EvGuiAuditSetParamData @opId, @CompPolicyName, 0
	EXEC EvGuiAuditSetParamData @opId, @SPName, 0
	EXEC EvGuiAuditSetParamData @opId, @UserName, 0
	EXEC EvGuiAuditSetParamData @opId, @domainName, 0
	EXEC EvGuiAuditSetParamData @opId, @CompPolicyDesc, 0
	IF (@retainUntil IS NOT null)
		IF @retainUntil = '12-31-9999'
			EXEC EvGuiAuditSetParamData @opId, 'Infinite', 0
		ELSE
			EXEC EvGuiAuditSetParamData @opId, @RetainUntil, 0
	ELSE
		EXEC EvGuiAuditSetParamData @opId, 'Infinite', 0
	EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
ExitLine:
IF @sendOutput<> 0
BEGIN
SELECT	1					as TAG,
			0					as Parent,
			@o_errorCode			as [CVGui_GenericResp!1!errorCode],
			@o_errorString			as [CVGui_GenericResp!1!errorMessage]
		FOR XML EXPLICIT
END
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'DM2AddLegalHold')
	delete from GxQscripts where name = 'DM2AddLegalHold'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2AddLegalHold')
	delete from GXDBVersions where aliasname = 'DM2AddLegalHold'
GO

insert into GXDBVersions values(2, 'DM2AddLegalHold',  '00010012008800030000', 'DM2AddLegalHold', '00010012008800030000')
GO

