

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DLPClientGroupProp.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DLPClientGroupProp.sp,v $ $Id: DLPClientGroupProp.sp,v 1.4.60.1 2017/02/10 21:48:12 sjohnson Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DLPClientGroupProp <<<'

IF EXISTS (select * from sysobjects where name='DLPClientGroupProp')
	drop procedure DLPClientGroupProp
IF EXISTS (select * from GxQscripts where name='DLPClientGroupProp')
	delete from GxQscripts where name = 'DLPClientGroupProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DLPClientGroupProp')
	delete from GXDBVersions where aliasname = 'DLPClientGroupProp'
GO
print '... Creating Procedure: DLPClientGroupProp'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DLPClientGroupProp
  @groupId INT,
  @isPIT INT,
  @createdTime INT,
  @attrName NVARCHAR(1024),
  @newAttrVal NVARCHAR(MAX)
AS
  DECLARE @errCode integer = 0
  DECLARE @hasChanged integer = 0
  DECLARE @propId integer
  DECLARE @errString varchar(1024) = ''
BEGIN TRY
DECLARE @nowTime	AS integer = dbo.GetUnixTime (GetUTCdate())
DECLARE @status		AS integer = 0
DECLARE	@oldVal		nvarchar(MAX)
	IF @createdTime <> 0
		SET @nowTime = @createdTime
	SELECT @propId = id, @oldVal = [attrVal]
		FROM DlpGroupProp
		WHERE [groupId] = @groupId
		  AND [attrName] = @attrName
		  AND modified = 0
	IF @propId IS NOT NULL AND @oldVal = @newAttrVal
	BEGIN
		SET @errString = 'DlpGroup['+ convert(varchar(5), @groupId) +'], Property [' + @attrName + '] has not changed.'
		GOTO SKIP
	END
	SET	@hasChanged	= 1
	IF @propId IS NOT NULL
	BEGIN
		IF @isPIT <> 0
		BEGIN
			-- "AGE" OLD PROPERTY VALUE:
			UPDATE DlpGroupProp SET [modified] = @nowTime
				WHERE id = @propId
			SET @propId = NULL	-- "FORCE" creation of a new row for new value
		END
		ELSE
--				NOT PIT, SO JUST UPDATE THE CURRENT VALUE
		BEGIN
			UPDATE DlpGroupProp SET [attrVal] = @newAttrVal
			WHERE id = @propId
		END
	END
--	EITHER A BRAND NEW PROPERTY OR WE JUST AGED A PIT PROPERTY:
	IF @propId IS NULL
	BEGIN
		INSERT DlpGroupProp ([groupId], [attrName], [attrVal], created, modified)
			VALUES (@groupId, @attrName, @newAttrVal, @nowTime, 0)
			SET @propId = @@IDENTITY
	END
SKIP:
END	  TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
   set @errCode = ERROR_NUMBER()
   set @errString = 'Problems executing [' +ERROR_PROCEDURE() +'], Line['
					+ CONVERT(nvarchar(10),ERROR_LINE()) + '] :' +ERROR_MESSAGE()
END	  CATCH
SELECT @errCode, @hasChanged, @propId, @errString
GO

IF EXISTS (select * from GxQscripts where name = 'DLPClientGroupProp')
	delete from GxQscripts where name = 'DLPClientGroupProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DLPClientGroupProp')
	delete from GXDBVersions where aliasname = 'DLPClientGroupProp'
GO

insert into GXDBVersions values(2, 'DLPClientGroupProp',  '00010004006000010000', 'DLPClientGroupProp', '00010004006000010000')
GO

