

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DIAGTableRowChangeTrackingTriggerCtrl.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DIAGTableRowChangeTrackingTriggerCtrl.sp,v $ $Id: DIAGTableRowChangeTrackingTriggerCtrl.sp,v 1.1.2.1 2018/09/02 03:19:20 abilbrey Exp $";
-- Procedure Name
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DIAGTableRowChangeTrackingTriggerCtrl <<<'

IF EXISTS (select * from sysobjects where name='DIAGTableRowChangeTrackingTriggerCtrl')
	drop procedure DIAGTableRowChangeTrackingTriggerCtrl
IF EXISTS (select * from GxQscripts where name='DIAGTableRowChangeTrackingTriggerCtrl')
	delete from GxQscripts where name = 'DIAGTableRowChangeTrackingTriggerCtrl'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DIAGTableRowChangeTrackingTriggerCtrl')
	delete from GXDBVersions where aliasname = 'DIAGTableRowChangeTrackingTriggerCtrl'
GO
print '... Creating Procedure: DIAGTableRowChangeTrackingTriggerCtrl'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DIAGTableRowChangeTrackingTriggerCtrl
-- Input arguments
-- 0:disable, 1:enable DIAG Triggers
  @enable INT,
-- Name of Table to enable / disable Diag Trigger on.  If '' enable / disable all Diag Table Triggers that exist
  @tableName NVARCHAR(128) = ''
AS
BEGIN
	SET NOCOUNT ON
	IF (@@TRANCOUNT > 0)
	BEGIN
		-- do not want to create schema locks so only want implicit transactions around each command
		-- to avoid causing a long locking / blocking chain for the entire execution on the CommServer.
		RAISERROR('Error: DIAGTableRowChangeTrackingTriggerCtrl Transaction Started, not allowed by this SP', 16, 1)
		RETURN
	END
	-- Setup Trigger Command
	DECLARE @rc INT = 0
	DECLARE @ctrl NVARCHAR(128) = N'DISABLE'
	DECLARE @smsg VARCHAR(512) = ''
	SELECT @ctrl = N'ENABLE' WHERE @enable > 0
	DECLARE @triggerStmt NVARCHAR(MAX) = ''
	-- generate enable / disable trigger commands
	IF (@tableName IS NULL OR @tableName = N'')
	BEGIN
		-- Command for all Triggers to be enabled or disabled
		SELECT
			@triggerStmt += @ctrl + N' TRIGGER ' + s.name + N'.' + t.name +  N' ON ' + s.name + N'.' + tbl.name + N'; ' + NCHAR(13) + NCHAR(10)
		FROM
			sys.triggers t
			INNER JOIN sys.objects o ON
				o.object_id = t.object_id
			INNER JOIN sys.schemas s ON
				s.schema_id = o.schema_id
			INNER JOIN sys.objects tbl ON
				tbl.object_id = o.parent_object_id
		WHERE
			t.name LIKE '%_DIAGChangeTracking'
			AND t.is_disabled <> IIF(@enable = 1, 0, 1)			-- Setup trigger commands that do not match.
	END
	ELSE
	BEGIN
		-- Individual Named Table Trigger Command
		SELECT
			@triggerStmt += @ctrl + N' TRIGGER ' + s.name + N'.' + t.name +  N' ON ' + s.name + N'.' + tbl.name + N'; ' + NCHAR(13) + NCHAR(10)
		FROM
			sys.triggers t
			INNER JOIN sys.objects o ON
				o.object_id = t.object_id
			INNER JOIN sys.schemas s ON
				s.schema_id = o.schema_id
			INNER JOIN sys.objects tbl ON
				tbl.object_id = o.parent_object_id
		WHERE
			t.name = @tableName + '_DIAGChangeTracking'
			AND t.is_disabled <> IIF(@enable = 1, 0, 1)			-- Setup trigger commands that do not match.
	END
	IF (@triggerStmt <> '')
	BEGIN
		--PRINT @triggerStmt
		EXEC @rc = sp_executesql @stmt = @triggerStmt
		IF (@tableName IS NULL OR @tableName = N'')
		BEGIN
			PRINT 'DIAGTableRowChangeTrackingTriggerCtrl: Diagnostic Table Row Change Tracking Triggers [' + @ctrl + '].'
		END
		ELSE
		BEGIN
			PRINT 'DIAGTableRowChangeTrackingTriggerCtrl: Diagnostic ' + @tableName + ' Table Row Change Tracking Triggers [' + @ctrl + '].'
		END
	END
	ELSE
	BEGIN
		PRINT 'DIAGTableRowChangeTrackingTriggerCtrl: No trigger command to execute.'
	END
	-- Configure SQLAGent Job based on active / inactive triggers
	-- so that Pruning and Event Alert Handling matches operations.
	DECLARE @agentRC INT = 0
	DECLARE @inOpCode INT = 0
	DECLARE @status VARCHAR(32) = ''
	IF EXISTS (
		SELECT
			1
		FROM sys.triggers WITH(NOLOCK)
		WHERE name LIKE '%_DIAGChangeTracking'
		HAVING COUNT(is_disabled) <> SUM(CAST(is_disabled AS INT))
	)
	BEGIN
		-- triggers active create SQLAgent Job if it does not exist
		SET @inOpCode = 1		-- add job
		SET @status = 'ENABLED'
	END
	ELSE
	BEGIN
		-- No triggers active delete SQLAgent Job
		SET @inOpCode = 2		-- delete job
		SET @status = 'DISABLED'
	END
	-- Perform requested operation
	EXEC @agentRC = DIAGTableRowChangeTrackingAlertSQLAgentJob @opCode=@inOpCode
	IF (@agentRC > 0)
	BEGIN
		PRINT 'DIAGTableRowChangeTrackingTriggerCtrl: DIAGTableRowChangeTrackingAlertSQLAgentJob returned errorCode[' + CAST(@agentRC AS VARCHAR(12)) + ']'
		SET @smsg = 'DIAGTableRowChangeTrackingTriggerCtrl failed to ' + IIF(@inOpCode = 1, 'configure', 'de-configure') + ' CS_DIAG_TableRowChangeTracking SQL Agent Job'
		RAISERROR(@smsg, 0, 0) WITH LOG
	END
	ELSE
	BEGIN
		IF (@inOpCode = 1)
		BEGIN
			-- Enabled Job - separate step just in case the Job already exist
			EXEC @agentRC = DIAGTableRowChangeTrackingAlertSQLAgentJob @opCode=4
			IF (@agentRC > 0)
			BEGIN
				PRINT 'DIAGTableRowChangeTtackingTriggerCtrl: DIAGTableRowChangeTrackingAlertSQLAgentJob returned errorCode[' + CAST(@agentRC AS VARCHAR(12)) + ']'
				SET @smsg = 'DIAGTableRowChangeTrackingTriggerCtrl failed to enable CS_DIAG_TableRowChangeTracking SQL Agent Job'
				RAISERROR(@smsg, 0, 0) WITH LOG
			END
		END
	END
	SET @smsg = 'DIAG_TableRowChangeTracking Triggers have been [' + @status + ']'
	RAISERROR(@smsg, 0, 0) WITH LOG
END
GO

IF EXISTS (select * from GxQscripts where name = 'DIAGTableRowChangeTrackingTriggerCtrl')
	delete from GxQscripts where name = 'DIAGTableRowChangeTrackingTriggerCtrl'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DIAGTableRowChangeTrackingTriggerCtrl')
	delete from GXDBVersions where aliasname = 'DIAGTableRowChangeTrackingTriggerCtrl'
GO

insert into GXDBVersions values(2, 'DIAGTableRowChangeTrackingTriggerCtrl',  '00010001000200010000', 'DIAGTableRowChangeTrackingTriggerCtrl', '00010001000200010000')
GO

