

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DIAGTableRowChangeTrackingPruner.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DIAGTableRowChangeTrackingPruner.sp,v $ $Id: DIAGTableRowChangeTrackingPruner.sp,v 1.1.2.1 2018/09/02 03:19:11 abilbrey Exp $";
-- Procedure Name
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DIAGTableRowChangeTrackingPruner <<<'

IF EXISTS (select * from sysobjects where name='DIAGTableRowChangeTrackingPruner')
	drop procedure DIAGTableRowChangeTrackingPruner
IF EXISTS (select * from GxQscripts where name='DIAGTableRowChangeTrackingPruner')
	delete from GxQscripts where name = 'DIAGTableRowChangeTrackingPruner'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DIAGTableRowChangeTrackingPruner')
	delete from GXDBVersions where aliasname = 'DIAGTableRowChangeTrackingPruner'
GO
print '... Creating Procedure: DIAGTableRowChangeTrackingPruner'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DIAGTableRowChangeTrackingPruner
  @rowsPruned INT OUTPUT
AS
BEGIN
	SET NOCOUNT ON
	SET @rowsPruned = 0
	IF EXISTS (
		SELECT
			1
		FROM sys.triggers WITH(NOLOCK)
		WHERE name LIKE '%_DIAGChangeTracking'
		HAVING COUNT(is_disabled) <> SUM(CAST(is_disabled AS INT))
	)
	BEGIN
		-- Some Diagnostic Triggers enabled, check need to prune collection table
		DECLARE @totalRowsPruned INT = 0
		-- Lookup DIAG_TableRowChangeTracking Pruning Time Frame
		DECLARE @pruneDays INT = 5	-- default 1 day / 24 hours
		SELECT
			@pruneDays = CAST(value AS INTEGER)
		FROM GXGlobalParam WITH(NOLOCK)
		WHERE name = 'DIAGChangeTrackingPruneDays'
		IF (@pruneDays < 1 OR @pruneDays > 14)
		BEGIN
			SET @pruneDays = 5
			PRINT 'DIAGTableRowChangeTrackingPruner: Warning invalid GXGlobalParam::DIAGChangeTrackingPruneDays value.'
		END
		DECLARE @pruneDate DATETIME = DATEADD(day, -@pruneDays, GETUTCDATE())
		DECLARE @delRowCnt INT = 1
		WHILE (@delRowCnt > 0)
		BEGIN
			-- Batch deleting to keep implicit transaction short
			DELETE TOP (200)
			FROM DIAG_TableRowChangeTracking
			WHERE created < @pruneDate
			SET @delRowCnt = @@ROWCOUNT
			SET @totalRowsPruned += @delRowCnt
		END
		-- 50K row check if more pruning needed
		DECLARE @rcnt INT
		DECLARE @maxId INT
		SELECT
			@rcnt = COUNT(*),
			@maxId = MAX(id)
		FROM DIAG_TableRowChangeTracking WITH(NOLOCK)
		IF (@rcnt >= 50000)		-- make this a tunable in GXGlobalParams?
		BEGIN
			DECLARE @delId INT = (@maxId - 50000)	-- delete all ids less then this one
			SET @delRowCnt = 1
			WHILE (@delRowCnt > 0)
			BEGIN
				-- Batch deleting to keep implicit transaction short
				DELETE TOP (200)
				FROM DIAG_TableRowChangeTracking
				WHERE id < @delId
				SET @delRowCnt = @@ROWCOUNT
				SET @totalRowsPruned += @delRowCnt
			END
		END
		IF (@totalRowsPruned > 0)
		BEGIN
			PRINT 'DIAGTableRowChangeTrackingPruner: DIAG_TableRowChangeTracking Table Rows Deleted [' + CAST(@totalRowsPruned AS VARCHAR(12)) + ']'
		END
	END
	SET @rowsPruned = @totalRowsPruned
END
GO

IF EXISTS (select * from GxQscripts where name = 'DIAGTableRowChangeTrackingPruner')
	delete from GxQscripts where name = 'DIAGTableRowChangeTrackingPruner'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DIAGTableRowChangeTrackingPruner')
	delete from GXDBVersions where aliasname = 'DIAGTableRowChangeTrackingPruner'
GO

insert into GXDBVersions values(2, 'DIAGTableRowChangeTrackingPruner',  '00010001000200010000', 'DIAGTableRowChangeTrackingPruner', '00010001000200010000')
GO

