

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DIAGTableRowChangeTrackingEventCheck.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DIAGTableRowChangeTrackingEventCheck.sp,v $ $Id: DIAGTableRowChangeTrackingEventCheck.sp,v 1.1.2.1 2018/09/02 03:19:17 abilbrey Exp $";
-- Procedure Name
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DIAGTableRowChangeTrackingEventCheck <<<'

IF EXISTS (select * from sysobjects where name='DIAGTableRowChangeTrackingEventCheck')
	drop procedure DIAGTableRowChangeTrackingEventCheck
IF EXISTS (select * from GxQscripts where name='DIAGTableRowChangeTrackingEventCheck')
	delete from GxQscripts where name = 'DIAGTableRowChangeTrackingEventCheck'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DIAGTableRowChangeTrackingEventCheck')
	delete from GXDBVersions where aliasname = 'DIAGTableRowChangeTrackingEventCheck'
GO
print '... Creating Procedure: DIAGTableRowChangeTrackingEventCheck'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DIAGTableRowChangeTrackingEventCheck
-- NO Input arguments
AS
BEGIN
	SET NOCOUNT ON
	IF EXISTS (
		SELECT
			1
		FROM sys.triggers WITH(NOLOCK)
		WHERE name LIKE '%_DIAGChangeTracking'
		HAVING COUNT(is_disabled) = SUM(CAST(is_disabled AS INT))
	)
	BEGIN
		-- Return DIAG Triggers disabled - nothing to do.
		RETURN
	END
	-- Execute Pruner to delete older data rows
	DECLARE @rowsPruned INT = 0
	EXEC DIAGTableRowChangeTrackingPruner @rowsPruned OUTPUT
	IF (@rowsPruned > 0)
	BEGIN
		DECLARE @msg VARCHAR(512) = 'DIAGTableRowChangeTrackingPruner rows deleted [' + CAST(@rowsPruned AS VARCHAR(12)) + ']'
		RAISERROR(@msg, 0, 0) WITH LOG
	END
	-- 50K row check after pruning
	DECLARE @rcnt INT
	SELECT
		@rcnt = COUNT(*)
	FROM DIAG_TableRowChangeTracking WITH(NOLOCK)
	IF (@rcnt >= 50000)		-- make this a tunable in GXGlobalParams?
	BEGIN
		-- Create an Event
		-- Warning the DIAG_TableRowChangeTracking Table has exceeded 50,000 rows.
DECLARE @messageId INTEGER = (3774 | (CAST(POWER(2, 24) AS BIGINT) * 35))	-- create message in guimsglocale.tab  (3774 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		DECLARE @evMsgId		INT
		DECLARE @clientName		NVARCHAR(256);
		DECLARE @now			INT = dbo.getUnixTime(GETUTCDATE())
		DECLARE @NextEvIDTable TABLE (id INT)
		DECLARE @csId			INT = 2
		INSERT INTO @NextEvIDTable
			EXEC GetNextEventId
		SELECT
			@evMsgId = id
		FROM @NextEvIDTable
		SELECT
			@clientName = name
		FROM APP_Client WITH(NOLOCK)
		WHERE id = @csId		--CSId
		INSERT INTO EvMsg (
			id
			,TimeSource
			,TimeServer
			,Severity
			,Ack
			,Acked
			,Type
			,ParamNum
			,MessageId
			,JobId_h
			,JobId_l
			,ClientId
			,CommcellId
			,UserId
			,SubSystemId
			,Client
			,CommCell
			,UserName
			,SubSystem
			,MsgEnglish
			,RepeatCount
			,LastOccurrence
			,NextPost
			,mediaId
			,driveId
			,libraryId
			,maClientId
        )
		VALUES (
			@evMsgId        --id
			,@now           --TimeSource
			,@now           --TimeServer
			,0              --Severity
			,0              --Ack
			,0              --Acked
			,0              --Type
			,0              --ParamNum
			,@messageId     --MessageId
			,0              --JobId_h
			,0              --JobId_l
			,@csId          --ClientId
			,@csId          --CommcellId
			,0              --UserId
			,0              --SubSystemId
			,@clientName    --Client
			,''             --CommCell
			,''             --UserName
			,'SQLServerAgent CS_DIAG_TableRowChangeTracking'    --SubSystem
			,''             --MsgEnglish
			,1              --RepeatCount
			,@now           --LastOccurrence
			,1              --NextPost
			,0              --driveId
			,0              --driveId
			,0              --libraryId
			,@csId          --maClientId
		)
		DECLARE @wmsg VARCHAR(512) = 'DIAG_TableRowChangeTracking Table has exceeded 50,000 rows, current row count at [' + CAST(@rcnt AS VARCHAR(12)) + ']'
		RAISERROR(@wmsg, 0, 0) WITH LOG
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'DIAGTableRowChangeTrackingEventCheck')
	delete from GxQscripts where name = 'DIAGTableRowChangeTrackingEventCheck'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DIAGTableRowChangeTrackingEventCheck')
	delete from GXDBVersions where aliasname = 'DIAGTableRowChangeTrackingEventCheck'
GO

insert into GXDBVersions values(2, 'DIAGTableRowChangeTrackingEventCheck',  '00010001000200010000', 'DIAGTableRowChangeTrackingEventCheck', '00010001000200010000')
GO

