

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DIAGTableRowChangeTrackingAlertSQLAgentJob.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DIAGTableRowChangeTrackingAlertSQLAgentJob.sp,v $ $Id: DIAGTableRowChangeTrackingAlertSQLAgentJob.sp,v 1.1.2.1 2018/09/02 03:19:14 abilbrey Exp $";
--===================================================================
--	SQL Server Agent Job to monitor the DIAG_TableRowChangeTracking
--	Table row count to generate an Event / Alert when the count
--	exceeds 50,000 rows.  The Pruner may not be able to keep.
--===================================================================
-- Procedure Name
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DIAGTableRowChangeTrackingAlertSQLAgentJob <<<'

IF EXISTS (select * from sysobjects where name='DIAGTableRowChangeTrackingAlertSQLAgentJob')
	drop procedure DIAGTableRowChangeTrackingAlertSQLAgentJob
IF EXISTS (select * from GxQscripts where name='DIAGTableRowChangeTrackingAlertSQLAgentJob')
	delete from GxQscripts where name = 'DIAGTableRowChangeTrackingAlertSQLAgentJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DIAGTableRowChangeTrackingAlertSQLAgentJob')
	delete from GXDBVersions where aliasname = 'DIAGTableRowChangeTrackingAlertSQLAgentJob'
GO
print '... Creating Procedure: DIAGTableRowChangeTrackingAlertSQLAgentJob'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DIAGTableRowChangeTrackingAlertSQLAgentJob
-- opCode Flag Bit Argument: add:1, delete:2, enable:4, disable:8
  @opCode INT = 0,
  @help INT = 0
AS
BEGIN
	SET NOCOUNT ON
	DECLARE @errorCode  INT = 0
	IF (@help > 0 OR @opCode = 0 OR @opCode IS NULL)
	BEGIN
		PRINT 'DIAGTableRowChangeTrackingAlertSQLAgentJob: Usage @opCode=(Flag Bits: add:1, delete:2, enable:4, disable:8) @help=1--this usage message'
		GOTO END_PROC
	END
	-- Is job aready configured?
	DECLARE @cfgJobId UNIQUEIDENTIFIER = NULL
	SELECT
		@cfgJobId = job_id
	FROM msdb.dbo.sysjobs WITH(NOLOCK)
	WHERE
		name = N'CS_DIAG_TableRowChangeTracking'
	-- Perform requested operation
	DECLARE @jobEnabled TINYINT = 0
	IF ((@opCode & 1) = 1)
	BEGIN
		-- Add SQL Agent Job
		IF (@cfgJobId IS NOT NULL)
		BEGIN
			-- Nothing to add, already configured
			GOTO END_PROC
		END
		BEGIN TRANSACTION
		DECLARE @ReturnCode INT
		DECLARE @schGUID NVARCHAR(40) = NEWID()
		SET @ReturnCode = 0
		IF NOT EXISTS (SELECT name FROM msdb.dbo.syscategories WHERE name=N'Commserver Database Diagnostic Utilities' AND category_class=1)
		BEGIN
			EXEC @ReturnCode = msdb.dbo.sp_add_category @class=N'JOB', @type=N'LOCAL', @name=N'Commserver Database Diagnostic Utilities'
			IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO ERROR_PROC
		END
		IF ((@opCode & 4) = 4)
		BEGIN
			SET @jobEnabled = 1
		END
		DECLARE @jobId UNIQUEIDENTIFIER
		EXEC @ReturnCode =  msdb.dbo.sp_add_job
				@job_name=N'CS_DIAG_TableRowChangeTracking',
				@enabled=@jobEnabled,
				@notify_level_eventlog=0,
				@notify_level_email=0,
				@notify_level_netsend=0,
				@notify_level_page=0,
				@delete_level=0,
				@description=N'Monitors DIAG_TableRowChangeTracking Table row count for alert event.',
				@category_name=N'Commserver Database Diagnostic Utilities',
				@owner_login_name=N'sqladmin_cv',
				@job_id = @jobId OUTPUT
		IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO ERROR_PROC
		DECLARE @db NVARCHAR(MAX) = DB_NAME()
		DECLARE @cmd NVARCHAR(MAX) = N'EXEC ' + @db + '.dbo.DIAGTableRowChangeTrackingEventCheck'
		EXEC @ReturnCode = msdb.dbo.sp_add_jobstep
				@job_id=@jobId,
				@step_name=N'Check DIAG_TableRowChangeTracking Table Row Count.',
				@step_id=1,
				@cmdexec_success_code=0,
				@on_success_action=1,
				@on_success_step_id=0,
				@on_fail_action=2,
				@on_fail_step_id=0,
				@retry_attempts=0,
				@retry_interval=0,
				@os_run_priority=0,
				@subsystem=N'TSQL',
				@command=@cmd,
				@database_name=@db,
				@flags=0
		IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO ERROR_PROC
		EXEC @ReturnCode = msdb.dbo.sp_add_jobschedule
				@job_id=@jobId,
				@name=N'CS_DIAG_TableRowChangeTracking_Schedule',
				@enabled=1,			-- enabled the job schedule
				@freq_type=4,
				@freq_interval=1,
				@freq_subday_type=1,
				@freq_subday_interval=0,
				@freq_relative_interval=0,
				@freq_recurrence_factor=0,
				@active_start_date=20180806,
				@active_end_date=99991231,
				@active_start_time=220000,
				@active_end_time=235959,
				@schedule_uid=@schGUID
		IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO ERROR_PROC
		EXEC @ReturnCode = msdb.dbo.sp_add_jobserver @job_id = @jobId, @server_name = N'(local)'
		IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO ERROR_PROC
		COMMIT TRANSACTION
		GOTO END_PROC
	END
	ELSE IF ((@opCode & 2) = 2)
	BEGIN
		IF (@cfgJobId IS NULL)
		BEGIN
			-- Nothing to delete
			GOTO END_PROC
		END
		-- Delete SQL Agent Job
		BEGIN TRANSACTION
		EXEC @ReturnCode =  msdb.dbo.sp_delete_job
				@job_name=N'CS_DIAG_TableRowChangeTracking'
		IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO ERROR_PROC
		COMMIT TRANSACTION
		GOTO END_PROC
	END
	ELSE IF ((@opCode & (4|8)) > 0)
	BEGIN
		-- Enable or Disable SQL Agent Job
		IF (@cfgJobId IS NULL)
		BEGIN
			SET @errorCode = 1
			PRINT 'DIAGCreateTableRowChangeTrackingAlertSQLAgentJob: SQL Agent Job does not exist'
			GOTO END_PROC
		END
		IF ((@opCode & 4) = 4)
		BEGIN
			SET @jobEnabled = 1
		END
		BEGIN TRANSACTION
		EXEC @ReturnCode = msdb.dbo.sp_update_job
				@job_id = @cfgJobId,
				@start_step_id = 1,
				@enabled=@jobEnabled
		IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO ERROR_PROC
		COMMIT TRANSACTION
		GOTO END_PROC
	END
	ELSE
	BEGIN
		-- Unknown opCode operation
		SET @errorCode = 1
		PRINT 'DIAGCreateTableRowChangeTrackingAlertSQLAgentJob: Invalid input for @opCode argument'
		GOTO END_PROC
	END
	ERROR_PROC:
		IF (@ReturnCode > 0)
		BEGIN
			SET @errorCode = @ReturnCode
		END
		ELSE IF (@@ERROR > 0)
		BEGIN
			SET @errorCode = @@ERROR
		END
		ELSE
		BEGIN
			SET @errorCode = 1
		END
		IF (@@TRANCOUNT > 0)
			ROLLBACK TRANSACTION
	END_PROC:
	RETURN @errorCode
END
GO

IF EXISTS (select * from GxQscripts where name = 'DIAGTableRowChangeTrackingAlertSQLAgentJob')
	delete from GxQscripts where name = 'DIAGTableRowChangeTrackingAlertSQLAgentJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DIAGTableRowChangeTrackingAlertSQLAgentJob')
	delete from GXDBVersions where aliasname = 'DIAGTableRowChangeTrackingAlertSQLAgentJob'
GO

insert into GXDBVersions values(2, 'DIAGTableRowChangeTrackingAlertSQLAgentJob',  '00010001000200010000', 'DIAGTableRowChangeTrackingAlertSQLAgentJob', '00010001000200010000')
GO

