

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DCUpgradeVisibilityInfo.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  DCPackageValidation()
--  | Description:  Save (insert or update) package information
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DCUpgradeVisibilityInfo.sp,v $ $Id: DCUpgradeVisibilityInfo.sp,v 1.3.12.1.68.1 2021/01/13 12:01:08 sgolla Exp $";
SET ANSI_NULLS ON
-- StringToString type creation done from upgrade script of DCPackageVisibility.
-- Reason: This is now used in multiple places.. for example SEFindIndexGateway function also needs the type..
-- so the definition of type should not remain private and should instead be in upgrade script!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='DCUpgradeVisibilityInfo')
BEGIN
	print '>>> Drop Stored Procedure: DCUpgradeVisibilityInfo <<<'
	drop procedure DCUpgradeVisibilityInfo
END
IF EXISTS (select * from GxQscripts where name='DCUpgradeVisibilityInfo')
	delete from GxQscripts where name = 'DCUpgradeVisibilityInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DCUpgradeVisibilityInfo')
	delete from GXDBVersions where aliasname = 'DCUpgradeVisibilityInfo'
GO
print '... Creating Procedure: DCUpgradeVisibilityInfo'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure DCUpgradeVisibilityInfo
  @GUIDToLoginNameDT dbo.StringToString READONLY
AS
BEGIN
	SET NOCOUNT ON
	update DCPackageVisibility
	SET
		SecuredEntityLoginName =
		(CASE
			WHEN SecuredEntityType IN(2,4) THEN ISNULL((select T.[Value] from @GUIDToLoginNameDT T where T.[Key] = SecuredEntityGuid), '??' + SecuredEntityGuid + '??')
			WHEN SecuredEntityType = 1 THEN ISNULL((select name from UMGroups WITH(NOLOCK) where GUID = cast(SecuredEntityGuid as uniqueidentifier)), '??' + SecuredEntityGuid + '??')
			WHEN SecuredEntityType = 3 THEN ISNULL((select login from UMUsers WITH(NOLOCK) where userGuid = SecuredEntityGuid), '??' + SecuredEntityGuid + '??')
		END)
	select @@ROWCOUNT
END

IF EXISTS (select * from GxQscripts where name = 'DCUpgradeVisibilityInfo')
	delete from GxQscripts where name = 'DCUpgradeVisibilityInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DCUpgradeVisibilityInfo')
	delete from GXDBVersions where aliasname = 'DCUpgradeVisibilityInfo'
GO

insert into GXDBVersions values(2, 'DCUpgradeVisibilityInfo',  'v1.3.12.1.68.1', 'DCUpgradeVisibilityInfo', 'v1.3.12.1.68.1')
GO

