

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DCUpdateSolrConfInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DCUpdateSolrConfInfo <<<'

IF EXISTS (select * from sysobjects where name='DCUpdateSolrConfInfo')
	drop procedure DCUpdateSolrConfInfo
IF EXISTS (select * from GxQscripts where name='DCUpdateSolrConfInfo')
	delete from GxQscripts where name = 'DCUpdateSolrConfInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DCUpdateSolrConfInfo')
	delete from GXDBVersions where aliasname = 'DCUpdateSolrConfInfo'
GO
print '... Creating Procedure: DCUpdateSolrConfInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DCUpdateSolrConfInfo
  @i_xml XML
AS
BEGIN
	/*
		Input sample request
		<?xml version="1.0" encoding="utf-16"?>
		<DBSchemaInfo xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
		  <datasourceId>3</datasourceId>
		  <userId>2</userId>
		  <deleteInfos>
			<EntityInfo>
			  <entityType>1</entityType>
			  <entityName>helt</entityName>
			  <attribute>0</attribute>
			</EntityInfo>
		  </deleteInfos>
		  <infos>
			<EntityInfo>
			  <entityType>1</entityType>
			  <entityName>hel</entityName>
			  <requestInfo>{"fieldName":"hel","operation":1,"datatype":"dt","features":37,"defaultValue":"ad"}</requestInfo>
			  <attribute>0</attribute>
			  <hashInfo>0C6F8DFD6EA1864A81E2DA75F4D8A18D02176AAEC217F65F1B1110AD34C7A288</hashInfo>
			</EntityInfo>
			<EntityInfo>
			  <entityType>1</entityType>
			  <entityName>fiekd2</entityName>
			  <requestInfo>{"fieldName":"fiekd2","operation":1,"datatype":"string","features":41,"defaultValue":"&lt;String&gt; hello this is &amp; and &lt; abd &gt; h &lt; &lt;/String&gt;"}</requestInfo>
			  <attribute>0</attribute>
			</EntityInfo>
		  </infos>
		</DBSchemaInfo>
	*/
	DECLARE @l_datasourceId INT = 0,
			@l_userId		INT = 0,
			@l_currentTime	DATETIME = GETUTCDATE()
	DECLARE @EntityInfos TABLE (
				ID INT	IDENTITY(1,1) PRIMARY KEY,
				EntityType	INT,
				EntityName	NVARCHAR(256),
				RequestInfo	NVARCHAR(MAX),
				HashInfo	VARCHAR(64),
				Status	INT,
				Attribute INT
			)
	DECLARE @DeleteInfos TABLE (
				EntityType	INT,
				EntityName	NVARCHAR(256)
			)
	---parse the input xml
	SELECT @l_datasourceId = @i_xml.value('(/DBSchemaInfo/datasourceId)[1]','INT') ,
			@l_userId =	@i_xml.value('(/DBSchemaInfo/userId)[1]','INT')
	 --
	 --Later decide, if we need to validate again the datasourceId/userId.. for now assume input correct
	 --
	 INSERT INTO @DeleteInfos ( EntityType, EntityName)
	 SELECT	T.field.value('entityType[1]', 'INT')  as EntityType,
		T.field.value('entityName[1]', 'NVARCHAR(512)') as EntityName
	 from @i_xml.nodes('/DBSchemaInfo/deleteInfos/EntityInfo') as T(field)
	 --retrieve add/update options
	 --
	 INSERT INTO @EntityInfos ( EntityType, EntityName, RequestInfo,HashInfo, Status, Attribute)
	 SELECT	T.field.value('entityType[1]', 'INT')  as EntityType,
		T.field.value('entityName[1]', 'NVARCHAR(512)') as EntityName,
		T.field.value('requestInfo[1]', 'NVARCHAR(MAX)') as RequestInfo,
		T.field.value('hashInfo[1]', 'VARCHAR(64)') as HashInfo,
		ISNULL(T.field.value('status[1]', 'INT'), 0) as Status,
		ISNULL(T.field.value('attribute[1]', 'INT'), 0) as Attribute
	 from @i_xml.nodes('/DBSchemaInfo/infos/EntityInfo') as T(field)
	 --delete duplicate EntityType,EntityName.. Do we need it.?
	 ;with tempCte as (
		SELECT I.EntityType, I.EntityName,
				ROW_NUMBER() OVER (PARTITION BY I.EntityType, I.EntityName ORDER BY ID DESC) RowNumber
		  FROM @EntityInfos as I)
		DELETE FROM tempCte wHERE RowNumber > 1
	 --initially delete the informations
	 IF EXISTS (SELECT TOP 1 EntityType FROM @DeleteInfos)
	 BEGIN
		DELETE DC
		FROM  DCSolrConfigInfo DC
			INNER JOIN
			@DeleteInfos as DI
			ON DC.DataSourceId = @l_datasourceId AND DC.EntityType = DI.EntityType AND DC.EntityName = DI.EntityName
	 END
	 --insert or update the value.
	 IF EXISTS (SELECT TOP 1 EntityType FROM @EntityInfos)
	 BEGIN
		MERGE DCSolrConfigInfo as DC
		USING (SELECT * FROM @EntityInfos) as EI
		ON DC.DataSourceId = @l_datasourceId AND DC.EntityType = EI.EntityType AND DC.EntityName = EI.EntityName
		WHEN MATCHED THEN
			UPDATE SET RequestInfo = EI.RequestInfo,
						HashInfo = EI.HashInfo,
						Status = EI.Status,
						LastUpdatedBy = @l_userId,
						LastModifiedTime = @l_currentTime,
						Attribute = EI.Attribute
		WHEN NOT MATCHED THEN
			INSERT (DataSourceId, EntityName, EntityType, RequestInfo,Status, LastUpdatedBy, LastModifiedTime, Attribute,HashInfo)
			values( @l_datasourceId, EI.EntityName, EI.EntityType, EI.RequestInfo, EI.Status, @l_userId, @l_currentTime, EI.Attribute,EI.HashInfo);
	 END
END
GO

IF EXISTS (select * from GxQscripts where name = 'DCUpdateSolrConfInfo')
	delete from GxQscripts where name = 'DCUpdateSolrConfInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DCUpdateSolrConfInfo')
	delete from GXDBVersions where aliasname = 'DCUpdateSolrConfInfo'
GO

insert into GXDBVersions values(2, 'DCUpdateSolrConfInfo',  '00000000000000000000', 'DCUpdateSolrConfInfo', '00000000000000000000')
GO

