

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DCSaveSubCategory.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  DCSaveSubCategory()
--  | Description:  Save (insert or update) subcategory information
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DCSaveSubCategory.sp,v $ $Id: DCSaveSubCategory.sp,v 1.2.88.6 2019/03/25 21:06:19 hravula Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='DCSaveSubCategory')
BEGIN
	print '>>> Drop Stored Procedure: DCSaveSubCategory <<<'
	drop procedure DCSaveSubCategory
END
IF EXISTS (select * from GxQscripts where name='DCSaveSubCategory')
	delete from GxQscripts where name = 'DCSaveSubCategory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DCSaveSubCategory')
	delete from GXDBVersions where aliasname = 'DCSaveSubCategory'
GO
print '... Creating Procedure: DCSaveSubCategory'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DCSaveSubCategory
  @i_SubCategoryId INT, 
  @i_CategoryId INT, 
  @i_Name NVARCHAR(100), 
  @i_Description NVARCHAR(MAX), 
  @i_Attribute INT
AS
BEGIN
SET NOCOUNT ON
	DECLARE @attributeValue INT
	DECLARE @errCode INT = 0
	DECLARE @retMsg varchar(max) = 'Record saved successfully'
	DECLARE @maxLen INT = 0
	DECLARE @cnt INT = 0
DECLARE @ErrorMessage NVARCHAR(4000);
	DECLARE @ErrorSeverity INT;
	DECLARE @ErrorState INT;
	SELECT @maxLen = CHARACTER_MAXIMUM_LENGTH FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'DCSubCategory' AND COLUMN_NAME = 'SubCategoryName'
	IF ISNULL(@i_Attribute, 0) = 0
		SELECT @attributeValue = EntryValue FROM DCReference WHERE TypeName = 'Attribute' AND EntryName = 'AdminSaved'
	ELSE
	BEGIN
		SELECT @attributeValue = EntryValue FROM DCReference WHERE TypeName = 'Attribute' AND EntryValue = @i_Attribute
		IF ISNULL(@attributeValue, 0) = 0
			SELECT @attributeValue = SUM(EntryValue) FROM
			(
				SELECT DISTINCT EntryValue FROM DCReference WHERE TypeName = 'Attribute'  AND (EntryValue & @i_Attribute) > 0
			) T
	END
	IF @attributeValue IS NULL
		SELECT @errCode = 10021, @retMsg = 'Specified attribute ' + @i_Attribute + ' not found for saving sub category'
	ELSE IF @attributeValue = 8
	BEGIN
		IF @i_SubCategoryId = NULL or @i_SubCategoryId = 0
		SELECT @errCode = 10022, @retMsg = 'SubCategory name not provided'
		BEGIN TRY
		BEGIN TRAN
		UPDATE DCPackage SET SubCategoryId = NULL WHERE SubCategoryId = @i_SubCategoryId
		DELETE FROM DCSubCategory where SubCategoryId = @i_SubCategoryId
		SELECT @i_CategoryId = @@IDENTITY, @cnt = @@ROWCOUNT
		IF @cnt = 0
			SELECT @errCode = 10027, @retMsg = 'No rows updated. Category specified is invalid.'
		COMMIT TRAN
		END TRY
		BEGIN CATCH
		ROLLBACK TRAN
		SELECT @ErrorMessage = ERROR_MESSAGE(),@ErrorSeverity = ERROR_SEVERITY(),@ErrorState = ERROR_STATE();
		RAISERROR (@ErrorMessage,@ErrorSeverity,@ErrorState);
		END CATCH
	END
	ELSE IF @i_Name = '' or @i_Name = NULL
		SELECT @errCode = 10022, @retMsg = 'SubCategory name not provided'
	ELSE IF EXISTS (SELECT * FROM DCSubCategory WHERE SubCategoryName = @i_Name AND CategoryId = @i_CategoryId) AND ISNULL(@i_SubCategoryId, 0) = 0
		SELECT @errCode = 10023, @retMsg = 'Sub Category name already exists for given category'
	ELSE IF LEN(ISNULL(@i_Name,'')) > @maxLen
		SELECT @errCode = 10024, @retMsg = 'Sub Category name has more than than ' + CONVERT(VARCHAR, @maxLen) + ' characters'
	ELSE IF NOT EXISTS (SELECT * FROM DCCategory WHERE CategoryId = @i_CategoryId)
		SELECT @errCode = 10025, @retMsg = 'Category specified is invalid'
	ELSE IF EXISTS (SELECT 1 FROM DCSubCategory WHERE SubCategoryName = @i_Name AND CategoryId = @i_CategoryId And SubCategoryId <> @i_SubCategoryId
	AND EXISTS (SELECT 1 FROM DCSubCategory WHERE SubCategoryId = @i_SubCategoryId AND SubCategoryName <> @i_Name))
        SELECT @errCode = 10026, @retMsg = 'Sub Category name already exists for given category'
	ELSE
	BEGIN
		IF @i_SubCategoryId = 0 or @i_SubCategoryId = NULL
		BEGIN
		BEGIN TRY
			BEGIN TRAN
				INSERT INTO DCSubCategory (SubCategoryName, Description, Attribute, CategoryId, CreateTime)
				SELECT @i_Name, @i_Description, @attributeValue, @i_CategoryId, GETUTCDATE()
				SELECT @i_SubCategoryId = @@IDENTITY
				COMMIT TRAN
		END TRY
		BEGIN CATCH
		ROLLBACK TRAN
		SELECT @ErrorMessage = ERROR_MESSAGE(),@ErrorSeverity = ERROR_SEVERITY(),@ErrorState = ERROR_STATE();
		RAISERROR (@ErrorMessage,@ErrorSeverity,@ErrorState);
		END CATCH
		END
		ELSE
		BEGIN
		BEGIN TRY
			BEGIN TRAN
			UPDATE DCSubCategory
			SET SubCategoryName = @i_Name, Description = @i_Description, Attribute = @attributeValue, CategoryId = @i_CategoryId, ModifiedTime = GETUTCDATE()
			WHERE SubCategoryId = @i_SubCategoryId
			SELECT @cnt = @@ROWCOUNT
			IF @cnt = 0
				SELECT @errCode = 10027, @retMsg = 'No rows updated. Category specified is invalid.'
			COMMIT TRAN
		END TRY
		BEGIN CATCH
		ROLLBACK TRAN
		SELECT @ErrorMessage = ERROR_MESSAGE(),@ErrorSeverity = ERROR_SEVERITY(),@ErrorState = ERROR_STATE();
		RAISERROR (@ErrorMessage,@ErrorSeverity,@ErrorState);
		END CATCH
		END
	END
	IF @errCode <> 0 AND ISNULL(@retMsg, '') = ''
		SELECT @retMsg = ISNULL(Text, 'Unexpected error occurred') FROM SYS.messages where message_id = @errCode
	SELECT @errCode AS ReturnCode, @retMsg AS ReturnMessage, @i_SubCategoryId AS ReturnId
END
GO

IF EXISTS (select * from GxQscripts where name = 'DCSaveSubCategory')
	delete from GxQscripts where name = 'DCSaveSubCategory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DCSaveSubCategory')
	delete from GXDBVersions where aliasname = 'DCSaveSubCategory'
GO

insert into GXDBVersions values(2, 'DCSaveSubCategory',  '00010002008800060000', 'DCSaveSubCategory', '00010002008800060000')
GO

