

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DCSavePackagesChecksum.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  DCSavePackagesChecksum()
--  | Description:  Save (insert or update) package md5 checksum information
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DCSavePackagesChecksum.sp,v $ $Id: DCSavePackagesChecksum.sp,v 1.1.2.1 2020/06/25 03:53:41 sgolla Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='DCSavePackagesChecksum')
BEGIN
	print '>>> Drop Stored Procedure: DCSavePackagesChecksum <<<'
	drop procedure DCSavePackagesChecksum
END
IF EXISTS (select * from GxQscripts where name='DCSavePackagesChecksum')
	delete from GxQscripts where name = 'DCSavePackagesChecksum'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DCSavePackagesChecksum')
	delete from GXDBVersions where aliasname = 'DCSavePackagesChecksum'
GO
print '... Creating Procedure: DCSavePackagesChecksum'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DCSavePackagesChecksum
  @checkSumData IdNameList READONLY
AS
BEGIN
UPDATE PP
SET PackageChecksum = CASE WHEN ISNULL(I.Name, '') = '' THEN NULL ELSE I.NAME END,
PP.Attribute = PP.Attribute | 1 /* mark it with so we don't process same record again during upgrade (DCPlatformAttribute.Upgraded) */
FROM DCPackagePlatform PP
JOIN @checkSumData I ON PP.PackagePlatformMappingId = I.id
SELECT @@ROWCOUNT as RowsUpdated
END
GO

IF EXISTS (select * from GxQscripts where name = 'DCSavePackagesChecksum')
	delete from GxQscripts where name = 'DCSavePackagesChecksum'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DCSavePackagesChecksum')
	delete from GXDBVersions where aliasname = 'DCSavePackagesChecksum'
GO

insert into GXDBVersions values(2, 'DCSavePackagesChecksum',  '00010001000200010000', 'DCSavePackagesChecksum', '00010001000200010000')
GO

