

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DCSavePackage.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  DCSavePackage()
--  | Description:  Save (insert or update) package information
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DCSavePackage.sp,v $ $Id: DCSavePackage.sp,v 1.11.2.9 2020/06/25 03:54:08 sgolla Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='DCSavePackage')
BEGIN
	print '>>> Drop Stored Procedure: DCSavePackage <<<'
	drop procedure DCSavePackage
END
IF EXISTS (select * from GxQscripts where name='DCSavePackage')
	delete from GxQscripts where name = 'DCSavePackage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DCSavePackage')
	delete from GXDBVersions where aliasname = 'DCSavePackage'
GO
print '... Creating Procedure: DCSavePackage'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DCSavePackage
  @PackageXML XML, 
  @CurrentWebServerUTC DateTime,
  @debug BIT = 0
AS
BEGIN
	SET QUOTED_IDENTIFIER ON
	SET NOCOUNT ON
	DECLARE @errCode INT = 0
	DECLARE @retMsg varchar(max) = ''
	DECLARE @isInsert BIT = 0
DECLARE @PackageId			INT,
	@Name					nvarchar(255),
	@Description			nvarchar(max),
	@Size					BIGINT,
	@CategoryId				INT,
	@SubCategoryId			INT,
	@PlatformId				INT,
	@ProductVersionId		INT,
	@RecutNumberId			INT,
	@Notification			nvarchar(max),
	@RemoteSecureAccessLink	nvarchar(max),
	@BOLLink				nvarchar(max),
	@StartDate				datetime,
	@EndDate				datetime,
	@Image					nvarchar(max),
	@DownloadAction			INT,					--We can get corresponding name for this from DCReference where TypeName is DownloadAction
	@PackageStatus			INT,					--We can get corresponding name for this from DCReference where TypeName is PackageStatus
	@CreateTime				datetime,
	@ModifiedTime			datetime,
	@Attribute				INT,
	@i_Found				BIT,
	@savedBy				INT,
	@serverId				INT,
	@vendorId				INT,
	@maxLen					INT = 0,
	@createtimedb			int,
	@modifiedtimedb			int,
	@rowCount				int,
	@DeletedPkgPlatformMappingIds	varchar(max),
	@rank					int,
	@priceWeightage			int,
	@packageIconFileName	varchar(1024)
DECLARE @PackageVisibility TABLE (
	SecuredEntityGuid		varchar(128),
	VisibilityFlags			int,
	SecuredEntityType		int,
	SecuredEntityName		nvarchar(255)
	)
CREATE TABLE #PackagePlatformTable (
	PlatformId			INT,
	serverId			INT,
	DownloadTypeId		INT,
	DownloadAction		INT,
	Size				BIGINT,
	Location			NVARCHAR(MAX),
	ReadmeLocation		NVARCHAR(MAX),
	ReadmeRepositoryId 	INT,
	PackageCheckSum		varchar(36)
	)
-- call validate procedure
EXEC DCPackageValidation @dcPackageXML = @PackageXML, @errorCode = @errCode OUTPUT, @errorMessage = @retMsg OUTPUT, @categoryID = @CategoryId OUTPUT, @subCategoryID = @SubCategoryId OUTPUT, @versionID = @ProductVersionId OUTPUT, @recutNumberID = @RecutNumberId OUTPUT, @vendorID = @vendorId OUTPUT, @packageID = @PackageId OUTPUT, @packageName = @Name OUTPUT, @validFrom = @StartDate OUTPUT, @validTo = @EndDate OUTPUT
IF @errCode > 0
BEGIN
	goto ErrorLine
END
SELECT @savedBy = ISNULL(ref.value('@savedBy', 'int'), 1) FROM @PackageXML.nodes('/App_DCPackage') T(ref)
SELECT @errCode = @@ERROR
IF @errCode > 0
BEGIN
	SELECT @retMsg = 'Error reading id of user attempting to save package'
goto ErrorLine
END
SET @i_Found = @PackageXML.exist('/App_DCPackage/visibility')
IF @i_Found >= 1
BEGIN
	INSERT INTO @PackageVisibility
	SELECT ref.value('@guid','VARCHAR(128)') AS SecuredEntityGuid,
			ref.value('@visibilityFlags', 'int') AS VisibilityFlags,
			ref.value('@securedEntityType', 'int') AS SecuredEntityType,
			ref.value('@name', 'NVARCHAR(255)') as SecuredEntityName
	FROM @PackageXML.nodes('/App_DCPackage/visibility') T(ref)
	SELECT @errCode = @@ERROR
	IF @errCode > 0
	BEGIN
		SELECT @retMsg = 'Error reading package visibility'
	goto ErrorLine
	END
	/*INSERT INTO @DCReference(EntryName, DisplayName)
	SELECT SecuredEntityGuid, SecuredEntityName
	FROM @PackageVisibility V
	WHERE V.SecuredEntityType = 2 AND ISNULL(V.SecuredEntityName, '') <> '' AND ISNULL(SecuredEntityGuid, '') <> ''
	SELECT @errCode = @@ERROR
	IF @errCode > 0
	BEGIN
		SELECT @retMsg = 'Error processing package visibility'
	goto ErrorLine
	END*/
END
--if at-least one visibleTo is not added, then add / update user who is saving the package in visibleTo list..
IF NOT EXISTS (SELECT * FROM @PackageVisibility V WHERE V.VisibilityFlags & 1 = 1)
BEGIN
	DECLARE @savedByUserGuid varchar(128)
	DECLARE @typeOfSavingUser int
	SELECT @savedByUserGuid = U.userGuid, @typeOfSavingUser = (CASE WHEN U.umDSproviderId = 0 THEN 3 ELSE 4 END) FROM UMUsers U WHERE U.id = @savedBy and enabled = 1
	IF EXISTS (SELECT * FROM @PackageVisibility V WHERE V.SecuredEntityGuid=@savedByUserGuid)
	BEGIN
		UPDATE T
		SET T.VisibilityFlags = T.VisibilityFlags | 1
		FROM @PackageVisibility T
		WHERE T.SecuredEntityGuid = @savedByUserGuid
	END
	ELSE
	BEGIN
		INSERT INTO @PackageVisibility
	SELECT @savedByUserGuid, 1, @typeOfSavingUser, (select login from UMUsers where userGuid = @savedByUserGuid and enabled = 1)
	END
END
SELECT @Name = isNull(ref.value('@name', 'nvarchar(255)'), '') FROM @PackageXML.nodes('/App_DCPackage') T(ref)
SELECT @errCode = @@ERROR
IF @errCode > 0
BEGIN
	SELECT @retMsg = 'Error reading name'
	goto ErrorLine
END
SELECT @Description = isNull(ref.value('@description', 'nvarchar(max)'), '') FROM @PackageXML.nodes('/App_DCPackage') T(ref)
SELECT @errCode = @@ERROR
IF @errCode > 0
BEGIN
	SELECT @retMsg = 'Error reading description'
	goto ErrorLine
END
SELECT @Notification = isNull(ref.value('@notification', 'nvarchar(max)'), '') FROM @PackageXML.nodes('/App_DCPackage') T(ref)
SELECT @errCode = @@ERROR
IF @errCode > 0
BEGIN
	SELECT @retMsg = 'Error reading notification'
	goto ErrorLine
END
SELECT @RemoteSecureAccessLink = isNull(ref.value('@remoteSecureAccessLink', 'nvarchar(max)'), '') FROM @PackageXML.nodes('/App_DCPackage') T(ref)
SELECT @errCode = @@ERROR
IF @errCode > 0
BEGIN
	SELECT @retMsg = 'Error reading remoteSecureAccessLink'
	goto ErrorLine
END
SELECT @BOLLink = isNull(ref.value('@bolLink', 'nvarchar(max)'), '') FROM @PackageXML.nodes('/App_DCPackage') T(ref)
SELECT @errCode = @@ERROR
IF @errCode > 0
BEGIN
	SELECT @retMsg = 'Error reading bolLink'
	goto ErrorLine
END
SELECT @Image = isNull(ref.value('@packageIcon', 'nvarchar(max)'), '') FROM @PackageXML.nodes('/App_DCPackage') T(ref)
SELECT @errCode = @@ERROR
IF @errCode > 0
BEGIN
	SELECT @retMsg = 'Error reading packageIcon'
	goto ErrorLine
END
SELECT @PackageStatus = isNull(ref.value('@status', 'int'), 0) FROM @PackageXML.nodes('/App_DCPackage') T(ref)
SELECT @errCode = @@ERROR
IF @errCode > 0
BEGIN
	SELECT @retMsg = 'Error reading status'
	goto ErrorLine
END
SELECT @Attribute = isNull(ref.value('@attribute', 'int'), 0) FROM @PackageXML.nodes('/App_DCPackage') T(ref)
SELECT @errCode = @@ERROR
IF @errCode > 0
BEGIN
	SELECT @retMsg = 'Error reading attribute'
	goto ErrorLine
END
SELECT @rank = isNull(ref.value('@rank', 'int'), 0) FROM @PackageXML.nodes('/App_DCPackage') T(ref)
SELECT @errCode = @@ERROR
IF @errCode > 0
BEGIN
	SELECT @retMsg = 'Error reading rank'
	goto ErrorLine
END
SELECT @priceWeightage = isNull(ref.value('@priceWeightage', 'int'), 0) FROM @PackageXML.nodes('/App_DCPackage') T(ref)
SELECT @errCode = @@ERROR
IF @errCode > 0
BEGIN
	SELECT @retMsg = 'Error reading priceWeightage'
	goto ErrorLine
END
SELECT @packageIconFileName = isNull(ref.value('@packageIconFileName', 'varchar(1024)'), 0) FROM @PackageXML.nodes('/App_DCPackage') T(ref)
SELECT @errCode = @@ERROR
IF @errCode > 0
BEGIN
	SELECT @retMsg = 'Error reading packageIconFileName'
	goto ErrorLine
END
IF @errCode = 0
BEGIN
	DECLARE @ExtraPackageProps XML
	SELECT @ExtraPackageProps = @PackageXML.query('/App_DCPackage/extraPropContainer')
	IF @RecutNumberId <= 0
		SET @RecutNumberId = NULL
	IF @vendorId <= 0
		SET @vendorId = NULL
	BEGIN TRANSACTION
	IF isNull(@PackageId, 0) = 0
	BEGIN
		INSERT INTO DCPackage (
			PackageName,Description,CategoryId,SubCategoryId,ProductVersionId,
			RecutNumberId,Notification,
			RemoteSecureAccessLink,BOLLink,StartDate,EndDate,
			IconImage,PackageStatus,PackageXML,CreateTime,ModifiedTime,
			Attribute,CreatedBy,ModifiedBy,VendorID, PackageRank, PriceWeightage, PackageIconFileName
			)
		SELECT @Name AS PackageName, @Description AS Description, @CategoryId AS CategoryId, @SubCategoryId AS SubCategoryId, @ProductVersionId AS ProductVersionId,
			@RecutNumberId, @Notification, @RemoteSecureAccessLink AS RemoteSecureAccessLink, @BOLLink AS BOLLink, @StartDate AS StartDate, @EndDate AS EndDate,
			@Image AS IconImage, @PackageStatus AS PackageStatus, @ExtraPackageProps AS PackageXML, GETUTCDATE() AS CreateTime, null AS ModifiedTime,
			@Attribute AS Attribute, @savedBy AS CreatedBy, null AS ModifiedBy, (CASE WHEN @vendorId <= 0 THEN NULL ELSE @vendorId END) AS VendorID, @rank, @priceWeightage, @packageIconFileName
		SELECT @errCode = @@ERROR, @PackageId = @@IDENTITY
	END
	ELSE
	BEGIN
		UPDATE DCPackage
		SET PackageName = @Name, Description = @Description,
			CategoryId = @CategoryId, SubCategoryId = @SubCategoryId,
			ProductVersionId = @ProductVersionId,
			RecutNumberId = @RecutNumberId, Notification = @Notification, RemoteSecureAccessLink = @RemoteSecureAccessLink,
			BOLLink = @BOLLink, StartDate = @StartDate, EndDate = @EndDate,
			IconImage = @Image, PackageStatus = @PackageStatus,
			PackageXML = @ExtraPackageProps, ModifiedTime = GETUTCDATE(), ModifiedBy = @savedBy, VendorID = (CASE WHEN @vendorId <= 0 THEN NULL ELSE @vendorId END),
			PackageRank = @rank,
			PriceWeightage = @priceWeightage,
			PackageIconFileName = @packageIconFileName
		WHERE PackageId = @PackageId
		SET @errCode = @@ERROR
	END
	IF @errCode = 0
	BEGIN
		--debug info
		if @debug = 1
		BEGIN
			SELECT *, 'PackagePlatformToDelete' FROM DCPackagePlatform PL
			WHERE PL.PackageId = @PackageId AND
			NOT EXISTS (SELECT PlatformId FROM #PackagePlatformTable T WHERE PL.PackageId = @PackageId AND PL.PlatformId = T.PlatformId AND PL.DownloadTypeId = T.DownloadTypeId)
		END
		IF @errCode = 0
		begin
			--Also delete rows that do not exist in input, but exist in DB
			DECLARE @DCPackagePlatformDelete TABLE (PackagePlatformMappingId INT)
			INSERT INTO @DCPackagePlatformDelete
			SELECT PL.PackagePlatformMappingId FROM DCPackagePlatform PL
			WHERE PL.PackageId = @PackageId AND
			NOT EXISTS (SELECT PlatformId FROM #PackagePlatformTable T WHERE PL.PackageId = @PackageId AND PL.PlatformId = T.PlatformId AND PL.DownloadTypeId = T.DownloadTypeId)
			DELETE FROM DCPackagePlatform
			WHERE PackagePlatformMappingId IN (SELECT PackagePlatformMappingId FROM @DCPackagePlatformDelete)
			--
			SELECT @rowCount = @@ROWCOUNT, @errCode = @@ERROR
			if @debug = 1
				PRINT 'Deleted #' + CONVERT(VARCHAR, @rowCount) + ' number of package platform rows'
			SET @DeletedPkgPlatformMappingIds = ''
			SELECT @DeletedPkgPlatformMappingIds = @DeletedPkgPlatformMappingIds + CONVERT(VARCHAR, PackagePlatformMappingId) + ',' FROM @DCPackagePlatformDelete
			IF LEN(@DeletedPkgPlatformMappingIds) > 1
				SELECT @DeletedPkgPlatformMappingIds = LEFT(@DeletedPkgPlatformMappingIds, LEN(@DeletedPkgPlatformMappingIds) - 1)
		end
		IF @debug = 1
		BEGIN
			SELECT *, 'PackagePlatformToInsert' FROM #PackagePlatformTable S
			WHERE NOT EXISTS (SELECT PackagePlatformMappingId FROM DCPackagePlatform PL WHERE PL.PackageId = @PackageId AND PL.PlatformId = S.PlatformId AND PL.DownloadTypeId = S.DownloadTypeId)
		END
		--Add new entries to db
		IF @errCode = 0
		BEGIN
			INSERT INTO DCPackagePlatform (PlatformId, PackageId, CreateTime, Attribute, Location,
			PackageRepositoryId, PackageSize, DownloadTypeId, DownloadAction, ReadMeLocation, ReadMeRepositoryId, ReadMeUpdatedTime, PackageCheckSum)
			SELECT PlatformId, @PackageId, GETUTCDATE(), @Attribute, Location,
			serverId, Size, DownloadTypeId, DownloadAction, ReadmeLocation, ReadMeRepositoryId,
			(CASE WHEN ISNULL(S.ReadMeLocation, '') <> '' THEN @CurrentWebServerUTC ELSE null END) ReadMeUpdatedTime, PackageCheckSum
		FROM #PackagePlatformTable S
		WHERE NOT EXISTS (SELECT PackagePlatformMappingId FROM DCPackagePlatform PL WHERE PL.PackageId = @PackageId AND PL.PlatformId = S.PlatformId AND PL.DownloadTypeId = S.DownloadTypeId)
			SELECT @rowCount = @@ROWCOUNT, @errCode = @@ERROR
			if @debug = 1
				PRINT 'Inserted #' + CONVERT(VARCHAR, @rowCount) + ' number of package platform rows with attribute ' + convert(varchar, @Attribute)
			IF @errCode = 0
			BEGIN
				UPDATE DCPackagePlatform
				SET PackageRepositoryId = serverId,
					PackageSize = Size,
					Location = S.Location,
					DownloadTypeId = S.DownloadTypeId,
					ReadMeLocation = S.ReadMeLocation,
					ModifiedTime = GETUTCDATE(),
					PlatformId = S.PlatformId,
					ReadMeRepositoryId = CASE WHEN ISNULL(S.ReadMeRepositoryId, 0) = 0 THEN NULL ELSE S.ReadmeRepositoryId END,
					ReadMeUpdatedTime = (CASE
						WHEN ISNULL(S.ReadmeLocation, '') <> '' AND (ISNULL(S.ReadmeLocation, '') <> ISNULL(PP.ReadMeLocation, '') OR ISNULL(PP.ReadMeRepositoryId, 0) <> ISNULL(S.ReadMeRepositoryId, 0))
						THEN @CurrentWebServerUTC
						WHEN ISNULL(S.ReadmeLocation, '') = '' AND ISNULL(PP.ReadMeLocation, '') <> ''
						THEN NULL
						ELSE PP.ReadMeUpdatedTime END),
					PackageCheckSum = S.PackageCheckSum
				FROM #PackagePlatformTable S
				inner join DCPackagePlatform PP ON PP.PackageId = @PackageId AND PP.PlatformId = S.PlatformId AND PP.DownloadTypeId = S.DownloadTypeId
			END -- end if no error insert into dcpackageplatform table for new rows in input w.r.t DB (@PackagePlatform table)
		END -- end if no error in deleting soft delete and non existent input rows w.r.t to main (dcpackageplatform) table
	END --end if no error in main (dcpackage) table insert/update
	IF @errCode = 0
	BEGIN
		SET NOCOUNT OFF
		DECLARE @PackageVisibilityMergeAction TABLE (
			MergeAction				varchar(100),
			DelSecuredEntityGuid	varchar(128),
			DelVisibilityFlags		integer,
			InsSecuredEntityGuid	varchar(128),
			InsVisibilityFlags		integer
		)
		MERGE DCPackageVisibility AS A
		USING (SELECT * FROM @PackageVisibility) AS T
		ON A.SecuredEntityGuid = T.SecuredEntityGuid AND A.PackageId = @PackageId
		WHEN NOT MATCHED BY TARGET THEN
				INSERT (SecuredEntityGuid,SecuredEntityType,PackageId,VisbilityFlags,CreateTime, SecuredEntityLoginName)
				VALUES (T.SecuredEntityGuid,T.SecuredEntityType,@PackageId,T.VisibilityFlags,GetUtcDate(), T.SecuredEntityName)
		WHEN MATCHED THEN
			UPDATE SET ModifiedTime = getutcdate(), VisbilityFlags = T.VisibilityFlags, SecuredEntityLoginName = T.SecuredEntityName
		WHEN NOT MATCHED BY SOURCE AND PackageId = @PackageId THEN
			DELETE
		OUTPUT $action as MergeAction, deleted.SecuredEntityGuid, deleted.VisbilityFlags, inserted.SecuredEntityGuid, inserted.VisbilityFlags into @PackageVisibilityMergeAction;
		SELECT @errCode = @@ERROR
		IF @debug = 1
		BEGIN
			SELECT 'MergeAction' as MergeActionEntry, * from @PackageVisibilityMergeAction
		END
		IF @errCode > 0
		BEGIN
			SELECT @retMsg = 'Error inserting or updating package visibility'
			goto TxError
		END
	END -- end if no error till DCPackagePlatform table updation
TxError:
	IF @errCode = 0
	BEGIN
		COMMIT TRANSACTION
	END
	ELSE
	BEGIN
		SET @PackageId = 0
		ROLLBACK TRANSACTION
	END
END
--We jump here directly if we have not started transaction, and failed during validation itself.
ErrorLine:
	IF @errCode > 0 AND ISNULL(@retMsg, '') = ''
		SELECT @retMsg = @retMsg + ISNULL(Text, 'Unexpected error occurred') FROM SYS.messages where message_id = @errCode
SELECT @createtimedb = dbo.GetUnixTime(CreateTime), @modifiedtimedb = dbo.GetUnixTime(ModifiedTime) FROM DCPackage
WHERE PackageId = @PackageId
SELECT @errCode AS ReturnCode, @retMsg as ReturnMessage, @PackageId as ReturnId, @createtimedb as CreateTime, @modifiedtimedb as ModifiedTime, @DeletedPkgPlatformMappingIds as deletedPPMIDs
END
GO

IF EXISTS (select * from GxQscripts where name = 'DCSavePackage')
	delete from GxQscripts where name = 'DCSavePackage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DCSavePackage')
	delete from GXDBVersions where aliasname = 'DCSavePackage'
GO

insert into GXDBVersions values(2, 'DCSavePackage',  '00010011000200090000', 'DCSavePackage', '00010011000200090000')
GO

