

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DCSaveEntityProperty.sp] ---------- 

--  +=====================================================================================+
--  |		 		 Name:  DCSaveEntityProperty
--  | Description:  Saves the property and its value in DCEntityProperty table
--  +=====================================================================================+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DCSaveEntityProperty <<<'

IF EXISTS (select * from sysobjects where name='DCSaveEntityProperty')
	drop procedure DCSaveEntityProperty
IF EXISTS (select * from GxQscripts where name='DCSaveEntityProperty')
	delete from GxQscripts where name = 'DCSaveEntityProperty'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DCSaveEntityProperty')
	delete from GXDBVersions where aliasname = 'DCSaveEntityProperty'
GO
print '... Creating Procedure: DCSaveEntityProperty'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DCSaveEntityProperty
  @i_xmlText XML
AS
BEGIN
	DECLARE @ReturnCode INT
	DECLARE @TempTable TABLE (
	EntityType INT,
	EntityId INT,
	PropName VARCHAR(256),
	PropVal VARCHAR(max)
	)
	INSERT INTO @TempTable (EntityType, EntityId, PropName, PropVal)
	SELECT	T.ref.value('@entityType', 'int'),
			T.ref.value('@id', 'int'),
			T.ref.value('@name', 'varchar(256)'),
			T.ref.value('@description', 'nvarchar(max)')
	FROM @i_xmlText.nodes('/App_DCSaveLookupEntityReq/entitiesToSave') T(ref)
	BEGIN TRAN
		DELETE T
		FROM DCEntityProperty T
		JOIN @TempTable TT ON T.EntityId = TT.EntityId AND T.EntityType = TT.EntityType AND T.PropertyName = TT.PropName
		SET @ReturnCode = @@ERROR
		IF @ReturnCode = 0
		BEGIN
			INSERT INTO DCEntityProperty (EntityType, EntityId, PropertyName, PropertyValue)
			SELECT EntityType, EntityId, PropName, PropVal
			FROM @TempTable
			SET @ReturnCode = @@ERROR
		END
	SELECT @ReturnCode AS ReturnCode
	if @ReturnCode = 0
		COMMIT TRAN
	ELSE
		ROLLBACK TRAN
	END
GO

IF EXISTS (select * from GxQscripts where name = 'DCSaveEntityProperty')
	delete from GxQscripts where name = 'DCSaveEntityProperty'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DCSaveEntityProperty')
	delete from GXDBVersions where aliasname = 'DCSaveEntityProperty'
GO

insert into GXDBVersions values(2, 'DCSaveEntityProperty',  '00000000000000000000', 'DCSaveEntityProperty', '00000000000000000000')
GO

