

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DCSaveCategory.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  DCSaveCategory()
--  | Description:  Save (insert or update) category information
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DCSaveCategory.sp,v $ $Id: DCSaveCategory.sp,v 1.2.88.5 2019/03/25 21:05:21 hravula Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='DCSaveCategory')
BEGIN
	print '>>> Drop Stored Procedure: DCSaveCategory <<<'
	drop procedure DCSaveCategory
END
IF EXISTS (select * from GxQscripts where name='DCSaveCategory')
	delete from GxQscripts where name = 'DCSaveCategory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DCSaveCategory')
	delete from GXDBVersions where aliasname = 'DCSaveCategory'
GO
print '... Creating Procedure: DCSaveCategory'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DCSaveCategory
  @i_CategoryId INT, 
  @i_Name NVARCHAR(100), 
  @i_Description NVARCHAR(MAX), 
  @i_Attribute INT
AS
BEGIN
	SET NOCOUNT ON
	DECLARE @attributeValue INT
	DECLARE @errCode INT = 0
	DECLARE @retMsg varchar(max) = 'Record saved successfully'
	DECLARE @maxLen INT = 0
	DECLARE @cnt INT = 0
	DECLARE @ErrorMessage NVARCHAR(4000);
	DECLARE @ErrorSeverity INT;
	DECLARE @ErrorState INT;
	SELECT @maxLen = CHARACTER_MAXIMUM_LENGTH FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'DCCategory' AND COLUMN_NAME = 'CategoryName'
	IF ISNULL(@i_Attribute, 0) = 0
		SELECT @attributeValue = EntryValue FROM DCReference WHERE TypeName = 'Attribute' AND EntryName = 'AdminSaved'
	ELSE
	BEGIN
		SELECT @attributeValue = EntryValue FROM DCReference WHERE TypeName = 'Attribute' AND EntryValue = @i_Attribute
		IF ISNULL(@attributeValue, 0) = 0
			SELECT @attributeValue = SUM(EntryValue) FROM
			(
				SELECT DISTINCT EntryValue FROM DCReference WHERE TypeName = 'Attribute'  AND (EntryValue & @i_Attribute) > 0
			) T
	END
	IF @attributeValue IS NULL
		SELECT @errCode = 10002, @retMsg = 'Specified attribute ' + CONVERT(VARCHAR(10), @i_Attribute) + ' not found for saving category'
	ELSE IF @attributeValue = 8
	BEGIN
		IF @i_CategoryId = 0 or @i_CategoryId = NULL
			SELECT @errCode = 10005, @retMsg = 'Category name not provided'
		ELSE
		BEGIN
		BEGIN TRY
			BEGIN TRAN
			DELETE DP FROM DCPackagePlatform DP JOIN DCPackage P ON P.PackageId = DP.PackageId
			WHERE P.CategoryId = @i_CategoryId
			DELETE FROM DCPackage where CategoryId = @i_CategoryId
			DELETE FROM DCSubCategory where CategoryId = @i_CategoryId
			DELETE FROM DCEntityProperty where EntityId = @i_CategoryId AND EntityType = 0
			DELETE FROM DCCategory where CategoryId = @i_CategoryId
			SELECT @cnt = @@ROWCOUNT
			IF @cnt = 0
			SELECT @errCode = 10006, @retMsg = 'No rows deleted. Category specified is invalid.'
			COMMIT TRAN
		END TRY
		BEGIN CATCH
		ROLLBACK TRAN
		SELECT @ErrorMessage = ERROR_MESSAGE(),@ErrorSeverity = ERROR_SEVERITY(),@ErrorState = ERROR_STATE();
		RAISERROR (@ErrorMessage,@ErrorSeverity,@ErrorState);
		END CATCH
		END
	END
	ELSE IF @i_Name = '' or @i_Name = NULL
		SELECT @errCode = 10005, @retMsg = 'Category name not provided'
	ELSE IF LEN(@i_Name) > @maxLen
		SELECT @errCode = 10003, @retMsg = 'Category name has more than ' + CONVERT(VARCHAR(10), @maxLen) + ' characters'
	ELSE IF ISNULL(@i_CategoryId, 0) > 0 AND EXISTS(SELECT 1 FROM DCCategory WHERE CategoryName = @i_Name AND CategoryId <> @i_CategoryId AND EXISTS (SELECT 1 FROM DCCategory WHERE CategoryId = @i_CategoryId AND CategoryName <> @i_Name))
	    SELECT @errCode = 10001, @retMsg = 'Category name already exists'
	ELSE IF ISNULL(@i_CategoryId, 0) = 0
	BEGIN
		IF EXISTS (SELECT * FROM DCCategory WHERE CategoryName = @i_Name)
		BEGIN
			SELECT @errCode = 10001, @retMsg = 'Category name already exists'
		END
		ELSE
		BEGIN
		BEGIN TRY
			BEGIN TRAN
				INSERT INTO DCCategory (CategoryName, Description, Attribute, CreateTime)
				SELECT @i_Name, @i_Description, @attributeValue, GETUTCDATE()
				SELECT @i_CategoryId = @@IDENTITY
				COMMIT TRAN
		END TRY
		BEGIN CATCH
		ROLLBACK TRAN
		SELECT @ErrorMessage = ERROR_MESSAGE(),@ErrorSeverity = ERROR_SEVERITY(),@ErrorState = ERROR_STATE();
		RAISERROR (@ErrorMessage,@ErrorSeverity,@ErrorState);
		END CATCH
		END
	END
	ELSE
	BEGIN
		BEGIN TRY
			BEGIN TRAN
			UPDATE DCCategory
			SET CategoryName = @i_Name, Description = @i_Description, Attribute = @attributeValue, ModifiedTime = GETUTCDATE()
			WHERE CategoryId = @i_CategoryId
			SELECT @cnt = @@ROWCOUNT
			IF @cnt = 0
			SELECT @errCode = 10006, @retMsg = 'No rows updated. Category specified is invalid.'
			COMMIT TRAN
		END TRY
		BEGIN CATCH
		ROLLBACK TRAN
		SELECT @ErrorMessage = ERROR_MESSAGE(),@ErrorSeverity = ERROR_SEVERITY(),@ErrorState = ERROR_STATE();
		RAISERROR (@ErrorMessage,@ErrorSeverity,@ErrorState);
		END CATCH
	END
	IF @errCode > 0 AND ISNULL(@retMsg, '') = ''
		SELECT @retMsg = ISNULL(Text, 'Unexpected error occurred') FROM SYS.messages where message_id = @errCode
	SELECT @errCode AS ReturnCode, @retMsg AS ReturnMessage, @i_CategoryId AS ReturnId
END
GO

IF EXISTS (select * from GxQscripts where name = 'DCSaveCategory')
	delete from GxQscripts where name = 'DCSaveCategory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DCSaveCategory')
	delete from GXDBVersions where aliasname = 'DCSaveCategory'
GO

insert into GXDBVersions values(2, 'DCSaveCategory',  '00010002008800050000', 'DCSaveCategory', '00010002008800050000')
GO

