

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DCRepositoryConfiguration.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DCRepositoryConfiguration.sp,v $ $Id: DCRepositoryConfiguration.sp,v 1.7.2.5 2018/03/27 08:47:10 jiechen Exp $";
--  +========================================================================+
--  | Stored Proc:  DCRepositoryConfiguration()
--  |
--  | Description: Download center repository configuartion
--  +========================================================================+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DCRepositoryConfiguration <<<'

IF EXISTS (select * from sysobjects where name='DCRepositoryConfiguration')
	drop procedure DCRepositoryConfiguration
IF EXISTS (select * from GxQscripts where name='DCRepositoryConfiguration')
	delete from GxQscripts where name = 'DCRepositoryConfiguration'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DCRepositoryConfiguration')
	delete from GXDBVersions where aliasname = 'DCRepositoryConfiguration'
GO
print '... Creating Procedure: DCRepositoryConfiguration'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DCRepositoryConfiguration
  @i_xmlText XML
AS
  DECLARE @o_errorCode integer = 0
  DECLARE @o_errorString varchar(255) =''
BEGIN TRY
BEGIN TRAN
--fields
  DECLARE @repositoryId int
  DECLARE @serverType int
  DECLARE @clientId int
  DECLARE @networkPath nvarchar(max)
  DECLARE @domainAndUserName nvarchar(255)
  DECLARE @encodedPassword NVARCHAR(255)
  DECLARE @repositoryName NVARCHAR(255)
  DECLARE @createdBy INT
  DECLARE @attribute INT
  DECLARE @createTime INT
  DECLARE @modifiedTime INT
  DECLARE @virtualPath NVARCHAR(MAX)
  DECLARE @extraProperties XML
  --server type
  DECLARE @DC_SERVER_TYPE_NONE INT=0
  DECLARE @DC_SERVER_TYPE_WEBSERVER INT=1
  DECLARE @DC_SERVER_TYPE_AKAMAI INT=2
  DECLARE @DC_SERVER_TYPE_NETWORK INT=3
  DECLARE @DC_SERVER_TYPE_OBJECTSTORE INT=4
  -- attribute
  DECLARE @DC_ATTRIBUTE_NONE INT=0
  DECLARE @DC_ATTRIBUTE_SYSTEM_SAVED INT=1
  DECLARE @DC_ATTRIBUTE_ADMIN_SAVED INT=2
  DECLARE @DC_ATTRIBUTE_SOFT_DELETED INT=4
  --error code
  DECLARE @DC_ERR_SEARCH_SERVER_NOT_FOUND_FOR_CLIENT  INT=10401
  DECLARE @DC_ERR_SEARCH_SERVER_NOT_REACHABLE		  INT=10402
  DECLARE @DC_ERR_UNABLE_TO_FETCH_REPOSITORY_COUNT	  INT=10403
  DECLARE @DC_ERR_UNABLE_TO_FETCH_PACKAGE_COUNT		  INT=10404
  DECLARE @DC_ERR_UNABLE_TO_FETCH_DOWNLOADCENTER_CONFIG_STATUS_FOR_CLIENT   INT=10405
  DECLARE @DC_ERR_UNABLE_TO_SAVE_REPOSITORY			  INT=10406
  DECLARE @DC_ERR_UNABLE_TO_SAVE_ANALYTICS_ENGINE_INFO  INT=10407
  DECLARE @DC_ERR_UNBALE_TO_START_ANALYTICS_SERVICE   INT=10408
  DECLARE @DC_ERR_UNBALE_TO_STOP_ANALYTICS_SERVICE    INT=10409
  DECLARE @DC_ERR_UNABLE_TO_CREATE_INDEX_DIRECTORY	  INT=10410
  DECLARE @DC_ERR_INVALID_OPERATION_TYPE			  INT=10411
  DECLARE @DC_ERR_INVALID_CLIENT_ID					  INT=10412
  DECLARE @DC_ERR_INVALID_REPOSITORY_ID				  INT=10413
  DECLARE @DC_ERR_INVALID_ATTRIBUTE					  INT=10414
  DECLARE @DC_ERR_UNABLE_TO_IMPORT_PACKAGES			  INT=10415
  DECLARE @DC_ERR_UNABLE_TO_FETCH_CLIENT_ID			  INT=10416
  DECLARE @DC_ERR_CLOUD_ALREADY_EXISTS_FOR_CLIENT	  INT=10417
  DECLARE @DC_ERR_REPOSITORY_ALREADY_EXISTS			  INT=10418
  DECLARE @DC_ERR_INVALID_EMPTY_REPOSITORY_NAME		  INT=10419
  DECLARE @DC_ERR_INVALID_REPOSITORY_TYPE			  INT=10420
  DECLARE @DC_ERR_EMPTY_CREATOR_OR_MODIFIER_USER	  INT=10421
  DECLARE @DC_ERR_EMPTY_NWK_REPOSITORY_PATH			  INT=10422
  DECLARE @DC_ERR_EMPTY_NWK_REPOSITORY_USER_CRED	  INT=10423
  --values
  SELECT @repositoryId = ISNULL(ref.value ('@repositoryId', 'INT'),0),
	@serverType = ISNULL(ref.value ('@serverType', 'INT'), @DC_SERVER_TYPE_NONE),
	@clientId = ref.value ('@clientId', 'INT'),
	@networkPath = ISNULL( ref.value ('@networkPath', 'NVARCHAR(MAX)'),''),
	@domainAndUserName = ref.value ('@domainAndUserName', 'NVARCHAR(255)'),
	@encodedPassword = ref.value ('@encodedPassword', 'NVARCHAR(255)'),
	@repositoryName = ISNULL(ref.value ('@respositoryName', 'NVARCHAR(255)'),''),
	@createdBy = ISNULL(ref.value ('@createdBy', 'INT'), 0),
	@attribute = ISNULL(ref.value ('@attribute', 'INT'), 0),
	@createTime = ISNULL(ref.value ('@createTime', 'INT'), DATEDIFF(s, '1970-01-01 00:00:00', GETUTCDATE())),
	@modifiedTime = ISNULL(ref.value ('@modifiedTime', 'INT'), DATEDIFF(s, '1970-01-01 00:00:00', GETUTCDATE())),
	@virtualPath = ref.value ('@virtualPath', 'NVARCHAR(MAX)'),
	@extraProperties = R.ref.query('properties')
	FROM @i_xmlText.nodes('App_DCPackageRepository') R ( ref )
	--validation check
	IF @attribute NOT IN (@DC_ATTRIBUTE_ADMIN_SAVED, @DC_ATTRIBUTE_SOFT_DELETED)
	BEGIN
		SET @o_errorCode = @DC_ERR_INVALID_ATTRIBUTE
		SET @o_errorString = 'Invalid attribute ['+  CAST (@attribute AS VARCHAR(50))  +']'
		GOTO PROC_EXIT
	END
	--Edit: ModifiedTime, DomainUserName, Password, CreatedBy, RepositoryName, NetworkPath
	IF @attribute <> @DC_ATTRIBUTE_SOFT_DELETED
	BEGIN
		IF @serverType NOT IN (@DC_SERVER_TYPE_WEBSERVER, @DC_SERVER_TYPE_NETWORK ,@DC_SERVER_TYPE_OBJECTSTORE)
		BEGIN
			SET @o_errorCode = @DC_ERR_INVALID_REPOSITORY_TYPE
			SET @o_errorString = 'Invalid repository type ['+ CAST (@serverType AS VARCHAR(50)) + ']'
			GOTO PROC_EXIT
		END
		IF @repositoryName = ''
		BEGIN
			SET @o_errorCode = @DC_ERR_INVALID_EMPTY_REPOSITORY_NAME
			SET @o_errorString = 'Empty repository name'
			GOTO PROC_EXIT
		END
		IF @createdBy = 0
		BEGIN
			SET @o_errorCode = @DC_ERR_EMPTY_CREATOR_OR_MODIFIER_USER
			SET @o_errorString = 'Empty created by user information'
			GOTO PROC_EXIT
		END
	END
	IF ((@repositoryId <> 0 and NOT EXISTS(SELECT PackageRepositoryId FROM DCPackageRepository where PackageRepositoryId=@repositoryId)) OR
		(@attribute = @DC_ATTRIBUTE_SOFT_DELETED and @repositoryId = 0))
	BEGIN
		SET @o_errorCode = @DC_ERR_INVALID_REPOSITORY_ID
		SET @o_errorString = 'Invalid RepositoryId [' + CAST (@repositoryId AS VARCHAR(50))  + '] for opType/attribute [' + CAST (@attribute AS VARCHAR(50))  + ']'
		GOTO PROC_EXIT
	END
	IF @serverType = @DC_SERVER_TYPE_WEBSERVER and @clientId IS NOT NULL and NOT EXISTS(select id from APP_Client where id=@clientId)
	BEGIN
		SET @o_errorCode = @DC_ERR_INVALID_CLIENT_ID
		SET @o_errorString = 'Invalid clientId ['+  CAST (@clientId AS VARCHAR(50))  +']'
		GOTO PROC_EXIT
	END
	IF @serverType = @DC_SERVER_TYPE_NETWORK and @networkPath = ''
	BEGIN
		SET @o_errorCode = @DC_ERR_EMPTY_NWK_REPOSITORY_PATH
		SET @o_errorString = 'Empty network path for repository ['+  CAST (@repositoryName AS VARCHAR(50))  +']'
		GOTO PROC_EXIT
	END
	IF @serverType = @DC_SERVER_TYPE_NETWORK and @domainAndUserName is null
	BEGIN
		SET @o_errorCode = @DC_ERR_EMPTY_NWK_REPOSITORY_USER_CRED
		SET @o_errorString = 'Empty user credentials for network repository ['+  CAST (@repositoryName AS VARCHAR(50))  +']'
		GOTO PROC_EXIT
	END
	IF (@repositoryId = 0 and @attribute= @DC_ATTRIBUTE_ADMIN_SAVED and EXISTS (SELECT PackageRepositoryId FROM DCPackageRepository where RepositoryName=@repositoryName))
	OR (@repositoryId > 0 and @attribute= @DC_ATTRIBUTE_ADMIN_SAVED
		and EXISTS (SELECT 1 FROM DCPackageRepository WHERE RepositoryName = @repositoryName and PackageRepositoryId <> @repositoryId)
		and EXISTS (SELECT 1 FROM DCPackageRepository WHERE RepositoryName <> @repositoryName and PackageRepositoryId = @repositoryId)
		)
	begin
		SET @o_errorCode = @DC_ERR_REPOSITORY_ALREADY_EXISTS
		SET @o_errorString = 'Repository ['+ CAST (@repositoryName AS VARCHAR(50)) + '] already added before'
		goto proc_exit
	end
	IF @serverType = @DC_SERVER_TYPE_NETWORK and @repositoryId = 0 and @attribute= @DC_ATTRIBUTE_ADMIN_SAVED and EXISTS (SELECT PackageRepositoryId FROM DCPackageRepository where ClientId=@clientId)
	begin
		SET @o_errorCode = @DC_ERR_REPOSITORY_ALREADY_EXISTS
		SET @o_errorString = 'Repository for clientId ['+  CAST (@clientId AS VARCHAR(50))  + '] already added before'
		goto proc_exit
	end
	--end validation check
	IF @attribute = @DC_ATTRIBUTE_ADMIN_SAVED
	BEGIN
			--insert new dc package repository
		IF @repositoryId = 0
		BEGIN
			INSERT INTO DCPackageRepository (RepositoryType, ClientId, NetworkPath, virtualPath, DomainUserName, Password, RepositoryName,  CreatedBy, Attribute, CreateTime, ModifiedTime, ExtraProperties)
			VALUES (@serverType, @clientId, @networkPath, @virtualPath, @domainAndUserName, @encodedPassword, @repositoryName, @createdBy, @attribute, dbo.GetDateTime(@createTime), null, @extraProperties)
		END
			--HANDLE UPDATE
		ELSE IF @repositoryId <> 0
		BEGIN
			UPDATE DCPackageRepository
			SET ModifiedTime = dbo.GetDateTime(@modifiedTime),
				DomainUserName = @domainAndUserName,
				Password =  CASE WHEN @encodedPassword IS NULL THEN PassWord ELSE @encodedPassword END,
				CreatedBy = @createdBy,
				RepositoryName = @repositoryName,
				NetworkPath = @networkPath,
				ExtraProperties=@extraProperties
			WHERE PackageRepositoryId = @repositoryId
		END
	END
	ELSE IF @attribute = @DC_ATTRIBUTE_SOFT_DELETED
	BEGIN
		--HANDLE DELETION
		IF @repositoryId <> 0
		BEGIN
			-- Per MR 173499, let us not delete entire package and rather only locations that are using repository that is being deleted.
			--
			DELETE FROM DCPackagePlatform
            WHERE PackageRepositoryId = @repositoryId
			--
			--MR 140573
			--Download Center: Failing to delete repository when there is a read me associated
			UPDATE  PP
			SET ReadMeRepositoryId  = NULL,
				ReadMeLocation = '',
				ReadMePreviewStatus = 0,
				ReadMeUpdatedTime = GETUTCDATE()
            FROM DCPackagePlatform PP
            WHERE PP.ReadMeRepositoryId = @repositoryId
			--
			-- clean-up packages where no platforms exist
			--
			DELETE FROM DCPackage
			WHERE PackageId NOT IN (
				SELECT DISTINCT PackageId FROM DCPackagePlatform
			)
			--
			-- Final repository deletion
			--
			DELETE DC
			FROM DCPackageRepository DC
			WHERE PackageRepositoryId = @repositoryId
		END
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @o_errorCode = ERROR_NUMBER()
	SET @o_errorString = ERROR_MESSAGE()
END CATCH
PROC_EXIT:
IF @o_errorCode <> 0
	ROLLBACK TRAN
ELSE
	COMMIT TRAN
SELECT @o_errorCode, @o_errorString
GO

IF EXISTS (select * from GxQscripts where name = 'DCRepositoryConfiguration')
	delete from GxQscripts where name = 'DCRepositoryConfiguration'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DCRepositoryConfiguration')
	delete from GXDBVersions where aliasname = 'DCRepositoryConfiguration'
GO

insert into GXDBVersions values(2, 'DCRepositoryConfiguration',  '00010007000200050000', 'DCRepositoryConfiguration', '00010007000200050000')
GO

