

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DCReassociatePackages.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  DCReassociatePackages()
--  | Description: reassociate packages form one enity to another enity
--  +========================================================================+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DCReassociatePackages <<<'

IF EXISTS (select * from sysobjects where name='DCReassociatePackages')
	drop procedure DCReassociatePackages
IF EXISTS (select * from GxQscripts where name='DCReassociatePackages')
	delete from GxQscripts where name = 'DCReassociatePackages'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DCReassociatePackages')
	delete from GXDBVersions where aliasname = 'DCReassociatePackages'
GO
print '... Creating Procedure: DCReassociatePackages'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DCReassociatePackages
  @oldEntityId INT, 
  @newEntityId INT,
  @entityType INT
AS
BEGIN
DECLARE @errCode INT = 0
DECLARE @retMsg varchar(max) = 'Package reassociated successfully'
DECLARE @cnt INT = 0
DECLARE @ErrorMessage NVARCHAR(4000);
DECLARE @ErrorSeverity INT;
DECLARE @ErrorState INT;
		IF @entityType = 0
		BEGIN
		IF @oldEntityId = NULL or @oldEntityId =0 or @newEntityId = NULL or @newEntityId = 0
		SELECT @errCode = 10005, @retMsg = 'Category name not provided'
		ELSE
		BEGIN
		BEGIN TRY
			BEGIN TRAN
			UPDATE DCPackage SET SubCategoryId = NULL,CategoryId = @newEntityId WHERE CategoryId = @oldEntityId
			DELETE FROM DCSubCategory WHERE CategoryId = @oldEntityId
			DELETE FROM DCCategory WHERE CategoryId = @oldEntityId
			SELECT @cnt = @@ROWCOUNT
			IF @cnt = 0
				SELECT @errCode = 10006, @retMsg = 'No rows deleted. Category specified is invalid.'
			COMMIT TRAN
		END TRY
		BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		ROLLBACK TRAN
		SELECT @ErrorMessage = ERROR_MESSAGE(),@ErrorSeverity = ERROR_SEVERITY(),@ErrorState = ERROR_STATE();
		RAISERROR (@ErrorMessage,@ErrorSeverity,@ErrorState);
		END CATCH
		END
		END
		ELSE IF @entityType = 1
		BEGIN
		IF @oldEntityId = NULL or @oldEntityId =0 or @newEntityId = NULL or @newEntityId = 0
		SELECT @errCode = 10022, @retMsg = 'SubCategory name not provided'
		ELSE
		BEGIN
		BEGIN TRY
			BEGIN TRAN
			UPDATE DCPackage SET SubCategoryId = @newEntityId WHERE SubCategoryId = @oldEntityId
			DELETE FROM DCSubCategory WHERE SubCategoryId = @oldEntityId
			SELECT @cnt = @@ROWCOUNT
			IF @cnt = 0
				SELECT @errCode = 10021, @retMsg = 'No rows deleted. Sub Category specified is invalid.'
			COMMIT TRAN
		END TRY
		BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		ROLLBACK TRAN
		SELECT @ErrorMessage = ERROR_MESSAGE(),@ErrorSeverity = ERROR_SEVERITY(),@ErrorState = ERROR_STATE();
		RAISERROR (@ErrorMessage,@ErrorSeverity,@ErrorState);
		END CATCH
		END
		END
	IF @errCode <> 0 AND ISNULL(@retMsg, '') = ''
		SELECT @retMsg = ISNULL(Text, 'Unexpected error occurred') FROM SYS.messages where message_id = @errCode
	SELECT @errCode AS ReturnCode, @retMsg AS ReturnMessage, @newEntityId AS ReturnId
END
GO

IF EXISTS (select * from GxQscripts where name = 'DCReassociatePackages')
	delete from GxQscripts where name = 'DCReassociatePackages'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DCReassociatePackages')
	delete from GXDBVersions where aliasname = 'DCReassociatePackages'
GO

insert into GXDBVersions values(2, 'DCReassociatePackages',  '00000000000000000000', 'DCReassociatePackages', '00000000000000000000')
GO

