

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DCPackageValidation.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  DCPackageValidation()
--  | Description:  Save (insert or update) package information
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DCPackageValidation.sp,v $ $Id: DCPackageValidation.sp,v 1.4.2.7 2020/06/25 03:53:11 sgolla Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='DCPackageValidation')
BEGIN
	print '>>> Drop Stored Procedure: DCPackageValidation <<<'
	drop procedure DCPackageValidation
END
IF EXISTS (select * from GxQscripts where name='DCPackageValidation')
	delete from GxQscripts where name = 'DCPackageValidation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DCPackageValidation')
	delete from GXDBVersions where aliasname = 'DCPackageValidation'
GO
print '... Creating Procedure: DCPackageValidation'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DCPackageValidation
  @dcPackageXML XML,
  @packageID INT OUT,
  @packageName NVARCHAR(255) OUT,		-- Mandatory
  @errorCode INT OUT, 
  @errorMessage NVARCHAR(max) OUT,
  @categoryID INT OUT,				-- Mandatory
  @subCategoryID INT OUT,				-- Mandatory
  @versionID INT OUT, 
  @recutNumberID INT OUT, 
  @vendorID INT OUT,
  @validFrom DATETIME OUT,			-- Mandatory
  @validTo DATETIME OUT
AS
BEGIN
	SET QUOTED_IDENTIFIER ON
	SET NOCOUNT ON
	select @errorCode = 0, @packageID = 0
	declare
	@invalidServerID		INT = 10032,
	@invalidPlatformID		INT = 10033,
	@invalidCategoryId		INT = 10034,
	@invalidSubCategoryId	INT = 10035,
	@invalidDownloadTypeID	INT = 10036,
	@invalidVersionID		INT = 10037,
	@invalidRecutNumberID	INT = 10038,
	@invalidVendorID		INT = 10040,
	@invalidPackageID		INT = 10041,
	@invalidPackageName		INT = 10042,
	@packageNameAlreadyUsed	INT = 10043,
	@invalidLocation		INT = 10044,
	@invalidStartDate		INT = 10045,
	@invalidEndDate			INT = 10046,
	@invalidPlatformForPkg	INT = 10047,
	@nameLengthLimitReached	INT = 10053,
	@repeatingPlatform		INT = 10058
	DECLARE
	@StartUnixTime			BIGINT,
	@EndUnixTime			BIGINT,
	@PackageNameMaxLength	INT,
	@IsPkgPlatformTableLocal	INT = 0
	SELECT @PackageNameMaxLength = CHARACTER_MAXIMUM_LENGTH FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'DCPackage' AND COLUMN_NAME = 'PackageName'
	-- MANDATORY FIELDS BEGIN
	set @categoryID = isnull(@dcPackageXML.value('(App_DCPackage/category/@id)[1]', 'int'), 0)
	if @categoryID = 0
	BEGIN
		select @errorCode = @invalidCategoryId, @errorMessage = 'Missing or empty categoryID'
	END
	ELSE
	BEGIN
		if not exists(select top(1) * from DCCategory where CategoryId = @categoryID)
		BEGIN
			select @errorCode = @invalidCategoryId, @errorMessage = 'Invalid categoryID'
		END
	END
	if @errorCode = 0
	BEGIN
		set @subCategoryID = @dcPackageXML.value('(App_DCPackage/subCategory/@id)[1]', 'int')
		if @subCategoryID != 0
		BEGIN
			if not exists(select top(1) * from DCSubCategory where SubCategoryId = @subCategoryID and CategoryId = @categoryID)
			BEGIN
				select @errorCode = @invalidSubCategoryId, @errorMessage = 'Invalid subCategoryID'
			END
		END
	END
	ELSE
	BEGIN
		goto Terminate
	END
	if @errorCode = 0
	BEGIN
		select @StartUnixTime = ISNULL(@dcPackageXML.value('(App_DCPackage/@validFrom)[1]', 'int'), dbo.GetUnixTime(GetUTCDate())), @EndUnixTime = ISNULL(@dcPackageXML.value('(App_DCPackage/@validTo)[1]', 'int'), dbo.GetUnixTime('2038-01-19T03:14:07Z'))
		if @StartUnixTime = 0
		BEGIN
			select @errorCode = @invalidStartDate, @errorMessage = 'Invalid package start date'
		END
		ELSE
		BEGIN
			set @validFrom = dbo.GetDateTime(@StartUnixTime)
			set @validTo = dbo.GetDateTime(@EndUnixTime)
		END
	END
	if @errorCode = 0
	BEGIN
		set @packageID = isnull(@dcPackageXML.value('(App_DCPackage/@packageId)[1]', 'int'), 0)
		if(@packageID > 0)
		BEGIN
			if not exists(select PackageId from DCPackage where PackageId = @packageID)
			BEGIN
				select @errorCode = @invalidPackageID, @errorMessage = 'Invalid packageID'
			END
		END
	END
	ELSE
	BEGIN
		goto Terminate
	END
	if @errorCode = 0
	BEGIN
		set @versionID = isnull(@dcPackageXML.value('(App_DCPackage/productVersion/@id)[1]', 'int'), 0)
		if @versionID = 0
		BEGIN
			select @errorCode = @invalidPackageName, @errorMessage = 'Invalid or empty versionID'
		END
		ELSE IF not exists(select top(1) * from DCProductVersion where ProductVersionId = @versionID)
			BEGIN
				select @errorCode = @invalidVersionID, @errorMessage = 'Invalid productVersionID'
			END
		END
	ELSE
	BEGIN
		goto Terminate
	END
	if @errorCode = 0
	BEGIN
		DECLARE @allowMultipleVersions nvarchar(max)
		SELECT @allowMultipleVersions = value FROM GXGlobalParam WITH (NOLOCK) WHERE name = 'AllowMultipleDCPackageVerisons'
		set @packageName = isnull(@dcPackageXML.value('(App_DCPackage/@name)[1]', 'nvarchar(255)'), '')
		if @packageName = ''
		BEGIN
			select @errorCode = @invalidPackageName, @errorMessage = 'Invalid or empty package name'
		END
		ELSE IF LEN(@packageName) > @PackageNameMaxLength
		BEGIN
			select @errorCode = @nameLengthLimitReached, @errorMessage = 'Package name length limit of ' + @PackageNameMaxLength + ' characters exceeded'
		END
		ELSE IF (ISNULL(@allowMultipleVersions, '0') = '1') -- Multiple Versions allowed
		BEGIN
			IF EXISTS (SELECT PackageName FROM DCPackage WHERE PackageName = @packageName AND ProductVersionId = @versionID AND PackageStatus <> 1 AND PackageId <> @packageId)	-- PackageStatus = 1 is for deleted packages
			BEGIN
				select @errorCode = @packageNameAlreadyUsed, @errorMessage = 'Package name is already used by another package'
			END
		END
		ELSE IF EXISTS(SELECT PackageName FROM DCPackage WHERE PackageName = @packageName AND PackageStatus <> 1 AND PackageID <> @packageID)
		BEGIN
			select @errorCode = @packageNameAlreadyUsed, @errorMessage = 'Package name is already used by another package'
		END
	END
	ELSE
	BEGIN
		goto Terminate
	END
	-- MANDATORY FIELDS END
	if @errorCode = 0
	BEGIN
		set @recutNumberID = isnull(@dcPackageXML.value('(App_DCPackage/recutNumber/@id)[1]', 'int'), 0)
		if @recutNumberID > 0
		BEGIN
			if not exists(select top(1) * from DCRecutNumber where RecutNumberId = @recutNumberID)
			BEGIN
				select @errorCode = @invalidRecutNumberID, @errorMessage = 'Invalid recutNumberID'
			END
		END
	END
	ELSE
	BEGIN
		goto Terminate
	END
	if @errorCode = 0
	BEGIN
		set @vendorID = isnull(@dcPackageXML.value('(App_DCPackage/vendor/@id)[1]', 'int'), 0)
		if @vendorID > 0
		BEGIN
			if not exists(select top(1) * from DCVendor where VendorId = @vendorID)
			BEGIN
				select @errorCode = @invalidVendorID, @errorMessage = 'Invalid vendorID'
			END
		END
	END
	ELSE
	BEGIN
		goto Terminate
	END
	IF OBJECT_ID('tempdb.dbo.#PackagePlatformTable') IS NULL
	BEGIN
		SET @IsPkgPlatformTableLocal = 1
CREATE TABLE #PackagePlatformTable (
	PlatformId			INT,
	serverId			INT,
	DownloadTypeId		INT,
	DownloadAction		INT,
	Size				BIGINT,
	Location			NVARCHAR(MAX),
	ReadmeLocation		NVARCHAR(MAX),
	ReadmeRepositoryId 	INT,
	PackageCheckSum		varchar(36)
	)
	END
	INSERT INTO #PackagePlatformTable (serverId, PlatformId, Location, DownloadTypeId, DownloadAction, Size, ReadmeLocation, ReadmeRepositoryId, PackageCheckSum)
	select ref.value('(pkgRepository/@repositoryId)[1]', 'int'), ref.value('@id', 'int'), ref.value('@location', 'nvarchar(max)'), ref.value('(downloadType/@id)[1]', 'int'), isnull(ref.value('@downloadAction', 'int'), 0),
	ref.value('@size', 'bigint'), ref.value('@readMeLocation', 'nvarchar(max)'), ref.value('(readmeRepository/@repositoryId)[1]', 'int'), ref.value('@checksum', 'varchar(36)')
	FROM @dcPackageXML.nodes('/App_DCPackage/platforms') T(ref)
	-- Mandatory fields in platform child table:	serverId, PlatformId, Location, DownloadTypeId
	if not exists(select PlatformId from #PackagePlatformTable)
	BEGIN
		select @errorCode = @invalidPlatformForPkg, @errorMessage = 'No platform set for package'
		goto Terminate
	END
	if @errorCode = 0
	BEGIN
		if exists(select * from #PackagePlatformTable where serverId IS NULL OR serverId <= 0)
		BEGIN
			select @errorCode = @invalidServerID, @errorMessage = 'Invalid serverID'
		END
		ELSE
		BEGIN
			if exists(select distinct(serverId) from #PackagePlatformTable where serverId NOT IN(select distinct(PackageRepositoryId) from DCPackageRepository))
			BEGIN
				select @errorCode = @invalidServerID, @errorMessage = 'Invalid serverID'
			END
		END
	END
	ELSE
	BEGIN
		goto Terminate
	END
	if @errorCode = 0
	BEGIN
		if exists(select * from #PackagePlatformTable where PlatformId IS NULL OR PlatformId <= 0)
		BEGIN
			select @errorCode = @invalidPlatformID, @errorMessage = 'Invalid platformID'
		END
		ELSE IF exists(select distinct(A.PlatformId) from #PackagePlatformTable A where A.PlatformId NOT IN(select distinct(B.PlatformId) from DCPlatform B))
		BEGIN
			select @errorCode = @invalidPlatformID, @errorMessage = 'Invalid platformID'
		END
		ELSE IF exists(select PlatformId from #PackagePlatformTable group by PlatformId, DownloadTypeId having count(*) > 1)
		BEGIN
			select @errorCode = @repeatingPlatform, @errorMessage = 'Repeating combination of platform and download type.'
		END
	END
	ELSE
	BEGIN
		goto Terminate
	END
	if @errorCode = 0
	BEGIN
		if exists(select PlatformId from #PackagePlatformTable where ReadmeLocation is not null and ReadmeLocation <> '' and (ReadmeRepositoryId is null or ReadmeRepositoryId <= 0))
		BEGIN
			select @errorCode = @invalidServerID, @errorMessage = 'Invalid or empty readmeServerID'
		END
		ELSE if exists(select distinct(ReadmeRepositoryId) from #PackagePlatformTable where ReadmeRepositoryId NOT IN(select distinct(PackageRepositoryId) from DCPackageRepository))
		BEGIN
			select @errorCode = @invalidServerID, @errorMessage = 'Invalid readmeServerID'
		END
	END
	ELSE
	BEGIN
		goto Terminate
	END
	if @errorCode = 0
	BEGIN
		if exists(select * from #PackagePlatformTable where location IS NULL or location = '')
		BEGIN
			select @errorCode = @invalidLocation, @errorMessage = 'Invalid package location'
		END
	END
	ELSE
	BEGIN
		goto Terminate
	END
	if @errorCode = 0
	BEGIN
		if exists(select * from #PackagePlatformTable where DownloadTypeId IS NULL or DownloadTypeId <= 0)
		BEGIN
			select @errorCode = @invalidDownloadTypeID, @errorMessage = 'Invalid downloadTypeID'
		END
		ELSE
		BEGIN
			if exists(select distinct(A.DownloadTypeId) from #PackagePlatformTable A where A.DownloadTypeId NOT IN(select distinct(B.DownloadTypeId) from DCDownloadType B))
			BEGIN
				select @errorCode = @invalidDownloadTypeID, @errorMessage = 'Invalid downloadTypeID'
			END
		END
	END
Terminate:
IF @IsPkgPlatformTableLocal = 1
BEGIN
	DROP table #PackagePlatformTable
END
END
GO

IF EXISTS (select * from GxQscripts where name = 'DCPackageValidation')
	delete from GxQscripts where name = 'DCPackageValidation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DCPackageValidation')
	delete from GXDBVersions where aliasname = 'DCPackageValidation'
GO

insert into GXDBVersions values(2, 'DCPackageValidation',  '00010004000200070000', 'DCPackageValidation', '00010004000200070000')
GO

