

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/DCGetUserPackageVisibility.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  DCGetUserPackageVisibility()
--  | Description:  Find visible to, early preview status of each package and return the flags against each package
--	| Inputs: 1. Comma seperated List of GUIDS: User GUID & Group Guids. 2. Comma seperated list of package IDs
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/DCGetUserPackageVisibility.sp,v $ $Id: DCGetUserPackageVisibility.sp,v 1.3.56.1 2018/03/27 09:08:26 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DCGetUserPackageVisibility <<<'

IF EXISTS (select * from sysobjects where name='DCGetUserPackageVisibility')
	drop procedure DCGetUserPackageVisibility
IF EXISTS (select * from GxQscripts where name='DCGetUserPackageVisibility')
	delete from GxQscripts where name = 'DCGetUserPackageVisibility'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DCGetUserPackageVisibility')
	delete from GXDBVersions where aliasname = 'DCGetUserPackageVisibility'
GO
print '... Creating Procedure: DCGetUserPackageVisibility'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DCGetUserPackageVisibility
  @UserAndGroupGuids VARCHAR(MAX),
  @PackageIdList VARCHAR(MAX)
AS
BEGIN
--Declare local vars
DECLARE @VisibleToFlag INT
DECLARE @EarlyPreviewFlag INT
--Init local vars
SELECT @VisibleToFlag = EntryValue FROM DCReference
WHERE TypeName = 'PackageUserFlag' AND EntryName = N'VisibleTo'
SELECT @EarlyPreviewFlag = EntryValue FROM DCReference
WHERE TypeName = 'PackageUserFlag' AND EntryName = N'EarlyPreviewUsers'
SELECT P._ID AS PackageId, (CASE WHEN PV.VisbilityFlags IS NOT NULL AND PV.VisbilityFlags & @VisibleToFlag = @VisibleToFlag THEN 1 ELSE 0 END) AS IsVisibleTo,
(CASE WHEN PV.VisbilityFlags IS NOT NULL AND PV.VisbilityFlags & @EarlyPreviewFlag = @EarlyPreviewFlag THEN 1 ELSE 0 END) IsEarlyPreview
FROM dbo.SplitString(@UserAndGroupGuids, ',') G
CROSS APPLY dbo.SplitIDs(@PackageIdList) P
JOIN DCPackageVisibility PV ON P._ID = PV.PackageId AND G.Data = PV.SecuredEntityGuid
END
GO

IF EXISTS (select * from GxQscripts where name = 'DCGetUserPackageVisibility')
	delete from GxQscripts where name = 'DCGetUserPackageVisibility'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DCGetUserPackageVisibility')
	delete from GXDBVersions where aliasname = 'DCGetUserPackageVisibility'
GO

insert into GXDBVersions values(2, 'DCGetUserPackageVisibility',  '00010003005600010000', 'DCGetUserPackageVisibility', '00010003005600010000')
GO

